/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindJSPWriter;
import com.evermind.server.http.JspCommonExtraWriter;
import com.evermind.util.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import sun.io.CharToByteConverter;

public class EvermindBodyContent
extends BodyContent
implements JspCommonExtraWriter {
    private static final char[] TRUE_ARRAY = "true".toCharArray();
    private static final char[] FALSE_ARRAY = "false".toCharArray();
    protected JspWriter enclosingWriter;
    private Writer writer;
    protected byte[] buffer;
    protected int pos;
    private String characterEncoding;
    private int characterEncodingCode = 0;
    static Class sunCTBConverter = null;
    private CharToByteConverter ctbConverter;
    private boolean ctbConverterInit = false;
    private String ctbConverterEncoding;
    private String ctbConverterEncodingAlias;
    private int ctbConverterMaxBytesPerChar;
    private byte[] newLineBytes = null;
    protected boolean printNullStr;

    public EvermindBodyContent() {
        super(null);
    }

    public Reader getReader() {
        if (this.writer != null) {
            throw new IllegalStateException("Writer is set in bodycontent");
        }
        if (this.buffer == null) {
            this.buffer = new byte[100];
        }
        try {
            if (this.characterEncoding == null) {
                return new InputStreamReader(new ByteArrayInputStream(this.buffer, 0, this.pos));
            }
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.buffer, 0, this.pos), this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void writeOut(Writer out) throws IOException {
        if (this.writer == null) {
            if (this.buffer == null) {
                return;
            }
            if (out instanceof EvermindBodyContent) {
                ((EvermindBodyContent)((Object)out)).write(this.buffer, 0, this.pos);
            } else if (out instanceof EvermindJSPWriter) {
                ((EvermindJSPWriter)((Object)out)).write(this.buffer, 0, this.pos);
            } else {
                out.write(this.characterEncoding == null ? new String(this.buffer, 0, this.pos) : new String(this.buffer, 0, this.pos, this.characterEncoding));
            }
        } else {
            throw new IllegalStateException("Writer is set in bodycontent");
        }
    }

    public String getString() {
        if (this.writer != null) {
            throw new IllegalStateException("Writer is set in bodycontent");
        }
        if (this.buffer == null) {
            return "";
        }
        try {
            return this.characterEncoding == null ? new String(this.buffer, 0, this.pos) : new String(this.buffer, 0, this.pos, this.characterEncoding);
        }
        catch (IOException e) {
            return new String(this.buffer, 0, this.pos);
        }
    }

    protected void reset() {
        this.buffer = new byte[100];
        this.pos = 0;
    }

    public void clearBody() {
        this.pos = 0;
        this.ctbConverterInit = false;
        this.newLineBytes = null;
    }

    public void clearBuffer() {
        this.pos = 0;
    }

    public void clear() {
        this.pos = 0;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void flush() throws IOException {
        throw new IOException("InValid to flush BodyContent: no backing stream behind it ");
    }

    public int getBufferSize() {
        if (this.writer == null) {
            return this.pos;
        }
        if (this.writer instanceof JspWriter) {
            return ((JspWriter)this.writer).getBufferSize();
        }
        return 0;
    }

    public int getRemaining() {
        return 0;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void newLine() throws IOException {
        try {
            if (this.newLineBytes == null) {
                this.newLineBytes = this.characterEncoding == null ? System.getProperty("line.separator").getBytes() : System.getProperty("line.separator").getBytes(this.characterEncoding);
            }
            if (this.writer != null) {
                this.writer.write(System.getProperty("line.separator"));
            } else {
                this.write(this.newLineBytes);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.write((byte)13);
            this.write((byte)10);
        }
    }

    public void print(boolean b) throws IOException {
        if (this.writer != null) {
            this.writer.write(b ? "true" : "false");
        } else {
            this.write(b ? EvermindJSPWriter.TRUE_ARRAY : EvermindJSPWriter.FALSE_ARRAY);
        }
    }

    public void print(char[] c) throws IOException {
        if (this.writer != null) {
            this.writer.write(c);
        } else {
            this.print(c, 0, c.length);
        }
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int offset, int length) {
        this.assureSpace(length);
        System.arraycopy(b, offset, this.buffer, this.pos, length);
        this.pos += length;
    }

    private final void assureSpace(int length) {
        if (this.buffer == null) {
            this.buffer = new byte[200];
        }
        while (length > this.buffer.length - this.pos) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    public void print(char[] array, int offset, int length) throws IOException {
        if (array == null) {
            return;
        }
        if (offset < 0 || offset > array.length || offset + length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (array.length == 0 || length == 0) {
            return;
        }
        if (this.writer != null) {
            this.writer.write(new String(array, offset, length));
            return;
        }
        this.assureSpace(length);
        if (this.characterEncoding == null || this.characterEncodingCode == -1) {
            ArrayUtils.copyArray(array, offset, this.buffer, this.pos, length);
            this.pos += length;
            return;
        }
        if (this.characterEncodingCode == -2) {
            this.javaCharsToAL32UTF8(array, offset, length);
        } else {
            this.print(new String(array, offset, length));
        }
    }

    public void print(String string) throws IOException {
        int stringLength;
        if (string == null) {
            if (this.printNullStr) {
                string = "null";
            } else {
                return;
            }
        }
        if ((stringLength = string.length()) == 0) {
            return;
        }
        if (this.writer != null) {
            this.writer.write(string);
            return;
        }
        this.assureSpace(stringLength);
        if (this.characterEncoding == null || this.characterEncodingCode == -1) {
            for (int i = 0; i < stringLength; ++i) {
                char v = string.charAt(i);
                this.buffer[this.pos++] = (byte)(v > '\u00ff' ? 63 : (int)v);
            }
            return;
        }
        if (this.characterEncodingCode == -2) {
            this.javaCharsToAL32UTF8(string, 0, stringLength);
        } else {
            if (sunCTBConverter != null) {
                this.getCTBConverter();
            }
            if (this.ctbConverter != null) {
                this.assureSpace(stringLength * this.ctbConverterMaxBytesPerChar);
                this.pos += this.ctbConverter.convertAny(string.toCharArray(), 0, stringLength, this.buffer, this.pos, this.buffer.length);
            } else {
                this.write(string.getBytes(this.characterEncoding));
            }
        }
    }

    public void print(double v) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(v));
        } else {
            this.print(String.valueOf(v));
        }
    }

    public void print(long v) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(v));
        } else {
            this.print(String.valueOf(v));
        }
    }

    public void print(float v) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(v));
        } else {
            this.print(String.valueOf(v));
        }
    }

    public void print(int v) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(v));
        } else {
            this.assureSpace(20);
            this.pos = ArrayUtils.writeInt(this.buffer, this.pos, v);
        }
    }

    public void print(Object o) throws IOException {
        if (this.writer != null) {
            if (o == null) {
                if (this.printNullStr) {
                    this.writer.write("null");
                    return;
                }
                return;
            }
            this.writer.write(o.toString());
        } else {
            if (o == null) {
                if (this.printNullStr) {
                    this.print("null");
                    return;
                }
                return;
            }
            this.print(o.toString());
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            char[] ca = new char[]{c};
            this.write(ca, 0, 1);
        }
    }

    public void write(byte c) {
        this.assureSpace(1);
        this.buffer[this.pos++] = c;
    }

    public void println(double v) throws IOException {
        this.print(v);
        this.newLine();
    }

    public void println(long v) throws IOException {
        this.print(v);
        this.newLine();
    }

    public void println(float v) throws IOException {
        this.print(v);
        this.newLine();
    }

    public void println(int v) throws IOException {
        this.print(v);
        this.newLine();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.newLine();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.newLine();
    }

    public void println(char v) throws IOException {
        this.print(v);
        this.newLine();
    }

    public void println(char[] v) throws IOException {
        this.print(v);
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void write(char[] c) throws IOException {
        this.print(c);
    }

    public void write(char[] c, int offset, int length) throws IOException {
        this.print(c, offset, length);
    }

    public void write(int i) throws IOException {
        this.print((char)i);
    }

    public void writeByte(int i) {
        this.assureSpace(1);
        this.buffer[this.pos++] = (byte)i;
    }

    public void write(String s) throws IOException {
        this.print(s);
    }

    public void write(String s, int offset, int length) throws IOException {
        if (this.writer != null) {
            this.writer.write(s, offset, length);
        } else {
            this.write(s.substring(offset, length + offset).getBytes());
        }
    }

    public void setEnclosingWriter(JspWriter writer) {
        this.enclosingWriter = writer;
    }

    public JspWriter getEnclosingWriter() {
        return this.enclosingWriter;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
        if (characterEncoding == null) {
            return;
        }
        this.characterEncodingCode = characterEncoding.equalsIgnoreCase("iso-8859-1") || characterEncoding.equalsIgnoreCase("iso8859_1") ? -1 : (characterEncoding.equalsIgnoreCase("utf-8") || characterEncoding.equalsIgnoreCase("utf8") ? -2 : 0);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    private void getCTBConverter() throws UnsupportedEncodingException {
        if (this.ctbConverter != null && (this.ctbConverterEncoding.equalsIgnoreCase(this.characterEncoding) || this.ctbConverterEncodingAlias.equalsIgnoreCase(this.characterEncoding))) {
            if (this.ctbConverterInit) {
                return;
            }
            this.ctbConverter.reset();
        } else {
            this.ctbConverter = CharToByteConverter.getConverter((String)this.characterEncoding);
            this.ctbConverterEncoding = this.ctbConverter.getCharacterEncoding();
            this.ctbConverterEncodingAlias = this.characterEncoding;
            this.ctbConverterMaxBytesPerChar = this.ctbConverter.getMaxBytesPerChar();
        }
        this.ctbConverterInit = true;
    }

    int javaCharsToAL32UTF8(String string, int chars_offset, int chars_count) throws IOException {
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        boolean allocated = false;
        for (int i = chars_begin; i < chars_end; ++i) {
            char c;
            if (!allocated && this.buffer.length - this.pos < 3) {
                this.assureSpace((chars_end - i) * 3);
                allocated = true;
            }
            if ((c = string.charAt(i)) >= '\u0000' && c <= '\u007f') {
                this.buffer[this.pos++] = (byte)c;
                continue;
            }
            if (c >= '\ud800' && c <= '\udb00') {
                char c2;
                if (i + 1 >= chars_end || !((c2 = string.charAt(i + 1)) >= '\udc00' & c2 <= '\udf00')) continue;
                int uuuuu = (c >> 6 & 0xF) + 1;
                this.buffer[this.pos++] = (byte)(uuuuu >> 2 | 0xF0);
                this.buffer[this.pos++] = (byte)((uuuuu & 3) << 4 | c >> 2 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)((c & 3) << 4 | c2 >> 6 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)(c2 & 0x3F | 0x80);
                ++i;
                continue;
            }
            if (c > '\u07ff') {
                this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return this.pos;
    }

    int javaCharsToAL32UTF8(char[] chars, int chars_offset, int chars_count) throws IOException {
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        boolean allocated = false;
        for (int i = chars_begin; i < chars_end; ++i) {
            char c;
            if (!allocated && this.buffer.length - this.pos < 3) {
                this.assureSpace((chars_end - i) * 3);
                allocated = true;
            }
            if ((c = chars[i]) >= '\u0000' && c <= '\u007f') {
                this.buffer[this.pos++] = (byte)c;
                continue;
            }
            if (c >= '\ud800' && c <= '\udb00') {
                char c2;
                if (i + 1 >= chars_end || !((c2 = chars[i + 1]) >= '\udc00' & c2 <= '\udf00')) continue;
                int uuuuu = (c >> 6 & 0xF) + 1;
                this.buffer[this.pos++] = (byte)(uuuuu >> 2 | 0xF0);
                this.buffer[this.pos++] = (byte)((uuuuu & 3) << 4 | c >> 2 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)((c & 3) << 4 | c2 >> 6 & 0xF | 0x80);
                this.buffer[this.pos++] = (byte)(c2 & 0x3F | 0x80);
                ++i;
                continue;
            }
            if (c > '\u07ff') {
                this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return this.pos;
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void setJspPrintNull(boolean printNullStr) {
        this.printNullStr = printNullStr;
    }

    static {
        try {
            sunCTBConverter = Class.forName("sun.io.CharToByteConverter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

