/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.ejb.EJBTransactionContext;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.logging.PersistenceMessages;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class XPCManager {
    private PersistenceUnitManager pm;
    private Map persistenceContextCache;

    public XPCManager(PersistenceUnitManager pm) {
        this.pm = pm;
    }

    public void addPersistenceContext(String persistenceUnitName, Object pc) {
        if (this.persistenceContextCache == null) {
            this.persistenceContextCache = new HashMap();
        }
        this.persistenceContextCache.put(persistenceUnitName, pc);
    }

    public Object getPersistenceContext(String persistenceUnitName) {
        if (this.persistenceContextCache == null) {
            return null;
        }
        return this.persistenceContextCache.get(persistenceUnitName);
    }

    public void closePersistenceContexts() {
        if (this.persistenceContextCache != null) {
            Iterator i = this.persistenceContextCache.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                this.pm.getPersistenceUnit(name).closePersistenceContext(this.persistenceContextCache.get(name));
            }
            this.persistenceContextCache.clear();
            this.persistenceContextCache = null;
        }
    }

    public void associatePersistenceContexts() {
        if (this.persistenceContextCache != null) {
            Iterator i = this.persistenceContextCache.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                Object pc = this.persistenceContextCache.get(name);
                try {
                    EJBTransactionContext context = EJBTransactionManager.getInstance().getOrCreateEJBTransactionContext();
                    Map map = context.getPersistenceContextMap();
                    Object current = map.get(name);
                    if (current != null) {
                        if (pc == current) continue;
                        throw new IllegalStateException("Cannot propagate persistence context " + pc + "; persistence context " + current + " already propagated");
                    }
                    PersistenceMessages.finerPPMPropagatePC(name, pc);
                    map.put(name, pc);
                    PersistenceUnit pu = this.pm.getPersistenceUnit(name);
                    pu.joinPersistenceContext(pc);
                }
                catch (SystemException e) {
                    throw EJBUtils.createEJBException((Exception)((Object)e));
                }
                catch (RollbackException e) {
                    throw EJBUtils.createEJBException((Exception)((Object)e));
                }
            }
        }
    }
}

