/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.naming.ContextUtils;
import com.evermind.server.deployment.InjectableReference;
import com.evermind.server.ejb.deployment.PersistenceContextReference;
import com.evermind.server.ejb.deployment.PersistenceUnitReference;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.logging.PersistenceMessages;
import com.evermind.server.ejb.persistence.PersistenceModule;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import com.evermind.server.ejb.persistence.PersistenceUnitImpl;
import com.evermind.server.ejb.persistence.PersistenceUnitInfoImpl;
import com.evermind.server.ejb.persistence.PersistenceUnitInfoXMLFactory;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.ejb.persistence.XPCProxyReference;
import com.evermind.util.ByteString;
import com.oracle.naming.J2EEContext;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.oc4j.configuration.J2EEContextDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitManagerImpl
implements PersistenceUnitManager {
    private static final String PERSISTENCE_XML_PATH = "META-INF/persistence.xml";
    protected PersistenceUnitManagerImpl parent;
    protected Collection<PersistenceUnitManager> children = new ArrayList<PersistenceUnitManager>();
    private Map<String, PersistenceUnit> persistenceUnits = new HashMap<String, PersistenceUnit>(1);
    private PersistenceModule persistenceModule;
    private boolean enableDefaultPersistenceUnit = false;

    public PersistenceUnitManagerImpl(PersistenceModule module, PersistenceUnitManager parent) {
        this.parent = (PersistenceUnitManagerImpl)parent;
        this.persistenceModule = module;
        if (parent != null) {
            this.parent.children.add(this);
        }
    }

    @Override
    public void initialize() {
        PersistenceMessages.fineInitializingPersistenceUnitManager(this.getPersistenceModule());
        for (Context persistenceRoot : this.getPersistenceModule().getPersistenceRoots()) {
            URL rootUrl = this.convertRootToURL(persistenceRoot);
            ByteString persistenceXml = this.readPersistenceXml(persistenceRoot, PERSISTENCE_XML_PATH);
            if (persistenceXml == null && rootUrl.toString().endsWith("WEB-INF/classes/") && (persistenceXml = this.readPersistenceXml(persistenceRoot, "../persistence.xml")) != null) {
                PersistenceMessages.fineUsingWebInfPersistenceXml(this.getPersistenceModule(), rootUrl.toString());
            }
            if (persistenceXml != null) {
                PersistenceMessages.fineParsingPersistenceXml(this.getPersistenceModule(), rootUrl.toString());
                Iterator persistenceUnitInfos = PersistenceUnitInfoXMLFactory.getInstance().parsePersistenceXML(this.getPersistenceModule().getContextId(), persistenceXml.data).iterator();
                while (persistenceUnitInfos.hasNext()) {
                    this.initializePersistenceUnit(rootUrl, (PersistenceUnitInfo)persistenceUnitInfos.next());
                }
                continue;
            }
            if (!this.isDefaultPersistenceUnitEnabled()) continue;
            PersistenceUnitInfoImpl defPersistenceUnitInf = new PersistenceUnitInfoImpl();
            PersistenceMessages.fineCreatingDefaultPersistenceUnit(this.getPersistenceModule());
            this.initializePersistenceUnit(rootUrl, defPersistenceUnitInf);
        }
    }

    private ByteString readPersistenceXml(Context persistenceRoot, String persistenceXmlPath) {
        try {
            return ContextUtils.readFromContextWithEmptyFile(persistenceRoot, persistenceXmlPath, true);
        }
        catch (InstantiationException e) {
            throw DeploymentException.exceptionParsingXml(this.getPersistenceModule().getContextId(), persistenceXmlPath, e);
        }
    }

    @Override
    public void destroy() {
        PersistenceMessages.fineDestroyingPersistenceUnitManager(this.getPersistenceModule());
        for (Map.Entry<String, PersistenceUnit> entry : this.getPersistenceUnits().entrySet()) {
            PersistenceUnit unit = entry.getValue();
            PersistenceMessages.fineClosingEntityManagerFactory(this.getPersistenceModule(), entry.getKey().toString());
            ((EntityManagerFactory)unit.getEntityManagerFactory()).close();
            String jndiName = this.getPersistenceModule().getName() + "/" + unit.getName();
            try {
                this.getPersistenceModule().getApplicationContext().unbind(jndiName);
            }
            catch (NamingException e) {
                PersistenceMessages.warningUnbindingEMF(this.getPersistenceModule(), jndiName, e);
            }
        }
        this.persistenceModule = null;
    }

    protected Map<String, PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePersistenceUnit(URL rootUrl, PersistenceUnitInfo info) {
        PersistenceModule module = this.getPersistenceModule();
        PersistenceMessages.fineInitializingEntityManagerFactory(module, info.getPersistenceUnitName(), info.getPersistenceProviderClassName());
        String unitName = info.getPersistenceUnitName();
        if (this.getPersistenceUnits().get(unitName) != null) {
            throw DeploymentException.multiplePersistenceUnitsWithSameName(module, unitName);
        }
        try {
            ((PersistenceUnitInfoImpl)info).initialize(module, rootUrl);
            EntityManagerFactory emf = this.createContainerEntityManagerFactory(info);
            String jndiName = module.getName() + "/" + unitName;
            try {
                PersistenceMessages.finerBindingEntityManagerFactory(module, unitName, jndiName);
                module.getApplicationContext().rebind(jndiName, (Object)emf);
            }
            catch (NamingException e) {
                throw DeploymentException.exceptionBindingEMF(module, jndiName, e);
            }
            this.getPersistenceUnits().put(unitName, new PersistenceUnitImpl(unitName, module.getRelativePersistenceUnitPath(rootUrl), emf));
        }
        finally {
            ((PersistenceUnitInfoImpl)info).destroy();
        }
    }

    private URL convertRootToURL(Context persistenceRoot) {
        try {
            return ContextUtils.getURL(persistenceRoot, true);
        }
        catch (IOException e) {
            throw DeploymentException.exceptionCreatingPersistenceUnitRoot(this.getPersistenceModule(), persistenceRoot.toString(), e);
        }
    }

    private EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info) {
        try {
            return ((PersistenceProvider)Class.forName(info.getPersistenceProviderClassName(), false, (ClassLoader)this.getPersistenceModule().getClassLoader()).newInstance()).createContainerEntityManagerFactory(info, null);
        }
        catch (Exception e) {
            throw DeploymentException.exceptionCreatingEntityManagerFactory(this.getPersistenceModule(), info.getPersistenceProviderClassName(), info.getPersistenceUnitName(), e);
        }
    }

    @Override
    public void bindPersistenceReferences(J2EEContextDescriptor descriptor, J2EEContext ctx) {
        List refs = descriptor.getPersistenceUnitReferences();
        for (InjectableReference ref : refs) {
            try {
                ctx.backDoorRebind(ref.getName(), this.getPersistenceUnit(((PersistenceUnitReference)ref).getUnitName()).getEntityManagerFactory());
            }
            catch (Exception e) {
                throw DeploymentException.exceptionBindingPersistenceUnit(this.getPersistenceModule(), ((PersistenceUnitReference)ref).getUnitName(), ref.getName(), e);
            }
        }
        refs = descriptor.getPersistenceContextReferences();
        for (InjectableReference ref : refs) {
            PersistenceUnit pu = this.getPersistenceUnit(((PersistenceContextReference)ref).getUnitName());
            try {
                if ("TRANSACTION".equals(((PersistenceContextReference)ref).getUnitType())) {
                    ctx.backDoorRebind(ref.getName(), pu.getEntityManagerProxy(((PersistenceContextReference)ref).getProperties()));
                    continue;
                }
                ctx.backDoorRebind(ref.getName(), new XPCProxyReference(pu, ((PersistenceContextReference)ref).getProperties()));
            }
            catch (Exception e) {
                throw DeploymentException.exceptionBindingPersistenceUnit(this.getPersistenceModule(), ((PersistenceContextReference)ref).getUnitName(), ref.getName(), e);
            }
        }
    }

    private PersistenceModule getPersistenceModule() {
        return this.persistenceModule;
    }

    @Override
    public PersistenceUnit getPersistenceUnit(String unitName) {
        PersistenceUnit unit = this.internalGetPersistenceUnit(unitName);
        if (unit == null) {
            throw DeploymentException.unknownPersistenceUnit(this.getPersistenceModule(), unitName);
        }
        return unit;
    }

    private PersistenceUnit internalGetPersistenceUnit(String unitName) {
        if (unitName == null || unitName.trim().equals("")) {
            return this.getDefaultPersistenceUnit();
        }
        if (unitName.indexOf(35) != -1) {
            return this.getQualifiedPersistenceUnit(unitName);
        }
        return this.getNamedPersistenceUnit(unitName);
    }

    private PersistenceUnit getDefaultPersistenceUnit() {
        if (this.getPersistenceUnits().isEmpty() && this.parent != null) {
            return this.parent.getDefaultPersistenceUnit();
        }
        if (this.getPersistenceUnits().size() == 1) {
            return this.getPersistenceUnits().values().iterator().next();
        }
        if (this.getPersistenceUnits().size() > 1) {
            throw DeploymentException.missingPersistenceUnitName(this.getPersistenceModule());
        }
        return null;
    }

    private PersistenceUnit getNamedPersistenceUnit(String unitName) {
        PersistenceUnit unit = this.getPersistenceUnits().get(unitName);
        if (unit == null && this.parent != null) {
            unit = this.parent.getNamedPersistenceUnit(unitName);
        }
        return unit;
    }

    private PersistenceUnit getQualifiedPersistenceUnit(String unitName) {
        String trimmedUnitName = unitName;
        if (unitName.indexOf("../") != -1) {
            trimmedUnitName = unitName.substring(3);
        }
        int hashIndex = trimmedUnitName.indexOf(35);
        String prefix = trimmedUnitName.substring(0, hashIndex);
        String name = trimmedUnitName.substring(hashIndex + 1);
        if (this.parent != null) {
            if (prefix.startsWith(this.getPersistenceModule().getPath())) {
                return this.internalGetPersistenceUnit(name);
            }
            return this.parent.getQualifiedPersistenceUnit(trimmedUnitName);
        }
        for (PersistenceUnitManager child : this.children) {
            if (!prefix.startsWith(((PersistenceUnitManagerImpl)child).getPersistenceModule().getPath())) continue;
            return ((PersistenceUnitManagerImpl)child).internalGetPersistenceUnit(name);
        }
        for (PersistenceUnit pu : this.getPersistenceUnits().values()) {
            if (!prefix.equals(pu.getRelativePath()) || !name.equals(pu.getName())) continue;
            return pu;
        }
        return null;
    }

    @Override
    public void enableDefaultPersistenceUnit(boolean enable) {
        this.enableDefaultPersistenceUnit = enable;
    }

    @Override
    public boolean isDefaultPersistenceUnitEnabled() {
        return this.enableDefaultPersistenceUnit;
    }
}

