/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.server.ejb.logging.i18n.PersistenceMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;

public class PersistenceMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.persistence", PersistenceMessageBundle.class.getName());

    public static void fineInitializingPersistenceUnitManager(DiagnosticContext ctx) {
        m_logger.log(Level.FINE, "J2EE JPA-00001", new Object[]{ctx.getContextId()});
    }

    public static void fineParsingPersistenceXml(DiagnosticContext ctx, String root) {
        m_logger.log(Level.FINE, "J2EE JPA-00002", new Object[]{ctx.getContextId(), root});
    }

    public static void fineInitializingEntityManagerFactory(DiagnosticContext ctx, String emfName, String persistenceProvider) {
        m_logger.log(Level.FINE, "J2EE JPA-00003", new Object[]{ctx.getContextId(), emfName, persistenceProvider});
    }

    public static void fineDestroyingPersistenceUnitManager(DiagnosticContext ctx) {
        m_logger.log(Level.FINE, "J2EE JPA-00004", new Object[]{ctx.getContextId()});
    }

    public static void fineClosingEntityManagerFactory(DiagnosticContext ctx, String emfName) {
        m_logger.log(Level.FINE, "J2EE JPA-00005", new Object[]{ctx.getContextId(), emfName});
    }

    public static void infoUsingTopLinkPreviewPersistenceProvider() {
        if (PersistenceMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE JPA-00006");
        }
    }

    public static void finerBindingEntityManagerFactory(DiagnosticContext ctx, String unitName, String jndiName) {
        m_logger.log(Level.FINE, "J2EE JPA-00007", new Object[]{ctx.getContextId(), unitName, jndiName});
    }

    public static void finerPPMCreatedPC(String persistenceUnit, Object pc) {
        m_logger.log(Level.FINER, "J2EE JPA-00009", new Object[]{persistenceUnit, pc});
    }

    public static void finerPPMClosePC(String persistenceUnit, Object pc) {
        m_logger.log(Level.FINER, "J2EE JPA-00010", new Object[]{persistenceUnit, pc});
    }

    public static void finerPPMPropagatePC(String persistenceUnit, Object pc) {
        m_logger.log(Level.FINER, "J2EE JPA-00011", new Object[]{persistenceUnit, pc});
    }

    public static void finerPPMSharePC(String persistenceUnit, Object pc) {
        m_logger.log(Level.FINER, "J2EE JPA-00012", new Object[]{persistenceUnit, pc});
    }

    public static void warningUnbindingEMF(DiagnosticContext ctx, String jndiName, Exception e) {
        m_logger.log(Level.WARNING, "J2EE JPA-00008", new Object[]{ctx.getContextId(), jndiName});
        LoggingUtils.logWarningStackTrace(m_logger, e);
    }

    public static void fineUsingWebInfPersistenceXml(DiagnosticContext ctx, String rootUrl) {
        m_logger.log(Level.FINE, "J2EE JPA-00013", new Object[]{ctx.getContextId(), rootUrl});
    }

    public static void fineCreatingDefaultPersistenceUnit(DiagnosticContext ctx) {
        m_logger.log(Level.FINE, "J2EE JPA-00014", new Object[]{ctx.getContextId()});
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

