/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.deployment.RemoveMethod;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;

public class StatefulRemoveInterceptor
implements Interceptor {
    boolean retainIfException;

    public StatefulRemoveInterceptor(boolean retainIfException) {
        this.retainIfException = retainIfException;
    }

    public static Interceptor getInstance(MethodState methodState) {
        RemoveMethod remove;
        if (methodState.getBeanDescriptor().isStateful() && (remove = ((SessionBeanDescriptor)methodState.getBeanDescriptor()).getRemoveMethod(methodState.getBeanMethod())) != null) {
            return new StatefulRemoveInterceptor(remove.isRetainIfException());
        }
        return null;
    }

    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            Object result = ctx.proceed();
            this.invalidate(ctx);
            return result;
        }
        catch (Exception ex) {
            if (!this.retainIfException && EJBUtils.isApplicationException(ex)) {
                this.invalidate(ctx);
            }
            throw ex;
        }
    }

    private void invalidate(InvocationContext ctx) {
        ((StatefulSessionEJBObject)ctx.getBeanWrapper()).OC4J_invalidate(true);
    }
}

