/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.PersistenceContextReference;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.persistence.PersistenceUnit;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.ejb.persistence.XPCManager;
import java.util.Iterator;
import java.util.Map;

public class StatefulCreateInterceptor
implements Interceptor {
    private static Interceptor instance;

    public static Interceptor getInstance() {
        if (instance == null) {
            instance = new StatefulCreateInterceptor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext ctx) throws Exception {
        ThreadState thread = ctx.getCurrentThreadState();
        StatefulSessionEJBHome home = (StatefulSessionEJBHome)ctx.getHome();
        BeanDescriptor descriptor = home.getBeanDescriptor();
        home.checkMaxInstancesCount();
        StatefulSessionContext context = new StatefulSessionContext();
        if (ctx.getMethodState().isLocal()) {
            context.localHome = home;
        } else {
            context.remoteHome = home;
        }
        context.object = descriptor.getEJBClass().newInstance();
        descriptor.getInterceptorManager().initializeUserInterceptorsForBean(context);
        boolean hasEMF = false;
        if (descriptor.getPersistenceUnitReferences().size() > 0) {
            hasEMF = true;
        }
        boolean hasXPC = false;
        if (descriptor.getPersistenceContextReferences().size() > 0) {
            PersistenceUnitManager pm = descriptor.getEJBPackage().getDeployment().getPersistenceUnitManager();
            XPCManager xm = new XPCManager(pm);
            context.setXPCManager(xm);
            Map txPC = null;
            if (EJBTransactionManager.getTransaction() != null) {
                txPC = EJBTransactionManager.getInstance().getOrCreateEJBTransactionContext().getPersistenceContextMap();
            }
            Iterator i = descriptor.getPersistenceContextReferences().iterator();
            while (i.hasNext()) {
                Object current;
                PersistenceContextReference ref = (PersistenceContextReference)i.next();
                if (!"EXTENDED".equals(ref.getUnitType())) continue;
                PersistenceUnit pu = pm.getPersistenceUnit(ref.getUnitName());
                Object pc = null;
                if (txPC != null && (current = txPC.get(pu.getName())) != null && !pu.isTempPersistenceContext(current)) {
                    pc = current;
                    pu.sharePersistenceContext(pc);
                }
                if (pc == null) {
                    pc = pu.createPersistenceContext(ref.getProperties());
                }
                xm.addPersistenceContext(pu.getName(), pc);
                hasXPC = true;
            }
        }
        try {
            thread.timerDisallowed = true;
            descriptor.getLifecycleManager().setContext(context.object, context);
            StatefulSessionEJBObject wrapper = (StatefulSessionEJBObject)home.newCreate(context);
            if (hasXPC || hasEMF) {
                wrapper.OC4J_setAllowPassivate(false);
            }
            if (descriptor.getEJBPackage().getCompatibility() >= 3) {
                String beanMethodName;
                descriptor.getLifecycleManager().postConstruct(context.object, context);
                if ((((SessionBeanDescriptor)descriptor).isAdaptedLocalHome() && ctx.getMethodState().isLocal() || ((SessionBeanDescriptor)descriptor).isAdaptedRemoteHome() && !ctx.getMethodState().isLocal()) && (!(beanMethodName = ctx.getMethodState().getBeanMethod().getName()).equals("ejbCreate") || beanMethodName.equals("ejbCreate") && ctx.getMethodState().getBeanMethod().getParameterTypes().length != 0)) {
                    try {
                        ctx.setTarget(context.object);
                        ctx.setEJBContext(context);
                        ctx.proceed();
                    }
                    finally {
                        ctx.setTarget(null);
                        ctx.setEJBContext(null);
                    }
                }
            } else {
                try {
                    ctx.setTarget(context.object);
                    ctx.setEJBContext(context);
                    ctx.proceed();
                }
                finally {
                    ctx.setTarget(null);
                    ctx.setEJBContext(null);
                }
            }
            home.addInstance(wrapper);
            StatefulSessionEJBObject statefulSessionEJBObject = wrapper;
            return statefulSessionEJBObject;
        }
        finally {
            thread.timerDisallowed = false;
        }
    }
}

