/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.ContainerManagedRelation;
import com.evermind.server.ejb.deployment.EJBRelationship;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.RoleSource;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBRelationshipRole
extends AbstractDescribable
implements XMLizable {
    private boolean many;
    private EJBRelationship relationship;
    private RoleSource roleSource;
    private ContainerManagedRelation relation;
    private boolean cascadeDelete;

    public EJBRelationshipRole(EJBRelationship relationship, String name) {
        this.relationship = relationship;
        this.setName(name);
        this.roleSource = new RoleSource("Role source");
    }

    public EJBRelationshipRole(EJBRelationship relationship, Node parent) throws InstantiationException {
        this.relationship = relationship;
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (XMLUtils.isCommentOrID(name)) continue;
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("ejb-relationship-role-name")) {
                    this.setName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("multiplicity")) {
                    String value = XMLUtils.getStringValue(node);
                    if (value.equalsIgnoreCase("Many")) {
                        this.many = true;
                        continue;
                    }
                    if (value.equalsIgnoreCase("One")) {
                        this.many = false;
                        continue;
                    }
                    throw new InvalidEJBAssemblyException("Illegal multiplicity value: " + value + " (Must be 'One' or 'Many')", "22.5");
                }
                if (name.equals("relationship-role-source")) {
                    this.roleSource = new RoleSource(node);
                    continue;
                }
                if (name.equals("cmr-field")) {
                    this.setRelationship(new ContainerManagedRelation(node));
                    continue;
                }
                if (name.equals("cascade-delete")) {
                    this.cascadeDelete = true;
                    this.relationship.setCascadeDeleteForRole(true);
                    continue;
                }
                throw new InvalidEJBAssemblyException("Unknown ejb-relationship-role subtag: " + name, "22.5");
            }
        }
        if (this.roleSource == null) {
            throw new InvalidEJBAssemblyException("ejb-relationship-role with missing relationship-role-source subtag", "22.5");
        }
    }

    public void setRelationship(ContainerManagedRelation relation) {
        this.relation = relation;
        if (relation.isSynthetic() && this.isMany() && this.getPeer() != null && !this.getPeer().isMany()) {
            relation.setSynthetic(false);
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<ejb-relationship-role>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<ejb-relationship-role-name>" + XMLUtils.encode(this.getName()) + "</ejb-relationship-role-name>");
        }
        out.println(indention + "\t<multiplicity>" + (this.many ? "Many" : "One") + "</multiplicity>");
        if (this.cascadeDelete) {
            out.println(indention + "\t<cascade-delete />");
        }
        if (this.roleSource != null) {
            this.roleSource.writeXML(out, indention + "\t");
        }
        if (this.relation != null) {
            this.relation.writeXML(out, indention + "\t");
        }
        out.println(indention + "</ejb-relationship-role>");
    }

    public RoleSource getRoleSource() {
        return this.roleSource;
    }

    public ContainerManagedRelation getRelation() {
        return this.relation;
    }

    public EJBRelationship getEJBRelationship() {
        return this.relationship;
    }

    public String toString() {
        return "relationship " + this.getRoleSource() + (this.getRelation() == null ? "" : ":" + this.getRelation());
    }

    public void setRelationshipType(boolean many) {
        this.many = many;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public void setCascadeDelete(boolean delete) {
        this.cascadeDelete = delete;
    }

    public boolean isMany() {
        return this.many;
    }

    public EJBRelationshipRole getPeer() {
        if (this.relationship.getFirstRole() != this) {
            return this.relationship.getFirstRole();
        }
        return this.relationship.getSecondRole();
    }

    public void setRelation(ContainerManagedRelation relation) {
        this.setRelationship(relation);
    }
}

