/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MethodContainer;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerTransaction
extends MethodContainer
implements XMLizable {
    private int transactionType = 0;

    public ContainerTransaction(EJBPackage jar) {
        super(jar);
    }

    public ContainerTransaction(EJBPackage jar, MethodDescriptor md) {
        super(jar);
        this.addMethod(md);
        this.addDMSAttrs();
    }

    public ContainerTransaction(EJBPackage jar, Node parent) throws InstantiationException {
        super(jar);
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("method")) {
                try {
                    this.addMethod(new MethodDescriptor(node));
                    continue;
                }
                catch (InstantiationException e) {
                    if (this.getDescription() != null) {
                        throw new InvalidEJBAssemblyException("Error in container-transaction '" + this.getDescription() + "': " + e.getMessage(), e instanceof InvalidEJBAssemblyException ? ((InvalidEJBAssemblyException)e).getSection() : null);
                    }
                    throw e;
                }
            }
            if (name.equals("trans-attribute")) {
                this.setTransactionType(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("description")) continue;
            this.setDescription(XMLUtils.getStringValue(node));
        }
        this.addDMSAttrs();
    }

    protected void addDMSAttrs() {
    }

    public void setTransactionType(String name) throws InstantiationException {
        if (name.equalsIgnoreCase("Required")) {
            this.transactionType = 1;
        } else if (name.equalsIgnoreCase("RequiresNew")) {
            this.transactionType = 6;
        } else if (name.equalsIgnoreCase("NotSupported")) {
            this.transactionType = 2;
        } else if (name.equalsIgnoreCase("Never")) {
            this.transactionType = 5;
        } else if (name.equalsIgnoreCase("Supports")) {
            this.transactionType = 4;
        } else if (name.equalsIgnoreCase("Mandatory")) {
            this.transactionType = 3;
        } else {
            throw new InvalidEJBAssemblyException("Unknown transaction-type: '" + name + "'", "17.4.1");
        }
    }

    public void setTransactionTypeIfNotSet(String name) throws InstantiationException {
        if (this.transactionType == 0) {
            this.setTransactionType(name);
        }
    }

    public int getTransactionType() {
        if (this.transactionType == 0) {
            return 2;
        }
        return this.transactionType;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<container-transaction>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        XMLUtils.writeAll(Arrays.asList(this.getMethods()), out, indention + "\t");
        out.println(indention + "\t<trans-attribute>" + ContainerTransaction.getTransactionName(this.transactionType) + "</trans-attribute>");
        out.println(indention + "</container-transaction>");
    }

    public static String getTransactionName(int type) {
        if (type == 1) {
            return "Required";
        }
        if (type == 6) {
            return "RequiresNew";
        }
        if (type == 2) {
            return "NotSupported";
        }
        if (type == 5) {
            return "Never";
        }
        if (type == 3) {
            return "Mandatory";
        }
        return "Supports";
    }

    public String toString() {
        return "[" + super.toString() + " : " + ContainerTransaction.getTransactionName(this.transactionType) + "]";
    }
}

