/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import java.util.ArrayList;

public final class CommitOptionDescriptor {
    public static final int k_I = 4;
    public static final int k_C = 3;
    public static final int k_B = 2;
    public static final int k_A = 1;
    private int option = 3;
    private int numberOfBuckets = 1001;
    private boolean useOCA = false;
    private String name = "oca";
    private String type = "int";
    private String dbNname = "oca";
    private String dbType = "INTEGER";
    private ContainerManagedField field = null;
    private ArrayList _nonCMRFields = new ArrayList();
    private int ttl = -1;

    public CommitOptionDescriptor(int option) {
        this.option = option;
        try {
            this.dbType = DatabaseSchema.getDatabaseType(this.type);
        }
        catch (InstantiationException e) {
            System.err.println("Unknown DB type for type " + this.type);
        }
    }

    public int getOption() {
        return this.option;
    }

    public NonCMRField[] getNonCMRFields() {
        NonCMRField[] fields = new NonCMRField[this._nonCMRFields.size()];
        for (int i = 0; i < this._nonCMRFields.size(); ++i) {
            NonCMRField o;
            fields[i] = o = (NonCMRField)this._nonCMRFields.get(i);
        }
        return fields;
    }

    public boolean addNonCMRField(String name, String atype, boolean aclone) {
        return this._nonCMRFields.add(new NonCMRField(name, atype, aclone));
    }

    public boolean hasNonCMRFields() {
        return this._nonCMRFields.size() > 0;
    }

    public void setOption(String option, boolean isContainerManaged) {
        if (option.equalsIgnoreCase("C")) {
            this.setOption(3, isContainerManaged);
        } else if (option.equalsIgnoreCase("B")) {
            this.setOption(2, isContainerManaged);
        } else if (option.equalsIgnoreCase("A")) {
            this.setOption(1, isContainerManaged);
        } else if (option.equalsIgnoreCase("I")) {
            this.setOption(4, isContainerManaged);
        } else {
            System.err.println("unknown commit-option " + option);
        }
    }

    public void setOption(int option, boolean isContainerManaged) {
        this.option = option;
        switch (option) {
            case 1: 
            case 3: {
                this.useOCA = false;
                break;
            }
            case 2: 
            case 4: {
                this.useOCA = isContainerManaged;
            }
        }
    }

    public int getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCacheable() {
        if (this.numberOfBuckets == 0) return false;
        if (this.getOption() == 3) return false;
        return true;
    }

    public void setNumberOfBuckets(int numberOfBuckets) {
        if (numberOfBuckets == 0) {
            if (this.option == 3) {
                this.numberOfBuckets = numberOfBuckets;
            }
        } else if (numberOfBuckets > 0) {
            this.numberOfBuckets = numberOfBuckets;
        } else {
            System.err.println("Warning: number-of-buckets value in the orion-ejb-jar.xml is negative, default value will be used.");
        }
    }

    public boolean useOCA() {
        return this.useOCA;
    }

    public void useOCA(boolean useOCA) {
        this.useOCA = useOCA;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.useOCA(true);
    }

    public String getDbNname() {
        return this.dbNname;
    }

    public void setDbNname(String dbNname) {
        this.dbNname = dbNname;
        this.useOCA(true);
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type.equalsIgnoreCase("long") ? "long" : "int";
        try {
            this.dbType = DatabaseSchema.getDatabaseType(this.type);
        }
        catch (InstantiationException e) {
            System.err.println("Unknown DB type for type " + type);
        }
        this.useOCA(true);
    }

    public StringBuffer getOCASelectStatement(EntityBeanDescriptor desc) throws CompilationException {
        StringBuffer buffer = new StringBuffer("select ");
        buffer.append(desc.getTableName() + "." + this.getDbNname());
        buffer.append(" from ");
        buffer.append(desc.getTableName());
        buffer.append(" where (");
        desc.getPrimaryKey().appendFieldNames(buffer, new TableIteration(), 3, true);
        buffer.append(")");
        return buffer;
    }

    public StringBuffer getOCASelectForUpdateStatement(EntityBeanDescriptor desc) throws CompilationException {
        StringBuffer buffer = new StringBuffer("select ");
        buffer.append(desc.getTableName() + "." + this.getField().getDatabaseName());
        buffer.append(" from ");
        buffer.append(desc.getTableName());
        buffer.append(" where (");
        TableIteration ti = new TableIteration();
        desc.getPrimaryKey().appendFieldNames(buffer, ti, 3, true);
        this.getField().appendFieldNames(buffer, ti, 3, true);
        buffer.append(")");
        buffer.append(" for update");
        return buffer;
    }

    public String getOptionStr() {
        switch (this.option) {
            case 1: {
                return "A";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "I";
            }
        }
        return "C";
    }

    public void setField(ContainerManagedField field) {
        this.field = field;
    }

    public ContainerManagedField getField() {
        return this.field;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int i) {
        this.ttl = i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCacheableOptionA() {
        if (this.numberOfBuckets == 0) return false;
        if (this.getOption() != 1) return false;
        return true;
    }

    public class NonCMRField {
        public String name;
        public String type;
        private boolean clone;

        public NonCMRField(String name, String atype, boolean aclone) {
            this.name = name;
            this.type = atype;
            this.clone = aclone;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean getClone() {
            return this.clone;
        }
    }
}

