/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.RoleUser;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.MessageDestination;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.deployment.SecurityIdentity;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.BeanPool;
import com.evermind.server.ejb.BeanPoolConfig;
import com.evermind.server.ejb.CallManager;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBDependencyManager;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.LifecycleManager;
import com.evermind.server.ejb.cache.AlternateHashTable;
import com.evermind.server.ejb.deployment.BeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.ContainerTransaction;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.PersistenceContextReference;
import com.evermind.server.ejb.deployment.PersistenceUnitReference;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.exception.ValidationExceptions;
import com.evermind.server.ejb.interceptor.InterceptorManager;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.interceptor.system.DMSInterceptor;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.jacc.PolicyContextException;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.ws.server.deployment.ServiceReferenceContainer;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;
import oracle.oc4j.configuration.J2EEContextDescriptor;
import oracle.oc4j.corba.deployment.EjbIorConfigurationLoader;
import oracle.security.jazn.JAZNConfig;
import org.w3c.dom.Node;

public abstract class BeanDescriptor
extends AbstractDescribable
implements XMLizable,
ServiceReferenceContainer,
J2EEContextDescriptor,
BeanPoolConfig,
DiagnosticContext {
    protected static final int TRANSACTION_UNDEFINED = -1;
    public static final int TRANSACTION_CONTAINER = 0;
    public static final int TRANSACTION_BEAN = 1;
    public static final int ENTITY_TYPE = 0;
    public static final int SFSB_TYPE = 1;
    public static final int SLSB_TYPE = 2;
    public static final int MDB_TYPE = 3;
    public static final int UNDEFINED_TYPE = 4;
    public static final String[] EJB_TYPE_STRINGS = new String[]{"entity", "stateful", "stateless", "message-driven", "unknown"};
    public static final String INTERCEPTOR_TYPE_BEAN = "bean";
    public static final String INTERCEPTOR_TYPE_SINGLETON = "singleton";
    public static final String DEFAULT_INTERCEPTOR_TYPE = "default";
    private EJBPackage ejbPackage;
    private Class ejbClass;
    private String smallIcon;
    private String largeIcon;
    private int beanType = -1;
    private String ejbClassName;
    private int transactionType;
    private SecurityIdentity securityIdentity;
    private J2EEContextConfigDelegate configDelegate;
    private String timeoutMethodName;
    private InterceptorDescriptor beanInterceptor = new InterceptorDescriptor();
    private CallManager callManager;
    private MethodState timeoutMethodState;
    protected static final int DEFAULT_MAX_INSTANCES = 0;
    protected static final int DEFAULT_MIN_INSTANCES = 0;
    protected static final int DEFAULT_TX_RETRY_WAIT = 0;
    protected static final int DEFAULT_MAX_TX_RETRIES = 0;
    protected static final int DEFAULT_POOL_CACHE_TIMEOUT = 60;
    protected static final long DEFAULT_CALL_TIMEOUT = 90000L;
    protected static final boolean DEFAULT_COPY_BY_VALUE = true;
    private int maxTxRetries;
    private long txRetryWait;
    private long callTimeout;
    private boolean copyByValue;
    private int maxInstances;
    private int minInstances;
    private int cacheTimeout;
    private List iorConfigurations;
    private int jaasMode = JAZNConfig.JAAS_MODE_NULL;
    private String interceptorType = "default";
    private List securityRoleReferences;
    private static Logger m_logger = EJBTraceLogger.getLogger(BeanDescriptor.class);
    public int __activeInstancesCount;
    public int __activeInstancesHighWaterMark;
    public int __waitingForInstance;
    public int __passivatedInstancesCount;
    public final Object __poolLock = new Object();
    protected StateIntf passivatedCount = null;
    private NounIntf beanNoun = null;
    protected StateIntf pooledCount = null;
    protected StateIntf readyCount = null;
    protected BeanPool beanPool;
    private Set iorConfigurationDescriptors;
    private LifecycleManager lifecycleManager = null;
    private InterceptorManager interceptorManager = null;

    public BeanDescriptor(EJBPackage ejbPackage) {
        this.setMaxTxRetries(0);
        this.setTxRetryWait(0L);
        this.setCallTimeout(90000L);
        this.setCopyByValue(true);
        this.setMaxInstances(0);
        this.setMinInstances(0);
        this.setCacheTimeout(60);
        this.setTransactionType(-1);
        this.setBeanType(4);
        this.ejbPackage = ejbPackage;
        this.configDelegate = new J2EEContextConfigDelegate(this);
        this.callManager = new CallManager(this.getCallTimeout());
    }

    protected void initialize() throws InstantiationException {
        SecurityRole role;
        if (this.getName() == null) {
            throw ValidationExceptions.missingEJBName(this);
        }
        if (this.getTransactionType() == -1) {
            this.setTransactionType(0);
        }
        Iterator messageDestinationRefs = this.getDestinationReferences().iterator();
        while (messageDestinationRefs.hasNext()) {
            DestinationReference reference = (DestinationReference)messageDestinationRefs.next();
            MessageDestination dest = null;
            if (reference.getLink() != null) {
                String destLinkName = reference.getLink();
                String destLinkJar = null;
                if (destLinkName != null && destLinkName.indexOf(35) >= 0) {
                    destLinkJar = destLinkName.substring(0, destLinkName.indexOf(35));
                    destLinkName = destLinkName.substring(destLinkName.indexOf(35) + 1);
                }
                if (destLinkJar != null) {
                    EJBPackageDeployment deployment = this.getEJBPackage().getContainer().getEJBPackage(destLinkJar);
                    if (deployment == null) {
                        throw ValidationExceptions.unknownJARInMessageDestinationLink(this, destLinkJar, reference.getName());
                    }
                    dest = deployment.getPackage().getMessageDestination(destLinkName);
                } else {
                    dest = this.getEJBPackage().getMessageDestination(destLinkName);
                }
                if (dest == null) {
                    throw ValidationExceptions.unknownDestinationLink(this, reference.getLink(), reference.getName());
                }
                if (reference.getType() != null && dest.getType() != null) {
                    if (reference.getType().equals("javax.jms.Queue") && !dest.getType().equals("javax.jms.Queue")) {
                        throw ValidationExceptions.destinationLinkTargetMismatch(this, reference.getName(), reference.getType(), dest.getType());
                    }
                    if (reference.getType().equals("javax.jms.Topic") && !dest.getType().equals("javax.jms.Topic")) {
                        throw ValidationExceptions.destinationLinkTargetMismatch(this, reference.getName(), reference.getType(), dest.getType());
                    }
                }
            }
            if (reference.getLocation() == null) {
                if (dest != null) {
                    if (dest.getLocation() != null) {
                        reference.setLocation(dest.getLocation());
                        continue;
                    }
                    reference.setLocation(reference.getName());
                    dest.setLocation(reference.getName());
                    continue;
                }
                reference.setLocation(reference.getName());
                continue;
            }
            if (dest == null || dest.getLocation() != null) continue;
            dest.setLocation(reference.getLocation());
        }
        Iterator i = this.getPackage().getContainerTransactions().iterator();
        while (i.hasNext()) {
            ContainerTransaction tx = (ContainerTransaction)i.next();
            MethodDescriptor[] methods = tx.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodDescriptor md = methods[j];
                if (!md.getName().equals("ejbTimeout") || tx.getTransactionType() == 2 || tx.getTransactionType() == 6) continue;
                EJBDeploymentMessages.warningInvalidTimeoutTransactionType(this);
            }
        }
        if (this.getSecurityIdentity() != null && this.getSecurityIdentity().getSpecifiedIdentity() != null && (role = this.getEJBPackage().getSecurityRole(this.getSecurityIdentity().getSpecifiedIdentity())) == null) {
            throw ValidationExceptions.unknownSecurityIdentity(this, this.getSecurityIdentity().getSpecifiedIdentity());
        }
    }

    public void initialize(EJBDeploymentContext container) throws InstantiationException {
        this.initialize();
        this.setJAASMode(this.getPackage().getJAASMode());
        this.addDMSAttrs();
        String ejbClassName = this.getEJBClassName();
        try {
            this.ejbClass = Class.forName(ejbClassName, true, this.getEJBPackage().getEJBClassLoader());
        }
        catch (Throwable t) {
            throw ValidationExceptions.unableToLoadEJBClass(this, t);
        }
        this.interceptorManager = new InterceptorManager().initialize(this);
        this.lifecycleManager = new LifecycleManager().initialize(this);
        if (this.getPackage().getCompatibility() >= 3) {
            EJBDependencyManager manager = new EJBDependencyManager(this, this, this.getEJBClass());
            manager.initialize();
            this.lifecycleManager.setDependencyManager(manager);
            this.lifecycleManager.setInterceptorManager(this.interceptorManager);
        }
        if (this.ejbClass.isAssignableFrom(TimedObject.class) && this.getTimeoutMethodName() != null && !this.getTimeoutMethodName().equals("ejbTimeout")) {
            throw new InstantiationException("Bean class may only have one timeout method ejbTimeout(Timer). The method (" + this.getTimeoutMethodName() + ") of class (" + ejbClassName + ") cannot be specified as timeout method.");
        }
    }

    public void initialize(Object home) {
        if (this.beanPool == null) {
            this.beanPool = this.createBeanPool(home);
        }
    }

    public NounIntf getBeanNoun() {
        if (this.beanNoun == null && ApplicationServer.DMS_GATE) {
            NounIntf earNoun = Application.getApplicationNoun(this.getEJBPackage().getContainer().getApplication().getName());
            NounIntf ejbNoun = ApplicationServer.nounFactory().create(earNoun, "EJBs", "oc4j_ejb");
            NounIntf ejbPkgNoun = ApplicationServer.nounFactory().create(ejbNoun, this.getEJBPackage().getName(), "oc4j_ejb_pkg");
            this.beanNoun = ApplicationServer.nounFactory().create(ejbPkgNoun, this.getName(), "oc4j_ejb_" + this.getBeanTypeString() + "_bean");
        }
        return this.beanNoun;
    }

    public StateIntf getPooledCountState() {
        if (ApplicationServer.DMS_GATE && this.pooledCount == null) {
            this.createPooledCountState();
        }
        return this.pooledCount;
    }

    protected void createPooledCountState() {
        this.pooledCount = DMSInterceptor.createCountState(this.getBeanNoun(), "pooled", "Number of Pooled Instances");
    }

    public StateIntf getReadyCountState() {
        if (ApplicationServer.DMS_GATE && this.readyCount == null) {
            this.createReadyCountState();
        }
        return this.readyCount;
    }

    protected void createReadyCountState() {
        this.readyCount = DMSInterceptor.createCountState(this.getBeanNoun(), "ready", "Number of Ready Instances");
    }

    public StateIntf getPassivatedCountState() {
        if (ApplicationServer.DMS_GATE && this.passivatedCount == null) {
            this.createPassivatedCountState();
        }
        return this.passivatedCount;
    }

    protected void createPassivatedCountState() {
        this.passivatedCount = DMSInterceptor.createCountState(this.getBeanNoun(), "passive", "Number of Passivated Instances");
    }

    protected void addDMSAttrs() {
        if (ApplicationServer.DMS_GATE) {
            ApplicationServer.stateFactory().create(this.getBeanNoun(), "transaction-type", "", "transaction", (Object)(this.getTransactionType() == 1 ? "Bean" : "Container"));
        }
    }

    public boolean isSession() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean isStateless() {
        return false;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isTopLinkCMP() {
        return false;
    }

    public boolean isOrionCMP() {
        return false;
    }

    public int getBeanType() {
        return this.beanType;
    }

    public String getBeanTypeString() {
        return EJB_TYPE_STRINGS[this.beanType];
    }

    public String getEJBClassName() {
        return this.ejbClassName;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public EJBPackage getEJBPackage() {
        return this.ejbPackage;
    }

    protected String getSmallIcon() {
        return this.smallIcon;
    }

    protected String getLargeIcon() {
        return this.largeIcon;
    }

    public int getMinInstances() {
        return this.minInstances;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public int getMaxTxRetries() {
        return this.maxTxRetries;
    }

    public void updateActiveInstancesHighWaterMark() {
        if (this.__activeInstancesHighWaterMark < this.__activeInstancesCount) {
            this.__activeInstancesHighWaterMark = this.__activeInstancesCount;
        }
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public boolean isCopyByValue() {
        return this.copyByValue;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public long getTxRetryWait() {
        return this.txRetryWait;
    }

    public List getEJBReferences() {
        return this.configDelegate.getEJBReferences();
    }

    protected EJBReference getEJBReference(String refName) {
        return this.configDelegate.getEJBReference(refName);
    }

    public List getEnvironmentEntries() {
        return this.configDelegate.getEnvironmentEntries();
    }

    public EnvironmentEntry getEnvironmentEntry(String entryName) {
        return this.configDelegate.getEnvironmentEntry(entryName);
    }

    public List getResourceEnvironmentReferences() {
        return this.configDelegate.getResourceEnvironmentReferences();
    }

    protected ResourceEnvironmentReference getResourceEnvironmentReference(String refName) {
        return this.configDelegate.getResourceEnvironmentReference(refName);
    }

    public List getResourceReferences() {
        return this.configDelegate.getResourceReferences();
    }

    protected ResourceReference getResourceReference(String refName) {
        return this.configDelegate.getResourceReference(refName);
    }

    public List getServiceReferences() {
        return this.configDelegate.getServiceReferences();
    }

    public void addServiceReference(ServiceReferenceDescriptor serviceReference) {
        this.configDelegate.addServiceReference(serviceReference);
    }

    public void removeServiceReference(ServiceReferenceDescriptor reference) {
        this.configDelegate.removeServiceReference(reference);
    }

    protected ServiceReferenceDescriptor getServiceReference(String refName) {
        return this.configDelegate.getServiceReference(refName);
    }

    public List getDestinationReferences() {
        return this.configDelegate.getDestinationReferences();
    }

    protected DestinationReference getDestinationReference(String refName) {
        return this.configDelegate.getDestinationReference(refName);
    }

    public List getSecurityRoleReferences() {
        if (this.securityRoleReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityRoleReferences;
    }

    protected void addSecurityRoleReference(SecurityRoleReference reference) {
        if (this.securityRoleReferences == null) {
            this.securityRoleReferences = new ArrayList();
        }
        this.securityRoleReferences.add(reference);
        try {
            this.getEJBPackage().registerWithJACC(reference, this.getName());
        }
        catch (PolicyContextException e) {
            e.printStackTrace();
        }
        this.firePropertyChangeEvent("securityRoleReferences", null, reference);
    }

    public void addPersistenceUnitReference(PersistenceUnitReference reference) {
        this.configDelegate.addPersistenceUnitReference(reference);
    }

    public List getPersistenceUnitReferences() {
        return this.configDelegate.getPersistenceUnitReferences();
    }

    public void addPersistenceContextReference(PersistenceContextReference reference) {
        this.configDelegate.addPersistenceContextReference(reference);
    }

    public List getPersistenceContextReferences() {
        return this.configDelegate.getPersistenceContextReferences();
    }

    public List getIorConfigurations() {
        if (this.iorConfigurations == null) {
            this.iorConfigurations = new ArrayList();
        }
        return this.iorConfigurations;
    }

    protected void setBeanType(int beanType) {
        this.beanType = beanType;
    }

    public void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public RoleUser getRunAsUser() {
        if (this.getSecurityIdentity() != null && this.getSecurityIdentity().getSpecifiedIdentity() != null) {
            SecurityRole role = this.getEJBPackage().getSecurityRole(this.getSecurityIdentity().getSpecifiedIdentity());
            return new RoleUser(role);
        }
        return null;
    }

    public InterceptorDescriptor getBeanInterceptor() {
        return this.beanInterceptor;
    }

    public void setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        if (this.callManager != null) {
            this.callManager.setCallTimeout(callTimeout);
        }
    }

    protected void setCopyByValue(boolean copyByValue) {
        this.copyByValue = copyByValue;
    }

    protected void setEJBClassName(String ejbClassName) {
        this.ejbClassName = ejbClassName;
        this.firePropertyChangeEvent("ejbClasName", this.ejbClassName, ejbClassName);
    }

    protected void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setMaxInstances(int maxInstances) {
        if (maxInstances > 0 && maxInstances < this.getMinInstances()) {
            throw ValidationExceptions.minInstancesExceedsMaxInstances(this, this.getMinInstances(), maxInstances);
        }
        this.maxInstances = maxInstances;
    }

    protected void setMaxTxRetries(int maxTxRetries) {
        if (maxTxRetries < 0) {
            this.maxTxRetries = 0;
        }
        this.maxTxRetries = maxTxRetries;
    }

    public void setMinInstances(int minInstances) {
        if (this.maxInstances < 0) {
            return;
        }
        if (this.maxInstances != 0 && minInstances > this.getMaxInstances()) {
            throw ValidationExceptions.minInstancesExceedsMaxInstances(this, minInstances, this.getMaxInstances());
        }
        this.minInstances = minInstances;
    }

    protected void setCacheTimeout(int poolCacheTimeout) {
        this.cacheTimeout = poolCacheTimeout;
    }

    protected void setSecurityIdentity(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    protected void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    protected void setTxRetryWait(long txRetryWait) {
        this.txRetryWait = txRetryWait;
    }

    protected J2EEContextConfigDelegate getConfigDelegate() {
        return this.configDelegate;
    }

    public Class getEJBClass() {
        return this.ejbClass;
    }

    public void setEJBClass(Class theClass) {
        this.ejbClass = theClass;
    }

    public AbstractEJBHome createHomeInstance(EJBContainer container, ClassLoader loader, boolean local) throws InstantiationException {
        throw new InternalError("Called on baseclass");
    }

    public final void parseEJBJarXML(Node parent) throws InstantiationException {
        this.getBeanDescriptorXMLFactory().parseEJBJarXML(this, parent);
    }

    public final void parseOrionXML(Node parent) throws InstantiationException {
        this.getBeanDescriptorXMLFactory().parseOracleEJBJarXML(this, parent);
    }

    public final void writeOrionXML(PrintWriter out, String indentation) throws IOException {
        this.getBeanDescriptorXMLFactory().writeOracleEJBJarXML(this, out, indentation);
    }

    public final void writeXML(PrintWriter out, String indentation) throws IOException {
        this.getBeanDescriptorXMLFactory().writeEJBJarXML(this, out, indentation);
    }

    public int getTransactionType(Method method, boolean home, boolean local) {
        return this.getEJBPackage().getTransactionType(this.getName(), method, home, local);
    }

    public List getSecurityRoles(Method method, boolean home, boolean local) {
        List lst = this.getEJBPackage().getSecurityRoles(this.getName(), method, home, local);
        if (lst == null && !home && !local) {
            lst = this.getEJBPackage().getSecurityRoles(this.getName(), method, 5);
        }
        return lst;
    }

    public Map getRoleReferences() throws InstantiationException {
        List roleReferences = this.getSecurityRoleReferences();
        if (roleReferences.isEmpty()) {
            return null;
        }
        HashMap<String, String> roleMap = new HashMap<String, String>();
        for (int i = 0; i < roleReferences.size(); ++i) {
            SecurityRoleReference reference = (SecurityRoleReference)roleReferences.get(i);
            roleMap.put(reference.getName(), reference.getLink());
        }
        return roleMap;
    }

    public EJBPackage getPackage() {
        return this.getEJBPackage();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BeanDescriptor)) {
            return false;
        }
        return ((BeanDescriptor)other).getName().equals(this.getName());
    }

    public String toString() {
        return "bean " + this.getDisplayName();
    }

    public String isDeployed() {
        return null;
    }

    public Set getIORConfigurationDescriptors() {
        if (this.iorConfigurationDescriptors == null) {
            this.iorConfigurationDescriptors = EjbIorConfigurationLoader.toEjbIorConfigurationDescriptors(this.getIorConfigurations());
        }
        return this.iorConfigurationDescriptors;
    }

    public int getTransactionType(String methodName, String[] parameters, boolean home, boolean local) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(BeanDescriptor.class.toString(), "getTransactionType(methodName,parameters,home,local)");
        }
        if (this.getTransactionType() == 1) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "BeanDescriptor.getTransactionType(methodName,home,local): end--returning ApplicationServerTransaction.TX_DEFAULT");
            }
            return 0;
        }
        List containerTransactions = this.getEJBPackage().getContainerTransactions();
        if (containerTransactions != null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "containerTransactions.size()=" + containerTransactions.size());
            }
            for (int i = 0; i < containerTransactions.size(); ++i) {
                ContainerTransaction newTransaction = (ContainerTransaction)containerTransactions.get(i);
                MethodDescriptor[] matchedDescriptors = this.getMatchedMethodDescriptors(newTransaction.getMethods(), methodName);
                for (int j = 0; matchedDescriptors != null && j < matchedDescriptors.length; ++j) {
                    String constructedMethod = this.constructMethod(methodName, parameters);
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "constructedMethod    =" + constructedMethod);
                        m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "matchedDescriptors[" + j + "]=" + matchedDescriptors[j]);
                    }
                    if (parameters != null && !constructedMethod.equals(matchedDescriptors[j].toString())) continue;
                    return newTransaction.getTransactionType();
                }
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "BeanDescriptor.getTransactionType(methodName,home,local): end--returning ApplicationServerTransaction.TX_SUPPORTS");
        }
        return 4;
    }

    private MethodDescriptor[] getMatchedMethodDescriptors(MethodDescriptor[] methodDescriptors, String methodName) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "BeanDescriptor.getMatchedMethodDescriptors(methodDescriptors, methodName): begin");
        }
        Vector<MethodDescriptor> v = null;
        for (int i = 0; methodDescriptors != null && i < methodDescriptors.length; ++i) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "methodDescriptors.length=" + methodDescriptors.length);
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "methodDescriptors[" + i + "]=" + methodDescriptors[i]);
            }
            String methodBeanName = methodDescriptors[i].getBeanName();
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "methodBeanName=" + methodBeanName);
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "this.getName()=" + this.getName());
            }
            if (!methodBeanName.equals(this.getName())) continue;
            String methodDescrName = methodDescriptors[i].getName();
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "methodDescrName=" + methodDescrName);
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "methodName=" + methodName);
            }
            if (!methodDescrName.equals(methodName)) continue;
            String methodType = MethodDescriptor.getMethodOriginName(methodDescriptors[i].getType());
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "methodType=" + methodType);
            }
            if (!methodType.equals("Home") && !methodType.equals("Remote")) continue;
            if (v == null) {
                v = new Vector<MethodDescriptor>();
            }
            v.add(methodDescriptors[i]);
        }
        if (v != null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "BeanDescriptor.getMatchedMethodDescriptors(methodDescriptors, methodName): end--returning MethodDescriptor.length=" + v.size());
            }
            return v.toArray(new MethodDescriptor[v.size()]);
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "BeanDescriptor.getMatchedMethodDescriptors(methodDescriptors, methodName): end--returning NULL");
        }
        return null;
    }

    private String constructMethod(String methodName, String[] parameters) {
        String s = null;
        for (int i = 0; parameters != null && i < parameters.length; ++i) {
            s = i == 0 ? parameters[i] : s + ", " + parameters[i];
        }
        return this.getName() + "." + methodName + "(" + s + ")";
    }

    public int getTTL() {
        return Integer.MAX_VALUE;
    }

    public Object updateCache(Object key, Object pm) {
        return null;
    }

    public Object cloneFromCache(Object key, Object dest) {
        return null;
    }

    public ExtendedContainerManagedObject removeFromCache(Object key) {
        return null;
    }

    public Object getOCAValue(Object key, String controlFieldName) throws IllegalAccessException {
        return null;
    }

    public AlternateHashTable getCache() {
        return null;
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public void setInterceptorManager(InterceptorManager interceptorManager) {
        this.interceptorManager = interceptorManager;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptorManager;
    }

    public abstract BeanDescriptorXMLFactory getBeanDescriptorXMLFactory();

    public CallManager getCallManager() {
        return this.callManager;
    }

    public String getTimeoutMethodName() {
        return this.timeoutMethodName;
    }

    public void setTimeoutMethodName(String name) {
        this.timeoutMethodName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodState getTimeoutMethodState() {
        if (this.timeoutMethodState == null) {
            BeanDescriptor beanDescriptor = this;
            synchronized (beanDescriptor) {
                if (this.timeoutMethodState == null) {
                    try {
                        String methodName = this.getTimeoutMethodName();
                        Class clazz = this.getEJBClass();
                        if (methodName == null) {
                            methodName = "ejbTimeout";
                            clazz = TimedObject.class;
                        }
                        Method ejbTimeout = clazz.getMethod(methodName, Timer.class);
                        this.timeoutMethodState = new MethodState(14, this, ejbTimeout).initialize();
                        this.timeoutMethodState.setLocal(true);
                    }
                    catch (SecurityException e) {
                        throw EJBUtils.createEJBException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw EJBUtils.createEJBException(e);
                    }
                }
            }
        }
        return this.timeoutMethodState;
    }

    public BeanPool getBeanPool() {
        return this.beanPool;
    }

    public void setBeanPool(BeanPool beanPool) {
        this.beanPool = beanPool;
    }

    protected abstract BeanPool createBeanPool(Object var1);

    public int getJAASMode() {
        return this.jaasMode;
    }

    public void setJAASMode(int jaasMode) {
        this.jaasMode = jaasMode;
    }

    public boolean isJAASEnabled() {
        return this.getJAASMode() == JAZNConfig.JAAS_MODE_DOAS || this.getJAASMode() == JAZNConfig.JAAS_MODE_DOAS_PRIVILEGED;
    }

    public void setInterceptorType(String newInterceptorType) {
        if (INTERCEPTOR_TYPE_BEAN.equalsIgnoreCase(newInterceptorType)) {
            this.interceptorType = INTERCEPTOR_TYPE_BEAN;
        } else if (INTERCEPTOR_TYPE_SINGLETON.equalsIgnoreCase(newInterceptorType)) {
            this.interceptorType = INTERCEPTOR_TYPE_SINGLETON;
        } else {
            throw DeploymentException.illegalInterceptorType(this, newInterceptorType);
        }
    }

    public String getInterceptorType() {
        return this.interceptorType;
    }

    public String getContextId() {
        StringBuffer prefix = new StringBuffer(this.getEJBPackage().getApplication().getName()).append(":").append(this.getEJBPackage().getName()).append(":");
        if (this.getName() != null) {
            prefix.append(this.getName());
        } else if (this.getBeanTypeString() != null) {
            prefix.append(this.getBeanTypeString());
        } else {
            prefix.append(this.getEJBClassName());
        }
        return prefix.toString();
    }
}

