/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.CreateStatelessSessionBeanMethodCompilation;
import com.evermind.server.ejb.compilation.HomeCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.compilation.StatelessSessionBeanCompilation;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;

public class StatelessSessionHomeCompilation
extends HomeCompilation {
    public StatelessSessionBeanCompilation beanCompilation;

    public StatelessSessionHomeCompilation(StatelessSessionBeanCompilation beanCompilation) {
        super(beanCompilation, "StatelessSessionHomeWrapper", beanCompilation.local ? beanCompilation.descriptor.getLocalHome() : beanCompilation.descriptor.getRemoteHome());
        this.beanCompilation = beanCompilation;
        if (beanCompilation.local) {
            this.beanCompilation.descriptor.setLocalHomeWrapperName(this.getName());
        } else {
            this.beanCompilation.descriptor.setRemoteHomeWrapperName(this.getName());
        }
    }

    public void cleanSource() {
        this.resetSource();
    }

    public void compile() throws CompilationException {
        this.compileMethods();
        this.source.append("import com.evermind.server.ejb.*;\nimport com.evermind.server.ejb.interceptor.MethodState;\nimport com.evermind.server.ejb.deployment.ExposableBeanDescriptor;\nimport com.evermind.server.*;\nimport javax.ejb.*;\n\npublic class " + this.className + " extends com.evermind.server.ejb." + (this.beanCompilation.local ? "Local" : "Remote") + "StatelessSessionEJBHome implements " + this.interfaceClass.getName() + "\n" + "{\n" + "private " + this.beanCompilation.getName() + " singletonInstance = null;\n");
        this.appendMethods();
        this.source.append("public StatelessSessionEJBObject getSingletonInstance()\n{\nif (singletonInstance == null)\n singletonInstance = new " + this.beanCompilation.getName() + "(this);\n" + "return this.singletonInstance;\n" + "}\n" + "\n");
        this.appendStaticDeclaration();
        this.appendStaticFunction();
        this.source.append("}\n");
        this.beanCompilation.compilation.addGenerator(this);
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        return this.compileMethod(method, this.beanCompilation.local);
    }

    public MethodCompilation compileMethod(Method method, boolean local) throws CompilationException {
        block5: {
            Class clazz = this.beanCompilation.local ? EJBLocalHome.class : EJBHome.class;
            if (method.getDeclaringClass() == clazz) {
                return null;
            }
            if (!method.getName().startsWith("create")) {
                throw new CompilationException("Invalid session-EJBHome interface method defined in " + method.getDeclaringClass().getName() + ": " + method.getName());
            }
            if (method.getParameterTypes().length > 0) {
                throw new CompilationException("Error compiling bean " + this.beanCompilation.descriptor.getName() + ": Stateless session bean home create methods cannot accept arguments (must be a zero argument method), the offending method is: " + method);
            }
            try {
                this.beanCompilation.descriptor.getEJBClass().getMethod("ejb" + Character.toUpperCase(method.getName().charAt(0)) + method.getName().substring(1), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                if (this.beanCompilation.descriptor.getPackage().getCompatibility() >= 3) break block5;
                throw new CompilationException("Method " + method + " not found in " + this.beanCompilation.descriptor.getEJBClassName());
            }
        }
        CreateStatelessSessionBeanMethodCompilation methodWrapper = new CreateStatelessSessionBeanMethodCompilation(this, method, local);
        ((MethodCompilation)methodWrapper).compile();
        return methodWrapper;
    }

    public BeanDescriptor getDescriptor() {
        return this.beanCompilation.getDescriptor();
    }
}

