/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.CreateStatefulSessionBeanMethodCompilation;
import com.evermind.server.ejb.compilation.HomeCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.compilation.StatefulSessionBeanCompilation;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;

public class StatefulSessionHomeCompilation
extends HomeCompilation {
    public StatefulSessionBeanCompilation beanCompilation;

    public StatefulSessionHomeCompilation(StatefulSessionBeanCompilation beanCompilation) {
        super(beanCompilation, "StatefulSessionHomeWrapper", beanCompilation.local ? beanCompilation.descriptor.getLocalHome() : beanCompilation.descriptor.getRemoteHome());
        this.beanCompilation = beanCompilation;
        if (beanCompilation.local) {
            this.beanCompilation.descriptor.setLocalHomeWrapperName(this.getName());
        } else {
            this.beanCompilation.descriptor.setRemoteHomeWrapperName(this.getName());
        }
    }

    public void cleanSource() {
        this.resetSource();
    }

    public void compile() throws CompilationException {
        this.compileMethods();
        this.source.append("import com.evermind.server.ejb.*;\nimport com.evermind.server.ejb.interceptor.MethodState;\nimport com.evermind.server.ejb.deployment.ExposableBeanDescriptor;\nimport com.evermind.server.*;\nimport javax.ejb.*;\n\npublic class " + this.className + " extends com.evermind.server.ejb." + (this.beanCompilation.local ? "Local" : "Remote") + "StatefulSessionEJBHome implements " + this.interfaceClass.getName() + "\n" + "{\n");
        this.source.append("public " + this.getName() + "() throws java.rmi.RemoteException\n{\n");
        this.source.append("}\n\n");
        this.appendMethods();
        this.appendGetWrapperMethod();
        this.appendStaticDeclaration();
        this.appendStaticFunction();
        this.source.append("}\n");
        this.beanCompilation.compilation.addGenerator(this);
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        return this.compileMethod(method, this.beanCompilation.local);
    }

    public MethodCompilation compileMethod(Method method, boolean local) throws CompilationException {
        Method beanMethod;
        block4: {
            Class clazz = this.beanCompilation.local ? EJBLocalHome.class : EJBHome.class;
            if (method.getDeclaringClass() == clazz) {
                return null;
            }
            if (!method.getName().startsWith("create")) {
                throw new CompilationException("Invalid session-EJBHome interface method defined in " + method.getDeclaringClass().getName() + ": " + method.getName());
            }
            beanMethod = null;
            try {
                beanMethod = this.beanCompilation.descriptor.getEJBClass().getMethod("ejb" + Character.toUpperCase(method.getName().charAt(0)) + method.getName().substring(1), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                if (this.beanCompilation.descriptor.getPackage().getCompatibility() >= 3 && method.getParameterTypes().length <= 0) break block4;
                throw new CompilationException("Method " + method + " not found in " + this.beanCompilation.descriptor.getEJBClassName());
            }
        }
        CreateStatefulSessionBeanMethodCompilation methodWrapper = new CreateStatefulSessionBeanMethodCompilation(this, method, beanMethod, local);
        ((MethodCompilation)methodWrapper).compile();
        return methodWrapper;
    }

    public BeanDescriptor getDescriptor() {
        return this.beanCompilation.getDescriptor();
    }

    public void appendGetWrapperMethod() {
        this.source.append("public StatefulSessionEJBObject getWrapperInstance(StatefulSessionContext context, long id, long checksum, String user)\n{\nreturn new " + this.beanCompilation.getName() + "(this, context, id, checksum, user);\n" + "}\n" + "\n");
    }
}

