/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.Compilable;
import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CombinedInterfaceCompilation
implements Compilable {
    private Compilation compilation;
    private ByteString source = new ByteString(256);
    private String interfaceName;
    private EJBPackage ejbPackage;
    private boolean local;
    private SessionBeanDescriptor descriptor;
    private Class interfaceClass;
    private static int id = 0;

    public CombinedInterfaceCompilation(Compilation compilation, SessionBeanDescriptor descriptor, EJBPackage ejbPackage, boolean local) {
        this.compilation = compilation;
        this.ejbPackage = ejbPackage;
        this.descriptor = descriptor;
        this.local = local;
        String suffix = local ? "Local" : "Remote";
        this.interfaceName = descriptor.getEJBClassName() + suffix + CombinedInterfaceCompilation.getNextID();
        int lastDot = this.interfaceName.lastIndexOf(46);
        if (lastDot != -1) {
            this.interfaceName = this.interfaceName.substring(lastDot + 1);
        }
    }

    public void generate() throws IOException {
        this.generate(null);
    }

    public void generate(List listSources) throws IOException {
        this.source.append("public interface " + this.interfaceName + " extends ");
        Iterator interfaces = (this.local ? this.descriptor.getLocalInterfaceNames() : this.descriptor.getRemoteInterfaceNames()).iterator();
        while (interfaces.hasNext()) {
            this.source.append((String)interfaces.next());
            if (!interfaces.hasNext()) continue;
            this.source.append(", ");
        }
        this.source.append(" {\n");
        this.source.append("}\n");
        if (listSources != null) {
            listSources.add(this);
        }
    }

    public void compile() throws IOException, InstantiationException, CompilationException {
        ArrayList<CombinedInterfaceCompilation> listSources = new ArrayList<CombinedInterfaceCompilation>();
        listSources.add(this);
        EJBCompilationUtils.batchCompileDefaultHomes(this.compilation, this.ejbPackage, listSources, false);
        this.interfaceClass = EJBCompilationUtils.getDefaultHomeClass(this.ejbPackage, this.interfaceName);
    }

    public void setInterfaceClass(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public SessionBeanDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.interfaceName;
    }

    public void cleanSource() {
        this.source.reset();
        this.source = null;
    }

    public ByteString getSource() {
        return this.source;
    }

    public Vector getDependentClasses() {
        return null;
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    private static synchronized int getNextID() {
        return id++;
    }
}

