/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.BeanCompilation;
import com.evermind.server.ejb.compilation.BeanMethodNotFoundException;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanMethodCompilation;
import com.evermind.server.ejb.compilation.HomeCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.rmi.Remote;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.ejb.Handle;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

public abstract class BeanMethodCompilation
extends MethodCompilation {
    private static final Class EXCEPTION_CLASS = Exception.class;
    protected boolean synced = true;
    protected String incovationTarget;
    protected BeanDescriptor descriptor;
    protected int transactionType;
    protected Collection invokers;
    protected boolean homeMethod;
    protected boolean entityMethod;
    protected boolean throwsRemoteException;
    protected Method beanMethod;
    protected Class[] beanExceptions;
    protected boolean local;
    protected String finderResponseTypeName;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public BeanMethodCompilation(ClassCompilation compilation, BeanDescriptor descriptor, Method method, boolean homeMethod, boolean entityMethod, String beanMethodName, boolean local) throws CompilationException {
        super(compilation, method);
        this.descriptor = descriptor;
        this.local = local;
        this.transactionType = descriptor.getTransactionType(method, homeMethod, local);
        this.homeMethod = homeMethod;
        this.entityMethod = entityMethod;
        this.beanMethod = this.getBeanMethod(beanMethodName);
        if (this.beanMethod != null) {
            this.beanExceptions = this.beanMethod.getExceptionTypes();
        }
        this.throwsRemoteException = false;
        for (int i = 0; i < this.exceptions.length; ++i) {
            if (!this.exceptions[i].isAssignableFrom(class$java$rmi$RemoteException == null ? BeanMethodCompilation.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) continue;
            this.throwsRemoteException = true;
        }
        if (descriptor.getPackage().getCompatibility() < 3 && !local && !this.throwsRemoteException) {
            throw new CompilationException(method.getDeclaringClass().getName() + "." + method.getName() + "() must explicitly throw java.rmi.RemoteException");
        }
    }

    protected Method getBeanMethod(String beanMethodName) throws CompilationException {
        if (beanMethodName == null) {
            return null;
        }
        try {
            Method beanMethod;
            this.beanMethod = beanMethod = this.descriptor.getEJBClass().getMethod(beanMethodName, this.method.getParameterTypes());
            this.checkReturnType(this.method.getReturnType(), beanMethod.getReturnType());
            if (Modifier.isFinal(beanMethod.getModifiers())) {
                throw new CompilationException("Method " + beanMethod + " can not be declared final");
            }
            if (Modifier.isAbstract(beanMethod.getModifiers())) {
                boolean isValid = false;
                if (this.descriptor instanceof EntityBeanDescriptor && ((EntityBeanDescriptor)this.descriptor).isCMP2_0()) {
                    EntityBeanDescriptor entityDescriptor = (EntityBeanDescriptor)this.descriptor;
                    try {
                        isValid = entityDescriptor.isPropertyMethod(beanMethod);
                    }
                    catch (IntrospectionException e) {
                        throw new CompilationException("Error introspecting entity bean " + this.descriptor.getEJBClassName() + ": " + e);
                    }
                }
                if (!isValid) {
                    throw new CompilationException("Method " + beanMethod + " can not be declared abstract for EJB '" + this.descriptor.getName() + "'");
                }
            }
            if (Modifier.isStatic(beanMethod.getModifiers())) {
                throw new CompilationException("Method " + beanMethod + " can not be declared static");
            }
            if (!Modifier.isPublic(beanMethod.getModifiers())) {
                throw new CompilationException("Method " + beanMethod + " must be declared public");
            }
            return beanMethod;
        }
        catch (NoSuchMethodException e) {
            throw new BeanMethodNotFoundException("Bean implementation of " + this.method + " (bean method signature should be public " + ClassUtils.getSourceNotation(this.method.getReturnType(), 0) + " " + this.descriptor.getEJBClassName() + "." + beanMethodName + "(...)) not found", this.method);
        }
    }

    protected void checkReturnType(Class returnType, Class beanReturnType) throws CompilationException {
        if (returnType != beanReturnType) {
            if (this.beanMethod == null) {
                throw new CompilationException("Unmatched return-type for " + this.method);
            }
            throw new CompilationException("Method " + this.beanMethod.getDeclaringClass() + "." + this.beanMethod.getName() + "(...) does not return " + ClassUtils.getSourceNotation(this.method.getReturnType(), 0) + " as specified by the remote interface " + this.method.getDeclaringClass().getName());
        }
    }

    public void compile() throws CompilationException {
        this.addMethodWrapperStart();
        this.addTransactionWrapperStart(true);
        this.addEJBInvocation();
        this.addTransactionWrapperEnd(true);
        this.addMethodWrapperEnd();
        this.addSupportingMethods();
    }

    public String getResponseTypeName() {
        if (this.entityMethod && this.homeMethod && this.getInvocationTarget() != null && this.finderResponseTypeName != null) {
            String tmp = this.finderResponseTypeName;
            this.finderResponseTypeName = null;
            return tmp;
        }
        String returnType = this.method.getReturnType().getName();
        returnType = returnType.replace('$', '.');
        return ClassUtils.getSourceNotation(returnType, 0);
    }

    protected void addMethodWrapperDmsStart() {
        this.source.append("// DMS begins\n");
        this.source.append("long wtoken = 0;\n");
        this.source.append("try {\n");
        this.source.append("if (ApplicationServer.DMS_GATE) {\n");
        this.source.append("wtoken = " + this.getMethodStateVariableName() + ".getWrapperPhaseEvent().start();\n");
        this.source.append("}\n");
        this.source.append("// DMS ends\n");
    }

    protected void addMethodWrapperDmsEnd() {
        this.source.append("// DMS begins\n");
        this.source.append("} finally {\n");
        this.source.append("if (ApplicationServer.DMS_GATE) {\n");
        this.source.append(this.getMethodStateVariableName() + ".getWrapperPhaseEvent().stop(wtoken);\n");
        this.source.append("}\n");
        this.source.append("}\n");
        this.source.append("// DMS ends\n");
    }

    protected void appendCopyByValue() {
        boolean needsCopyByValue;
        boolean bl = needsCopyByValue = this.descriptor.isCopyByValue() && !this.isLocal();
        if (needsCopyByValue) {
            Class type;
            int i;
            needsCopyByValue = false;
            for (i = 0; i < this.args.length; ++i) {
                type = this.args[i];
                if (!this.needsCopyByValue(type)) continue;
                needsCopyByValue = true;
                break;
            }
            if (needsCopyByValue || this.needsCopyByValue(this.method.getReturnType())) {
                this.source.append("boolean _firstEJBOn_RMI_Stack = false;\nif (_firstEJBOnStack  && thread.isRMICall()) \n_firstEJBOn_RMI_Stack = true;\n");
            }
            if (needsCopyByValue) {
                this.source.append("if((thread.contextContainer != null) && (!_firstEJBOn_RMI_Stack)) \n{\n");
                for (i = 0; i < this.args.length; ++i) {
                    type = this.args[i];
                    this.appendCopyByValue(this.source, type, type.getName(), "argument" + i, "");
                }
                this.source.append("}\n");
            }
        }
    }

    protected void appendExcludeMethod() {
        for (int i = 0; i < this.descriptor.getEJBPackage().getExcludeListMethods().size(); ++i) {
            if (((MethodDescriptor)this.descriptor.getEJBPackage().getExcludeListMethods().get(i)).implies(this.descriptor.getName(), this.method, this.local ? (this.homeMethod ? 4 : 3) : (this.homeMethod ? 2 : 1)) <= 0) continue;
            this.source.append("\nif ( 1 == 1 ) {\n");
            if (this.local) {
                this.source.append("throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Method in exclude-list\");\n}");
                continue;
            }
            this.source.append("throw new oracle.oc4j.rmi.OracleRemoteException(\"Method in exclude-list\");\n}");
        }
    }

    protected void appendSecurityCheck() {
        if (this.descriptor.getSecurityRoles(this.method, this.homeMethod, this.local) != Collections.EMPTY_LIST) {
            if (!this.homeMethod) {
                if (this.isLocal()) {
                    this.source.append("__authorizeAndAuthenticateLocal(" + this.getMethodStateVariableName() + ", params, thread);\n");
                } else {
                    this.source.append("__authorizeAndAuthenticateRemote(" + this.getMethodStateVariableName() + ", params, thread);\n");
                }
            } else if (this.isLocal()) {
                this.source.append("__authorizeAndAuthenticateLocal(" + this.getMethodStateVariableName() + ", params, thread);\n");
            } else {
                this.source.append("__authorizeAndAuthenticateRemote(" + this.getMethodStateVariableName() + ", params, thread);\n");
            }
        }
    }

    protected void appendRunAsStart() {
        if (this.descriptor.getSecurityIdentity() != null && this.descriptor.getSecurityIdentity().getSpecifiedIdentity() != null) {
            this.source.append("com.evermind.server.ejb.interceptor.system.RunAsInterceptor.RunAsHelper runAsHelper = new com.evermind.server.ejb.interceptor.system.RunAsInterceptor.RunAsHelper(thread, " + this.getHomeReference() + ".getBeanDescriptor().getRunAsUser(), this);\n" + "runAsHelper.setRunAsUser();\n" + "try {\n");
        } else {
            this.source.append("thread.shieldedUser = false;\n\n");
        }
    }

    protected void appendExceptionConversionStart() {
        this.source.append("\nThrowable methodException = null;\n\n");
    }

    public void addMethodWrapperStart() {
        this.source.append("private static MethodState " + this.getMethodStateVariableName() + ";\n");
        this.appendMethodWrapperStart(this.synced);
        this.source.append("\n{\n");
        this.appendInitMethodState();
        this.source.append("ThreadState thread = ThreadState.getCurrentState();\n");
        this.source.append("boolean _firstEJBOnStack = thread.getAndReset_firstEJBOnStack();\n");
        this.source.append("try {\n");
        this.appendStartCall();
        this.appendCopyByValue();
        this.appendParamsToObjectArray();
        this.addMethodWrapperDmsStart();
        this.appendExcludeMethod();
        this.appendSecurityCheck();
        if (this.method.getReturnType() != Void.TYPE) {
            this.source.append(this.getResponseTypeName());
            this.source.append(" response = ");
            this.source.append(ClassUtils.getDefaultValue(this.method.getReturnType()));
            this.source.append(";\n\n");
        }
        this.appendExceptionConversionStart();
        this.appendRunAsStart();
    }

    protected void appendStartCall() {
        this.source.append("OC4J_startCall(thread, _firstEJBOnStack);\n");
    }

    protected void appendEndCall() {
        this.source.append("OC4J_endCall(thread, _firstEJBOnStack);\n");
    }

    private boolean needsCopyByValue(Class type) {
        return Handle.class != type && !ClassUtils.getPrimitiveType(type).isPrimitive() && type != String.class && !EJBObject.class.isAssignableFrom(type) && !EntityContext.class.isAssignableFrom(type) && !EJBHome.class.isAssignableFrom(type) && !EJBLocalObject.class.isAssignableFrom(type) && !EJBLocalHome.class.isAssignableFrom(type) && !Remote.class.isAssignableFrom(type) && !UserTransaction.class.isAssignableFrom(type) && !Locale.class.isAssignableFrom(type) && !BigInteger.class.isAssignableFrom(type) && !InitialContext.class.isAssignableFrom(type);
    }

    private void appendCopyByValue(ByteString source, Class type, String typeName, String variable, String pre) {
        if (!this.needsCopyByValue(type)) {
            return;
        }
        if (java.util.Date.class == type) {
            source.append(pre + variable + " = " + variable + " == null ? null : new java.util.Date(" + variable + ".getTime());\n");
        } else if (Date.class == type) {
            source.append(pre + variable + " = " + variable + " == null ? null : new java.sql.Date(" + variable + ".getTime());\n");
        } else if (Timestamp.class == type) {
            source.append(pre + variable + " = " + variable + " == null ? null : new java.sql.Timestamp(" + variable + ".getTime());\n");
        } else {
            boolean isLocal = this.local;
            if (!(this.descriptor.getPackage().getCompatibility() < 3 || this.local || this.homeMethod || this.entityMethod || this.throwsRemoteException)) {
                isLocal = true;
            }
            source.append(pre + variable + " = " + variable + " == null ? null : (" + ClassUtils.getSourceNotation(typeName, 0, true) + ")EJBUtils.clone" + (isLocal ? "Local" : "") + "Object(" + variable + ", " + this.getHomeReference() + ");\n");
        }
    }

    protected void appendRunAsEnd() {
        if (this.descriptor.getSecurityIdentity() != null && this.descriptor.getSecurityIdentity().getSpecifiedIdentity() != null) {
            this.source.append("} finally {\n    runAsHelper.resetRunAsUser();\n}\n");
        }
    }

    protected void appendExceptionConversionEnd() {
        this.source.append("if(methodException != null) {\n");
        for (int i = 0; i < this.exceptions.length; ++i) {
            this.source.append("if(methodException instanceof " + this.exceptions[i].getName() + ") {\n" + "throw (" + this.exceptions[i].getName() + ")methodException;\n" + "}\n");
        }
        this.source.append(this.getFailedExecutionEndSource() + "__throwUncheckedException(methodException);\n");
        this.source.append("}\n");
    }

    public void addMethodWrapperEnd() {
        this.appendExceptionConversionEnd();
        this.appendRunAsEnd();
        if (this.method.getReturnType() != Void.TYPE) {
            this.appendResponseConverters();
            this.source.append("\n");
            this.appendReturnResponse();
        }
        this.addMethodWrapperDmsEnd();
        this.source.append("} finally {\n");
        this.appendEndCall();
        this.source.append("    if (_firstEJBOnStack)\nthread.set_firstEJBOnStack();\n}\n");
        this.source.append("}\n\n");
    }

    protected void appendReturnResponse() {
        Class<?> type = this.method.getReturnType();
        if (this.descriptor.getPackage().getCompatibility() >= 3) {
            if (ClassUtils.getPrimitiveType(type).isPrimitive() || type.isArray() || type == String.class) {
                this.source.append("return response;\n");
            } else {
                this.appendTransportSpecificResponse(type);
            }
        } else if (EJBObject.class.isAssignableFrom(type)) {
            this.appendTransportSpecificResponse(type);
        } else {
            this.source.append("return response;\n");
        }
    }

    private void appendTransportSpecificResponse(Class type) {
        this.source.append("if (thread.isCallerORMI()) {\n  return response;\n} else if (thread.isRMICall()) {\n");
        this.source.append("  return (" + type.getName() + ")" + this.getHomeReference() + ".getApplication().getTransportManager().getTransportSpecificResponseObject ( response );\n");
        this.source.append("} else {\n  return response;\n}\n");
    }

    public void appendResponseConverters() {
        if (this.descriptor.isCopyByValue() && !this.isLocal()) {
            Class<?> type = this.method.getReturnType();
            String typeName = null;
            typeName = type.isPrimitive() || type.isArray() ? type.getName() : this.getResponseTypeName();
            this.appendCopyByValue(this.source, type, typeName, "response", "if((thread.contextContainer != null) && !_firstEJBOn_RMI_Stack)\n");
        }
    }

    public void writeRegisterToTransaction(boolean alwaysExists, boolean throwException) {
        boolean registerTransactionSource = this.getRegisterTransactionSource();
        if (!alwaysExists) {
            this.source.append("if(" + EJBCompilationUtils.getTransactionDoesNotEqualNullString() + ") {\n");
        }
        this.source.append("try {\n");
        if (registerTransactionSource) {
            this.source.append("if(");
        }
        this.source.append(EJBCompilationUtils.getSynchronizationString() + ".registerBean(this)");
        if (registerTransactionSource) {
            this.source.append("|| this.context.isLazy()) {\n");
            if (this.isLocal()) {
                this.source.append("methodException = __doLoadStateLocal(thread, " + this.getIsUserTransactionExpression() + ", false, " + (this.descriptor.getPackage().getCompatibility() >= 3) + ", " + this.throwsRemoteException + ", methodException);\n");
            } else {
                this.source.append("methodException = __doLoadStateRemote(thread, " + this.getIsUserTransactionExpression() + ", false, " + (this.descriptor.getPackage().getCompatibility() >= 3) + ", " + this.throwsRemoteException + ", methodException);\n");
            }
            this.source.append("}\n");
        } else {
            this.source.append(";\n");
        }
        if (throwException) {
            this.source.append("} catch(javax.transaction.RollbackException e) {\nmethodException = EJBUtils.get" + (this.local ? "Local" : "") + "UserException(e, " + this.getIsUserTransactionExpression() + ");\n" + "}\n");
        } else {
            this.source.append("} catch(javax.transaction.RollbackException e) {}\n");
        }
        if (!alwaysExists) {
            this.source.append("}\n");
        }
    }

    protected void addContextContainerStart() {
        this.source.append("com.evermind.server.ContextContainer previousContainer = thread.contextContainer;\ntry {\nthread.contextContainer = " + this.getHomeReference() + ";\n" + "\n");
    }

    protected void addContextContainerEnd() {
        this.source.append("} finally {\nthread.contextContainer = previousContainer;\n}\n");
    }

    public void addTransactionWrapperStart(boolean waitForTX) {
        this.addContextContainerStart();
        if (this.transactionType == 6 || this.transactionType == 1) {
            this.source.append("int txRetries = 0;\n");
            this.source.append("boolean redoTX;\n");
            this.source.append("do\n{\nredoTX = false;\nmethodException = null;\n\n");
        }
        if (!this.homeMethod && waitForTX) {
            this.source.append("boolean isReentrantCall = startCall" + (this.isLocal() ? "Local" : "") + "(thread, " + this.descriptor.getCallTimeout() + "l, false);\n");
        }
        if (this.containerManagedTransactions()) {
            if (this.homeMethod) {
                this.source.append("ApplicationServerTransaction transaction = null;\n");
            }
            this.source.append("ApplicationServerTransaction suspendedTransaction = null;\n");
            this.source.append("boolean created = false;\n");
        } else {
            this.source.append("ApplicationServerTransaction savedTxn = null;\n");
        }
        if (!this.homeMethod && this.entityMethod) {
            this.source.append("if (this.isBeanremoved()) \n");
            this.source.append("{\n");
            if (this.local) {
                this.source.append("throw new javax.ejb.NoSuchObjectLocalException(\"Object is not registered\");\n");
            } else {
                this.source.append("throw new java.rmi.NoSuchObjectException(\"Object is not registered\");\n");
            }
            this.source.append("}\n");
        }
        this.source.append("try\n{\n");
        if (this.containerManagedTransactions()) {
            if (this.transactionType == 2) {
                String home = this.homeMethod ? "this" : "this.getMyHome()";
                this.source.append("try { \nsuspendedTransaction = (ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".suspend();\n" + "} catch (javax.transaction.SystemException e) { \n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error suspending transaction\", e);\n" + "}\n" + "traceLog(" + "\"[\"+" + home + ".getBeanDescriptor().getName() + \"]: transaction suspended\");\n");
                this.addStartTransactionMiddle();
            } else if (this.transactionType == 1) {
                this.source.append("Object[] _objects = __beginRequiredTransactionManager(thread, " + this.isLocal() + ", methodException);\n");
                this.source.append("methodException = (Throwable)_objects[0];\n");
                this.source.append("created = ((Boolean)_objects[1]).booleanValue();\n");
                this.source.append("if(methodException != null) break;\ntransaction = " + EJBCompilationUtils.getTransactionString() + ";\n" + "\n");
                this.addStartTransactionMiddle();
                if (!this.homeMethod && waitForTX) {
                    this.writeRegisterToTransaction(true, true);
                }
            } else if (this.transactionType == 3) {
                this.source.append("transaction = " + EJBCompilationUtils.getTransactionString() + ";\n");
                if (this.local) {
                    this.source.append("if(transaction == null) com.evermind.server.ejb.EJBUtils.throwTransactionRequiredLocalException();\n");
                } else {
                    this.source.append("if(transaction == null)  throw new javax.transaction.TransactionRequiredException();\n");
                }
                this.addStartTransactionMiddle();
                if (!this.homeMethod) {
                    this.writeRegisterToTransaction(true, false);
                }
            } else if (this.transactionType == 4) {
                this.source.append("transaction = " + EJBCompilationUtils.getTransactionString() + ";\n");
                this.addStartTransactionMiddle();
                if (!this.homeMethod) {
                    this.writeRegisterToTransaction(false, false);
                }
            } else if (this.transactionType == 6) {
                String home = this.homeMethod ? "this" : "this.getMyHome()";
                this.source.append("try { \nsuspendedTransaction = (ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".suspend();\n" + "} catch (javax.transaction.SystemException e) { \n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error suspending transaction\", e);\n" + "}\n" + "traceLog(\" transaction suspended\");\n");
                this.source.append("transaction = null;\ntry\n{\n" + EJBCompilationUtils.getTransactionManagerString() + ".begin();\ntransaction = " + EJBCompilationUtils.getTransactionString() + ";\n" + "created = true;\n" + "}\n" + "catch(javax.transaction.SystemException e)\n" + "{\n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error creating transaction\", e);\n" + "}\n" + "catch(javax.transaction.NotSupportedException e)\n" + "{\n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error creating transaction\", e);\n" + "}\n" + "\n");
                this.addStartTransactionMiddle();
                if (!this.homeMethod) {
                    this.writeRegisterToTransaction(true, false);
                }
            }
            if (this.transactionType == 5) {
                this.source.append("if(" + EJBCompilationUtils.getTransactionDoesNotEqualNullString() + ")\n" + "\tthrow new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"EntityBean method with attribute 'Never' set as TransactionLevel invoked in a global transaction-context\");\n");
                this.addStartTransactionMiddle();
            }
        }
    }

    protected void addStartTransactionMiddle() {
    }

    public void addTransactionWrapperEnd(boolean waitForTX) {
        this.source.append("}\nfinally\n{\n");
        if (this.containerManagedTransactions()) {
            String home;
            if (this.transactionType == 2) {
                home = this.homeMethod ? "this" : "this.getMyHome()";
                this.source.append("try { \nif(suspendedTransaction != null)\n\t " + EJBCompilationUtils.getTransactionManagerString() + ".resume(suspendedTransaction);\n" + "} catch (javax.transaction.SystemException e) { \n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error resuming transaction\", e);\n" + "} catch (javax.transaction.InvalidTransactionException e) { \n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error resuming transaction\", e);\n" + "}\n");
            } else if (this.transactionType == 1) {
                this.source.append("if(created)\n{\n");
                if (this.homeMethod) {
                    this.source.append("Object[] _objects = __completeGlobalTransaction(" + this.isLocal() + ", " + this.descriptor.getMaxTxRetries() + ", txRetries, redoTX, methodException);\n");
                } else {
                    this.source.append("Object[] _objects = __completeGlobalTransaction(" + waitForTX + ", " + this.isLocal() + ", " + this.descriptor.getMaxTxRetries() + ", txRetries, redoTX, methodException);\n");
                }
                this.source.append("methodException = (Throwable)_objects[0];\n");
                this.source.append("txRetries = ((Integer)_objects[1]).intValue();\n");
                this.source.append("redoTX = ((Boolean)_objects[2]).booleanValue();\n");
                this.source.append("}\n");
            } else if (this.transactionType != 4) {
                if (this.transactionType == 6) {
                    home = this.homeMethod ? "this" : "this.getMyHome()";
                    this.source.append("if(created)\n{\n");
                    if (this.homeMethod) {
                        this.source.append("Object[] _objects = __completeGlobalTransaction(" + this.isLocal() + ", " + this.descriptor.getMaxTxRetries() + ", txRetries, redoTX, methodException);\n");
                    } else {
                        this.source.append("Object[] _objects = __completeGlobalTransaction(" + waitForTX + ", " + this.isLocal() + ", " + this.descriptor.getMaxTxRetries() + ", txRetries, redoTX, methodException);\n");
                    }
                    this.source.append("methodException = (Throwable)_objects[0];\n");
                    this.source.append("txRetries = ((Integer)_objects[1]).intValue();\n");
                    this.source.append("redoTX = ((Boolean)_objects[2]).booleanValue();\n");
                    this.source.append("try { \nif(suspendedTransaction != null) \n\t " + EJBCompilationUtils.getTransactionManagerString() + ".resume(suspendedTransaction);\n" + "} catch (javax.transaction.SystemException e) { \n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error resuming transaction\", e);\n" + "} catch (javax.transaction.InvalidTransactionException e) { \n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Error resuming transaction\", e);\n" + "}\n");
                    this.source.append("}\n");
                } else if (this.transactionType == 3 || this.transactionType == 5) {
                    // empty if block
                }
            }
        }
        this.addPreResetContainer();
        if (this instanceof EntityBeanMethodCompilation) {
            this.source.append("AbstractEJBContext prePostCallSourceContext = this.context;\n");
        }
        this.addPostCallSource(this.source);
        if (this instanceof EntityBeanMethodCompilation) {
            EntityBeanMethodCompilation entityCompilationTemp = (EntityBeanMethodCompilation)this;
            String exHandler = "if(methodException != null ";
            exHandler = entityCompilationTemp.isLocal() ? exHandler + "&& methodException instanceof javax.ejb.EJBException) {\n   // Non-application exception handling for local entity bean\n   if (prePostCallSourceContext != null) {      prePostCallSourceContext.localWrapper = null;\n" : exHandler + "&& methodException instanceof java.rmi.RemoteException) {\n   // Non-application exception handling for remote entity bean\n   if (prePostCallSourceContext != null) {      prePostCallSourceContext.remoteWrapper = null;\n";
            exHandler = exHandler + " this.context = null;\n   }\n";
            String removeFromCacheStr = "";
            if (entityCompilationTemp.compilation.getEntityBeanDescriptor().isReadOnlyBMP() || entityCompilationTemp.compilation.getEntityBeanDescriptor().isBMP() && entityCompilationTemp.compilation.getEntityBeanDescriptor().getCommitOption().isCacheableOptionA()) {
                removeFromCacheStr = "((com.evermind.server.ejb.cache.BMPCacheManager) _cacheMgr).removeForBMP(getPrimaryKey(), getBeanDescriptor());\n";
            }
            exHandler = exHandler + removeFromCacheStr + "}\n";
            this.source.append(exHandler);
        }
        if (!this.homeMethod && waitForTX) {
            this.source.append("endCall" + (this.isLocal() ? "Local" : "") + "(isReentrantCall);\n");
        }
        this.source.append("}\n");
        if (this.transactionType == 6 || this.transactionType == 1) {
            this.source.append("}\n");
            this.source.append("while(redoTX);\n\n");
        }
        this.addContextContainerEnd();
    }

    protected void addPreResetContainer() {
    }

    protected void addPostCallSource(ByteString source) {
    }

    protected void addEJBInvocation() throws CompilationException {
        this.addEJBInvocation("response");
    }

    public void addEJBInvocation(String variableName) throws CompilationException {
        this.addEJBInvocation(variableName, true);
    }

    protected void addEJBInvocation(boolean wasTxnWrapperStartCalled) throws CompilationException {
        this.addEJBInvocation("response", wasTxnWrapperStartCalled);
    }

    public void addEJBInvocation(String variableName, boolean wasTxnWrapperStartCalled) throws CompilationException {
        this.source.append("try\n{\n");
        this.addTargetInvocation(variableName);
        this.appendPostEJBInvocation();
        this.source.append("}\n");
        this.checkBeanAndRemoteExceptions();
        List applicationExceptions = this.gatherApplicationExceptions(true);
        this.appendCatchApplicationExceptions(applicationExceptions, wasTxnWrapperStartCalled);
        this.appendExtraCatches(applicationExceptions);
        this.appendThrowable(applicationExceptions, wasTxnWrapperStartCalled);
    }

    public void appendThrowable(List applicationExceptions, boolean txnRetrylogic) {
        if (applicationExceptions != null && !applicationExceptions.contains(Throwable.class)) {
            this.source.append("catch(Throwable e)\n{\n");
            this.handleThrowable(txnRetrylogic);
            this.source.append("}\n");
        }
    }

    public void handleThrowable(boolean txnRetrylogic) {
        String errStr = "e";
        boolean ejbComp30 = this.descriptor.getPackage().getCompatibility() >= 3;
        boolean isTxRetries = this.transactionType == 6 || this.transactionType == 1;
        StringBuffer methodParams = new StringBuffer("methodException = __handleThrowableException(thread, " + errStr + ", ").append(this.getIsUserTransactionExpression() + ", true, " + this.isLocal());
        if (!txnRetrylogic || txnRetrylogic && (!isTxRetries || isTxRetries && !this.containerManagedTransactions())) {
            methodParams.append(", " + ejbComp30 + ", ").append(this.throwsRemoteException + ", methodException");
            if (this.homeMethod) {
                this.source.append(methodParams.toString() + ");\n");
            } else if (this.descriptor instanceof SessionBeanDescriptor && !((SessionBeanDescriptor)this.descriptor).isStateful()) {
                this.source.append(methodParams.toString() + ", context);\n");
            } else {
                this.source.append(methodParams.toString() + ", null);\n");
            }
        } else {
            methodParams.append(", created, " + ejbComp30 + ", ").append(this.throwsRemoteException + ", methodException").append(", txRetries, " + this.descriptor.getMaxTxRetries() + ", ").append(this.transactionType + ", " + this.containerManagedTransactions());
            if (this.homeMethod) {
                this.source.append(methodParams.toString() + ");\n");
            } else if (this.descriptor instanceof SessionBeanDescriptor && !((SessionBeanDescriptor)this.descriptor).isStateful()) {
                this.source.append(methodParams.toString() + ", context);\n");
            } else {
                this.source.append(methodParams.toString() + ", null);\n");
            }
        }
    }

    protected void appendExtraCatches(List applicationExceptions) throws CompilationException {
    }

    public boolean canThrow(Class type) {
        return this.canThrow(type, false, true);
    }

    public boolean canThrow(Class type, boolean inInterface, boolean includeRuntime) {
        Class[] exceptions;
        Class[] classArray = exceptions = inInterface ? this.exceptions : this.beanExceptions;
        if (includeRuntime && (RuntimeException.class.isAssignableFrom(type) || Error.class.isAssignableFrom(type))) {
            return true;
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!type.isAssignableFrom(exceptions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String getLogAndRollbackCode(String exceptionName, boolean setMethodException) {
        return BeanMethodCompilation.getRollbackTransaction(exceptionName + ".toString()", exceptionName) + this.getHomeReference() + ".OC4J_log(" + exceptionName + ");\n" + (setMethodException ? "methodException = " + this.getMethodExceptionConstructor(exceptionName) + ";\n" : "");
    }

    public static String getRollbackTransaction(String message, String throwable) {
        return BeanMethodCompilation.getRollbackTransaction(message, throwable, EJBCompilationUtils.getTransactionString());
    }

    public static String getRollbackTransaction(String message, String throwable, String transactionName) {
        return BeanMethodCompilation.getRollbackTransaction(message, throwable, transactionName, null);
    }

    public static String getRollbackTransaction(String message, String throwable, String transactionName, String objectPrefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("if(");
        buffer.append(transactionName);
        buffer.append(" != null) ");
        buffer.append("EJBTransactionManager.getInstance().setContainerRollbackOnly();\n");
        return buffer.toString();
    }

    public String getMethodExceptionConstructor(String exceptionName) {
        if (this.descriptor.getPackage().getCompatibility() >= 3 && !this.local && !this.throwsRemoteException) {
            return "com.evermind.server.ejb.EJBUtils.createEJBException(EJBUtils.getUserException(" + exceptionName + ", " + this.getIsUserTransactionExpression() + "))";
        }
        return "EJBUtils.get" + (this.local ? "Local" : "") + "UserException(" + exceptionName + ", " + this.getIsUserTransactionExpression() + ")";
    }

    public String getIsUserTransactionExpression() {
        switch (this.transactionType) {
            case 3: {
                return "true";
            }
            case 2: 
            case 5: 
            case 6: {
                return "false";
            }
            case 1: {
                return "!created";
            }
            case 4: {
                return EJBCompilationUtils.getTransactionDoesNotEqualNullString();
            }
        }
        throw new InternalError("Unknown transaction type: " + this.transactionType);
    }

    public boolean containerManagedTransactions() {
        return true;
    }

    public String getHomeReference() {
        if (this.homeMethod) {
            return "this";
        }
        return "this.getMyHome()";
    }

    public String getInvocationTarget() {
        if (this.incovationTarget != null) {
            return this.incovationTarget;
        }
        if (this.homeMethod) {
            if (this.descriptor instanceof SessionBeanDescriptor) {
                return "context.object";
            }
            return "context.getObject()";
        }
        if (this.descriptor instanceof EntityBeanDescriptor) {
            return "this._getObject()";
        }
        return "object";
    }

    public void setInvocationTarget(String incovationTarget) {
        this.incovationTarget = incovationTarget;
    }

    public void setSynchronized(boolean synced) {
        this.synced = synced;
    }

    public boolean checkIfThrows(Class type) {
        for (int i = 0; i < this.exceptions.length; ++i) {
            if (!type.isAssignableFrom(this.exceptions[i])) continue;
            return true;
        }
        return false;
    }

    public String getFailedExecutionEndSource() {
        return "";
    }

    public boolean getRegisterTransactionSource() {
        return false;
    }

    public boolean canBeTransaction() {
        return this.transactionType != 5 && this.transactionType != 2;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getMethodName() {
        if (!this.isLocal() && (this.declaringClass instanceof BeanCompilation ? ((BeanCompilation)this.declaringClass).local : ((HomeCompilation)this.declaringClass).beanCompilation.local)) {
            return "__REMOTE__" + this.method.getName();
        }
        return this.method.getName();
    }

    protected void appendPostEJBInvocation() {
    }

    public void appendApplicationExceptionHandling() {
    }

    public void appendCatchApplicationExceptions(List applicationExceptions, boolean wasTxnWrapperStartCalled) {
        for (int i = 0; i < applicationExceptions.size(); ++i) {
            boolean checkForAppException;
            Class exceptionClass = (Class)applicationExceptions.get(i);
            String exceptionToString = exceptionClass.toString();
            if (!this.canThrow(exceptionClass)) continue;
            if (exceptionToString.startsWith("class ")) {
                this.source.append("catch(" + exceptionToString.substring(6) + " e) {\n");
            } else {
                this.source.append("catch(" + exceptionToString + " e) {\n");
            }
            boolean bl = checkForAppException = exceptionClass == EXCEPTION_CLASS;
            if (checkForAppException) {
                this.source.append("\tif (!EJBUtils.isApplicationException(e)) {\n");
                this.handleThrowable(wasTxnWrapperStartCalled);
                this.source.append("\t} else {\n");
            }
            if (exceptionToString.startsWith("class ") && exceptionToString.substring(6).equals("javax.ejb.FinderException")) {
                this.source.append("\tif (e.getMessage() != null)\n");
            }
            this.source.append("\tmethodException = e;\n");
            this.appendApplicationExceptionHandling();
            if (checkForAppException) {
                this.source.append("\t}\n");
            }
            this.source.append("}\n");
        }
    }

    List gatherApplicationExceptions(boolean skipRemoteException) {
        ArrayList<Class> applicationExceptions = new ArrayList<Class>();
        for (int i = 0; i < this.exceptions.length; ++i) {
            if ((class$java$lang$RuntimeException == null ? BeanMethodCompilation.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(this.exceptions[i]) || (class$java$rmi$RemoteException == null ? BeanMethodCompilation.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(this.exceptions[i]) && skipRemoteException) continue;
            boolean alreadyCaught = false;
            for (int y = 0; y < applicationExceptions.size(); ++y) {
                if (!((Class)applicationExceptions.get(y)).isAssignableFrom(this.exceptions[i])) continue;
                alreadyCaught = true;
                break;
            }
            if (alreadyCaught) continue;
            applicationExceptions.add(this.exceptions[i]);
        }
        return applicationExceptions;
    }

    void checkBeanAndRemoteExceptions() throws CompilationException {
        for (int i = 0; i < this.beanExceptions.length; ++i) {
            if ((class$java$lang$RuntimeException == null ? BeanMethodCompilation.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(this.beanExceptions[i])) continue;
            boolean isAssignable = false;
            for (int x = 0; x < this.exceptions.length; ++x) {
                if (!this.exceptions[x].isAssignableFrom(this.beanExceptions[i])) continue;
                isAssignable = true;
                break;
            }
            if (isAssignable) continue;
            throw new CompilationException("Cannot throw " + this.beanExceptions[i].getName() + " from " + this.beanMethod.getDeclaringClass() + "." + this.beanMethod.getName() + "(), it is not an exception specified in the " + (this.local ? "local" : "remote") + " interface " + this.method.getDeclaringClass().getName());
        }
    }

    protected void appendInitMethodState() {
        this.source.append("if (" + this.getMethodStateVariableName() + " == null) {\n");
        this.source.append("    " + this.getMethodStateVariableName() + " = ((ExposableBeanDescriptor)" + this.getHomeReference() + ".getBeanDescriptor()).getMethodState(" + this.isLocal() + ", " + this.homeMethod + ", \"" + this.method.getName() + ClassUtils.getCodedArguments(this.method) + "\");\n");
        this.source.append("}\n");
    }

    protected void addTargetInvocation(String variableName) {
        this.addTargetInvocation(variableName, "context");
    }

    protected void addTargetInvocation(String variableName, String contextName) {
        this.source.append("\n");
        Class<?> returnType = this.method.getReturnType();
        if (returnType != Void.TYPE && variableName != null) {
            if (returnType.isPrimitive()) {
                String tempReturnTypeName = ClassUtils.getNonPrimitiveType(returnType).getName();
                this.source.append(tempReturnTypeName + " tempReturn = (" + tempReturnTypeName + ") ");
            } else if (returnType == Object.class) {
                this.source.append(variableName + " = ");
            } else {
                this.source.append(variableName + " = (" + this.getResponseTypeName() + ") ");
            }
        }
        String homeWrapper = this.getHomeReference();
        String beanWrapper = this.homeMethod ? "null" : "this";
        this.source.append("new InvocationContextImpl(" + this.getMethodStateVariableName() + ", " + this.getInvocationTarget() + ", " + contextName + ", params, thread," + beanWrapper + "," + homeWrapper + ").proceed();\n");
        if (returnType != Void.TYPE && variableName != null && returnType.isPrimitive()) {
            this.source.append(variableName + " = ");
            this.source.append(ClassUtils.getConvertSource("tempReturn", ClassUtils.getNonPrimitiveType(returnType), returnType));
            this.source.append(";\n");
        }
        this.source.append("\n");
    }
}

