/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

class IntQuickMap {
    protected intHashMapEntry[] _entries;
    protected volatile long _numberOfObjects;
    protected int _threshold;
    protected float _loadFactor;

    public IntQuickMap() {
        this(89, 0.75f);
    }

    public IntQuickMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntQuickMap(int initialCapacity, float _loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (_loadFactor <= 0.0f || Float.isNaN(_loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + _loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this._loadFactor = _loadFactor;
        this._entries = new intHashMapEntry[initialCapacity];
        this._threshold = (int)((float)initialCapacity * _loadFactor);
    }

    public boolean isEmpty() {
        return this._numberOfObjects == 0L;
    }

    public long size() {
        return this._numberOfObjects;
    }

    public int get(int key) {
        intHashMapEntry[] tab = this._entries;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        intHashMapEntry e = tab[index];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public int remove(int key) {
        intHashMapEntry[] tab = this._entries;
        int result = 0;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        intHashMapEntry p = null;
        intHashMapEntry e = tab[index];
        while (e != null) {
            if (key == e.key) {
                result = e.value;
                if (p == null) {
                    tab[index] = null;
                } else {
                    p.next = e.next;
                }
                --this._numberOfObjects;
                break;
            }
            p = e;
            e = e.next;
        }
        return result;
    }

    public int put(int key, int value) {
        intHashMapEntry[] tab = this._entries;
        int index = 0;
        index = (key & Integer.MAX_VALUE) % tab.length;
        intHashMapEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this._numberOfObjects >= (long)this._threshold) {
            this.rehash();
            tab = this._entries;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new intHashMapEntry(key, value, tab[index]);
        ++this._numberOfObjects;
        return 0;
    }

    private void rehash() {
        int oldCapacity = this._entries.length;
        intHashMapEntry[] oldMap = this._entries;
        int newCapacity = oldCapacity * 2 + 1;
        intHashMapEntry[] newMap = new intHashMapEntry[newCapacity];
        this._threshold = (int)((float)newCapacity * this._loadFactor);
        this._entries = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            intHashMapEntry old = oldMap[i];
            while (old != null) {
                intHashMapEntry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public void clear() {
        intHashMapEntry[] tab = this._entries;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this._numberOfObjects = 0L;
    }

    class intHashMapEntry {
        int key;
        int value;
        intHashMapEntry next;

        protected intHashMapEntry(int key, int value, intHashMapEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

