/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.cache.AbstractCacheManager;
import com.evermind.server.ejb.cache.BMPLockException;
import com.evermind.server.ejb.cache.CacheManagerException;
import com.evermind.server.ejb.cache.PrivateAccessor;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EntityBean;
import javax.transaction.SystemException;

public class BMPCacheManager
extends AbstractCacheManager {
    private static AbstractCacheManager _instance;
    private static Object _CacheManagerLock;
    private static Logger m_logger;

    protected BMPCacheManager() {
        _instance = this;
    }

    public void checkForUpdate(EntityEJBObject[] entries, int entriesCount, ApplicationServerTransactionSynchronization tx) throws CacheManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractCacheManager instance() {
        if (_instance == null) {
            Object object = _CacheManagerLock;
            synchronized (object) {
                if (_instance == null) {
                    _instance = new BMPCacheManager();
                }
            }
        }
        return _instance;
    }

    public void update(EntityEJBObject[] entries, int entriesCount) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "- update -> " + entriesCount);
        }
        for (int i = 0; i < entriesCount; ++i) {
            EntityEJBObject bean = entries[i];
            if (!bean.OC4J_isCacheable()) continue;
            try {
                Object value = bean.getEntityBean();
                if (value == null) continue;
                Object key = bean.getPrimaryKey_X();
                if (((EntityBeanDescriptor)bean.getBeanDescriptor()).getCommitOption().useOCA()) {
                    if (!this.allowToUpdate(bean, ((EntityBeanDescriptor)bean.getBeanDescriptor()).getCommitOption().getName())) continue;
                    value = bean.getBeanDescriptor().updateCache(key, value);
                    continue;
                }
                value = bean.getBeanDescriptor().updateCache(key, value);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public Object put(Object key, EntityEJBObject bean) {
        Object obj = bean.getBeanDescriptor().updateCache(key, bean.getEntityBean());
        if (m_logger.isLoggable(Level.FINE)) {
            int ocn = 0;
            if (obj != null) {
                m_logger.log(Level.FINE, "+ put - updated object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
            } else {
                m_logger.log(Level.FINE, "+ put - created object " + key + " ocn=" + ocn + " " + bean.getBeanDescriptor().getEJBClassName());
            }
        }
        return obj;
    }

    public Object clone(Object key, BeanDescriptor desc, Object dest) {
        if (m_logger.isLoggable(Level.FINE) && dest == null) {
            m_logger.log(Level.FINE, "+ clone - error " + key + " dest=" + dest + " " + desc.getEJBClassName());
        }
        Object obj = desc.cloneFromCache(key, dest);
        if (m_logger.isLoggable(Level.FINE)) {
            boolean ocn = false;
            if (obj != null) {
                m_logger.log(Level.FINE, "+ clone - cache hit " + key + " " + desc.getEJBClassName() + " " + dest);
            }
        }
        return obj;
    }

    public ExtendedContainerManagedObject remove(Object key, BeanDescriptor desc) {
        return null;
    }

    public EntityBean removeForBMP(Object key, BeanDescriptor desc) {
        EntityBean obj = (EntityBean)desc.getCache().remove(key, false);
        if (m_logger.isLoggable(Level.FINE)) {
            if (obj != null) {
                m_logger.log(Level.FINE, "+ remove - cache hit " + key + " " + desc.getEJBClassName());
            } else {
                m_logger.log(Level.FINE, "+ remove - not found " + key + " " + desc.getEJBClassName());
            }
        }
        return obj;
    }

    public boolean allowToUpdate(EntityEJBObject bean, String controlFieldName) {
        Object aMainOCAValue;
        Object aWorkingOCAValue;
        block12: {
            aWorkingOCAValue = null;
            aMainOCAValue = null;
            try {
                aWorkingOCAValue = PrivateAccessor.getPrivateFieldValue(bean.getEntityBean(), controlFieldName);
                aMainOCAValue = bean.getBeanDescriptor().getOCAValue(bean.getPrimaryKey_X(), controlFieldName);
            }
            catch (IllegalAccessException e) {
                if (m_logger.isLoggable(Level.FINE)) {
                    e.printStackTrace();
                    m_logger.log(Level.FINE, e.getMessage());
                }
            }
            catch (RemoteException e) {
                if (!m_logger.isLoggable(Level.FINE)) break block12;
                e.printStackTrace();
                m_logger.log(Level.FINE, e.getMessage());
            }
        }
        if (aWorkingOCAValue != null && aMainOCAValue != null) {
            if (this.compareValue(aWorkingOCAValue, aMainOCAValue, aWorkingOCAValue.getClass()) < 0) {
                try {
                    if (ApplicationServer.getInstance().getTransactionManager().getTransaction() != null) {
                        EJBTransactionManager.getInstance().setContainerRollbackOnly();
                    }
                }
                catch (SystemException systemException) {
                    m_logger.log(Level.WARNING, "SystemException during getTransaction call : " + (Object)((Object)systemException));
                }
                throw new BMPLockException("Lock Exception Detected: working OCA value older then main OCA value");
            }
            if (this.compareValue(aWorkingOCAValue, aMainOCAValue, aWorkingOCAValue.getClass()) > 0) {
                return true;
            }
        } else if (aMainOCAValue == null && aWorkingOCAValue != null) {
            return true;
        }
        return false;
    }

    private int compareValue(Object firstObject, Object secondObject, Class type) {
        int aResult = firstObject instanceof Integer ? ((Integer)firstObject).compareTo((Integer)secondObject) : ((Long)firstObject).compareTo((Long)secondObject);
        return aResult;
    }

    static {
        _CacheManagerLock = new Object();
        m_logger = EJBTraceLogger.getLogger(BMPCacheManager.class);
    }
}

