/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.cache;

import com.evermind.server.ejb.cache.AlternateHashTable;
import com.evermind.server.ejb.cache.CachePolicy;
import com.evermind.server.ejb.cache.CloneAndCopyManager;
import com.evermind.util.ExtendedComparator;

public class BMObjectsHashTable
extends AlternateHashTable {
    ExtendedComparator _comparator = ExtendedComparator.DEFAULT_COMPARATOR;
    CachePolicy _accessPolicy = CachePolicy.DEFAULT_POLICY;
    CloneAndCopyManager cloneAndCopyMgr = new CloneAndCopyManager();

    public BMObjectsHashTable(int initialCapacity) {
        super(initialCapacity);
    }

    public BMObjectsHashTable(int initialCapacity, ExtendedComparator comparator, CachePolicy policy) {
        this(initialCapacity);
        if (comparator != null) {
            this._comparator = comparator;
        }
        if (policy != null) {
            this._accessPolicy = policy;
        }
    }

    public void setComparator(ExtendedComparator comparator) {
        this._comparator = comparator;
    }

    public final Object cloneValue(Object value, boolean merge) {
        try {
            return this.cloneAndCopyMgr.shallowClone(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed clonning object " + value, e);
        }
    }

    public final Object copyValue(Object from, Object to, boolean merge) {
        try {
            return this.cloneAndCopyMgr.shallowCopy(from, to);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed copying object " + from, e);
        }
    }

    public final boolean isKeyEqual(Object key1, Object key2) {
        return this._comparator.equalKeys(key1, key2);
    }

    public int keyHashCode(Object object) {
        return this._comparator.keyHashCode(object);
    }

    public int altKeyHashCode(Object object) {
        return this._comparator.keyHashCode(object);
    }

    public void updateAccess(AlternateHashTable.BucketEntry currNode, AlternateHashTable.Bucket b) {
        long time;
        b.access = time = this.getTime();
        currNode.access = time;
    }

    public long getTime() {
        return this._accessPolicy.getTime();
    }

    public boolean hasExpired(AlternateHashTable.BucketEntry currNode, AlternateHashTable.Bucket b, int ttl) {
        return this._accessPolicy.expired(currNode.access, ttl);
    }
}

