/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.administration;

import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.administration.DefaultBeanAdministrator;
import com.evermind.server.ejb.administration.DefaultEntityBeanAdministrator;
import com.evermind.server.ejb.administration.DefaultMessageDrivenBeanAdministrator;
import com.evermind.server.ejb.administration.DefaultSessionBeanAdministrator;
import com.evermind.server.ejb.administration.EJBPackageAdministrator;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;

public class DefaultEJBPackageAdministrator
implements EJBPackageAdministrator {
    private EJBContainer container;
    private EJBPackageDeployment ejbPackageDeployment;

    public DefaultEJBPackageAdministrator(EJBContainer container, EJBPackageDeployment ejbPackageDeployment) {
        this.container = container;
        this.ejbPackageDeployment = ejbPackageDeployment;
    }

    public List getBeans() throws InstantiationException {
        List beans;
        if (this.ejbPackageDeployment == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DefaultBeanAdministrator> response = new ArrayList<DefaultBeanAdministrator>();
        EJBPackage ejbPackage = this.ejbPackageDeployment.getPackage();
        if (ejbPackage != null && (beans = ejbPackage.getBeans()) != null) {
            for (int i = 0; i < beans.size(); ++i) {
                BeanDescriptor bean = (BeanDescriptor)beans.get(i);
                if (bean instanceof EntityBeanDescriptor) {
                    try {
                        response.add(new DefaultEntityBeanAdministrator((EntityBeanDescriptor)bean, (AbstractEJBHome)this.container.getApplication().getContext().lookup(((EntityBeanDescriptor)bean).getLocation())));
                        continue;
                    }
                    catch (NamingException e) {
                        throw new InstantiationException("Error looking up EJBHome in the namespace: " + e.getMessage());
                    }
                }
                if (bean instanceof SessionBeanDescriptor) {
                    try {
                        response.add(new DefaultSessionBeanAdministrator((SessionBeanDescriptor)bean, (AbstractEJBHome)this.container.getApplication().getContext().lookup(((SessionBeanDescriptor)bean).getLocation())));
                        continue;
                    }
                    catch (NamingException e) {
                        throw new InstantiationException("Error looking up EJBHome in the namespace: " + e.getMessage());
                    }
                }
                if (!(bean instanceof MessageDrivenBeanDescriptor)) continue;
                response.add(new DefaultMessageDrivenBeanAdministrator((MessageDrivenBeanDescriptor)bean, ejbPackage.getDeployment().getMessageDrivenHome(bean.getName())));
            }
        }
        return response;
    }

    public void uninstall(boolean deleteFiles) throws RemoteException {
    }
}

