/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.RemoteStatefulSessionEJBHome;
import com.evermind.server.ejb.persistence.XPCManager;
import java.util.Hashtable;
import javax.ejb.SessionContext;
import javax.xml.rpc.handler.MessageContext;

public class StatefulSessionContext
extends AbstractEJBContext
implements SessionContext {
    public Object object;
    public Hashtable attributes = null;
    private XPCManager xpm;

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
        if (this.remoteHome == null) {
            return;
        }
        RemoteStatefulSessionEJBHome rsfsH = (RemoteStatefulSessionEJBHome)this.remoteHome;
        rsfsH.container.replicationService.sendSessionValueUpdate(this, name, value);
    }

    public void setAttributeSilently(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
    }

    public MessageContext getMessageContext() {
        throw new IllegalStateException("getMessageContext() not allowed to be called by stateful session bean");
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public boolean getRollbackOnly() {
        if (this.actionTaken == 17) {
            throw new IllegalStateException("Cannot call getRollbackOnly() from afterCompletion()");
        }
        return super.getRollbackOnly();
    }

    public void setRollbackOnly() {
        if (this.actionTaken == 17) {
            throw new IllegalStateException("Cannot call setRollbackOnly() from afterCompletion()");
        }
        super.setRollbackOnly();
    }

    public Object getBusinessObject(Class businessInterface) throws IllegalStateException {
        if (!this.isEJB30Compatible()) {
            throw new IllegalStateException("Cannot invoke getBusinessObject method if the stateful session is not EJB30");
        }
        return super.getBeanInstanceByBusinessInterface(businessInterface);
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        if (!this.isEJB30Compatible()) {
            throw new IllegalStateException("Cannot invoke getInvokedBusinessInterface method if the stateful session is not EJB3.0");
        }
        return super.getSessionBusinessInterfaceClass();
    }

    public XPCManager getXPCManager() {
        return this.xpm;
    }

    public void setXPCManager(XPCManager xpm) {
        this.xpm = xpm;
    }
}

