/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Attributes;

public class MarkerInterfaceEnhancer
extends ClassAdapter {
    private Class markerInterface;
    private boolean enhanced;

    public MarkerInterfaceEnhancer(Class markerInterface, ClassVisitor visitor) {
        super(visitor);
        this.markerInterface = markerInterface;
    }

    public boolean wasEnhanced() {
        return this.enhanced;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        String[] newInterfaces;
        if (interfaces == null || interfaces.length == 0) {
            newInterfaces = new String[1];
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].equals(Type.getType((Class)this.markerInterface).getInternalName())) {
                    this.cv.visit(version, access, name, superName, interfaces, sourceFile);
                    return;
                }
                try {
                    Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass(interfaces[i].replace('/', '.'));
                    if (!this.markerInterface.isAssignableFrom(c)) continue;
                    this.cv.visit(version, access, name, superName, interfaces, sourceFile);
                    return;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            int n = 1 + interfaces.length;
            newInterfaces = new String[n];
            System.arraycopy(interfaces, 0, newInterfaces, 0, n - 1);
        }
        newInterfaces[newInterfaces.length - 1] = Type.getType((Class)this.markerInterface).getInternalName();
        this.cv.visit(version, access, name, superName, newInterfaces, sourceFile);
        this.enhanced = true;
    }

    public static byte[] transformClass(String className, byte[] bytes, Class markerInterface) {
        ClassWriter cw = new ClassWriter(true, true);
        MarkerInterfaceEnhancer enhancer = new MarkerInterfaceEnhancer(markerInterface, (ClassVisitor)cw);
        ClassReader cr = new ClassReader(bytes);
        cr.accept((ClassVisitor)enhancer, Attributes.getDefaultAttributes(), false);
        if (enhancer.wasEnhanced()) {
            return cw.toByteArray();
        }
        return null;
    }
}

