/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.logging.EJBRuntimeMessages;

public class CallManager {
    private int activeMethodCount;
    private long callTimeout;

    public CallManager(long callTimeout) {
        this.callTimeout = callTimeout;
    }

    public synchronized void beginMethodCall() {
        ++this.activeMethodCount;
    }

    public synchronized void endMethodCall() {
        --this.activeMethodCount;
        if (this.activeMethodCount == 0) {
            this.notify();
        }
    }

    public synchronized void waitForActiveMethodCalls(String name) {
        long startTime = System.currentTimeMillis();
        long waitTime = this.getCallTimeout();
        if (waitTime >= 0L) {
            while (this.activeMethodCount > 0) {
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {
                    break;
                }
                if ((waitTime -= System.currentTimeMillis() - startTime) > 0L) continue;
            }
        }
        if (this.activeMethodCount > 0) {
            EJBRuntimeMessages.warningTimeoutWaitingForActiveCalls(name, this.activeMethodCount);
        }
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public void setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
    }

    public int getActiveMethodCount() {
        return this.activeMethodCount;
    }
}

