/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.net.AddressContainer;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ContextContainer;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.CallManager;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBHomeObjectInfo;
import com.evermind.server.ejb.EJBObjectKey;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.interceptor.system.JACCInterceptor;
import com.evermind.server.ejb.interceptor.system.SecurityRoleInterceptor;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.rmi.ObjectInfo;
import com.evermind.server.rmi.ObjectInfoFactory;
import com.evermind.util.OrderedSet;
import com.oracle.server.ejb.persistence.pm.PersistenceManager;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.CorbaReferenceGenerator;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.rmi.ApplicationStoppedException;
import oracle.oc4j.security.acc.JaccWrapper;
import oracle.oc4j.transport.TransportManager;
import org.omg.PortableServer.Servant;

public abstract class AbstractEJBHome
implements ContextContainer,
CorbaEJBHome,
EJBObjectKey,
ObjectInfoFactory {
    private TransportManager m_transportManager;
    EJBContainer container;
    boolean containerManagedTransactions = true;
    Context context;
    protected String bindingPath;
    EJBPackageDeployment ejbPackage;
    Map roleMappings;
    private Map lookedUpHomes;
    private Map lookedUpLocalHomes;
    public AbstractEJBHome theOtherHome = null;
    public boolean isRemote = true;
    public boolean supportBoth_L_R = false;
    public boolean inEjbCreate = false;
    protected int lockingMode;
    BeanDescriptor _desc;
    CallManager cm;
    protected PersistenceManager pm;
    private EJBHome m_corbaHomeReference;
    private Servant m_servant;
    private Map m_ejbServantMap;
    private CorbaReferenceGenerator m_corbaReferenceGenerator;
    private static Logger m_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setContainer(EJBContainer container, EJBPackageDeployment ejbPackage, Map roleMappings) {
        if (this.container != null) {
            throw new SecurityException("Container already set");
        }
        this.container = container;
        this.ejbPackage = ejbPackage;
        this.roleMappings = roleMappings;
        this.init();
    }

    protected void init() {
    }

    public void setContainerManagedTransactions(boolean cmt) {
        this.containerManagedTransactions = cmt;
    }

    public void setContext(Context context) {
        if (this.context != null) {
            throw new SecurityException("Context already set");
        }
        this.context = context;
    }

    public void OC4J_setBindingPath(String path) {
        if (this.bindingPath != null) {
            throw new SecurityException("bindingPath already set");
        }
        this.bindingPath = path;
    }

    public String OC4J_getBindingPath() {
        return this.bindingPath;
    }

    public Context getEnvironmentContext() {
        return this.context;
    }

    public AbstractEJBObject newCreate(AbstractEJBContext ac) {
        m_logger.log(Level.WARNING, "AbstractEJBHome:newCreate, this should not be invoked, classname: " + this.getClass().getName());
        return null;
    }

    public void getTheOtherLRWrappers(AbstractEJBContext ac) {
        if (!this.supportBoth_L_R) {
            throw new IllegalStateException("Bean " + this.getBeanName() + " does not support dual remote and local interfaces");
        }
        try {
            AbstractEJBHome ah = this.ejbPackage.getHomeInstance(this.container, this.getBeanName(), this.isRemote);
            if (ah == null) {
                EJBRuntimeMessages.infoNoneHomeInstance(this.getBeanDescriptor());
                throw new IllegalStateException("Bean " + this.getBeanName() + " having internal error...");
            }
            ah.containerManagedTransactions = this.containerManagedTransactions;
            if (this.isRemote) {
                ac.localHome = ah;
                ac.localWrapper = ah.newCreate(ac);
                if (ac.remoteWrapper != null) {
                    ac.canBeReleased = false;
                }
            } else {
                ac.remoteHome = ah;
                ac.remoteWrapper = ah.newCreate(ac);
                if (ac.localWrapper != null) {
                    ac.canBeReleased = false;
                }
            }
        }
        catch (Exception e) {
            IllegalStateException ie = new IllegalStateException("Bean " + this.getBeanName() + " encounters exception : " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public EJBMetaData getEJBMetaData() throws RemoteException {
        throw new IllegalStateException("May not invoke getEJBMetaData for a local home");
    }

    public void OC4J_log(Throwable t) {
        while (t instanceof EJBException && ((EJBException)t).getCausedByException() != null) {
            t = ((EJBException)t).getCausedByException();
        }
        this.container.application.log("Error in bean " + this.bindingPath, t);
    }

    public void OC4J_log(String message, Throwable t) {
        while (t instanceof EJBException && ((EJBException)t).getCausedByException() != null) {
            t = ((EJBException)t).getCausedByException();
        }
        this.container.application.log("Error in bean " + this.bindingPath + ": " + message, t);
    }

    public HomeHandle getHomeHandle() throws RemoteException {
        return this.getTransportManager().getHomeHandle(this);
    }

    public AbstractEJBHome getHome(String location) {
        return this.getHome(location, false);
    }

    public AbstractEJBHome getHomeLocal_or_Remote(String location) {
        AbstractEJBHome _home;
        Exception e1 = null;
        try {
            _home = this.getHome(location, true);
            if (_home != null) {
                return _home;
            }
        }
        catch (Exception e) {
            e1 = e;
        }
        try {
            _home = this.getHome(location, false);
            if (_home != null) {
                return _home;
            }
        }
        catch (Exception e) {
            this.OC4J_log(e);
            return null;
        }
        this.OC4J_log(e1);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEJBHome getHome(String location, boolean local) {
        AbstractEJBHome abstractEJBHome = this;
        synchronized (abstractEJBHome) {
            AbstractEJBHome home;
            if (local) {
                AbstractEJBHome home2;
                if (this.lookedUpLocalHomes == null) {
                    this.lookedUpLocalHomes = new HashMap();
                }
                if ((home2 = (AbstractEJBHome)this.lookedUpLocalHomes.get(location)) != null) {
                    return home2;
                }
                try {
                    home2 = this.ejbPackage.getHomeInstance(this.container, location, true, true);
                    if (home2 != null) {
                        this.lookedUpLocalHomes.put(location, home2);
                        return home2;
                    }
                    throw EJBUtils.createEJBException("No such EJBLocalHome: '" + location + "'");
                }
                catch (InstantiationException e) {
                    throw EJBUtils.createEJBException("Unable to resolve EJBHome '" + location + "': " + e.getMessage(), e);
                }
            }
            if (this.lookedUpHomes == null) {
                this.lookedUpHomes = new HashMap();
            }
            if ((home = (AbstractEJBHome)this.lookedUpHomes.get(location)) != null) {
                return home;
            }
            try {
                home = (AbstractEJBHome)this.container.getApplication().getContext().lookup(location);
                this.lookedUpHomes.put(location, home);
                return home;
            }
            catch (NamingException e) {
                return null;
            }
        }
    }

    public boolean isCallerInRole(String roleName, AddressContainer addressContainer) {
        String newName;
        if (this.roleMappings != null && (newName = (String)this.roleMappings.get(roleName)) != null) {
            roleName = newName;
        }
        return this.ejbPackage.isCallerInRole(roleName, addressContainer);
    }

    public EJBPackageDeployment getEJBPackage() {
        return this.ejbPackage;
    }

    public Application getApplication() {
        return this.container.getApplication();
    }

    public ClassLoader getClassLoader() {
        return this.container.getBeansClassLoader();
    }

    public RuntimeSecurityRole OC4J_getCallers(String[] callers) {
        try {
            return this.ejbPackage.getRuntimeRole(callers);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString(), t);
        }
    }

    public String toString() {
        if (this.bindingPath == null) {
            return "Unbound EJBHome";
        }
        return this.bindingPath + " EJBHome";
    }

    public Context getAssemblyContext() {
        return null;
    }

    public void setLockingMode(int mode) {
        this.lockingMode = mode;
    }

    public int getLockingMode() {
        return this.lockingMode;
    }

    public String getApplicationName() {
        return this.container.getApplication().getName();
    }

    public final BeanDescriptor getBeanDescriptor() {
        return this._desc;
    }

    public final void setBeanDescriptor(BeanDescriptor desc) {
        this._desc = desc;
        this.OC4J_setCallManager(this._desc.getCallManager());
    }

    public void OC4J_setCallManager(CallManager cm) {
        this.cm = cm;
    }

    public void setPM(PersistenceManager pm) {
        this.pm = pm;
    }

    public PersistenceManager getPM() {
        return this.pm;
    }

    public String OC4J_getAppName() {
        return this.container.getApplication().getName();
    }

    public String OC4J_getEjbJarName() {
        String s = null;
        try {
            s = this.ejbPackage.getPackage().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public String getBeanName() {
        if (this.getBeanDescriptor() != null) {
            return this.getBeanDescriptor().getName();
        }
        return "Unknown";
    }

    public String getLocation() {
        return ((ExposableBeanDescriptor)this.getBeanDescriptor()).getLocation();
    }

    public String getRemoteClassName() {
        return ((ExposableBeanDescriptor)this.getBeanDescriptor()).getRemoteInterfaceName();
    }

    public String getHomeClassName() {
        return ((ExposableBeanDescriptor)this.getBeanDescriptor()).getRemoteHomeName();
    }

    public EJBHome getHomeReference() {
        if (!$assertionsDisabled && this.m_corbaHomeReference == null) {
            throw new AssertionError((Object)"May not ask for home reference until home has been deployed");
        }
        return this.m_corbaHomeReference;
    }

    public void setHomeReference(EJBHome homeReference) {
        this.m_corbaHomeReference = homeReference;
    }

    public Servant getHomeServant() {
        return this.m_servant;
    }

    public void setHomeServant(Servant homeServant) {
        this.m_servant = homeServant;
    }

    public void registerEjbServant(EJBObjectID objectID, Servant servant) {
        if (this.m_ejbServantMap == null) {
            this.m_ejbServantMap = new HashMap();
        }
        this.m_ejbServantMap.put(objectID, servant);
    }

    public Servant getEjbServant(EJBObjectID id) {
        if (this.m_ejbServantMap == null) {
            return null;
        }
        return (Servant)this.m_ejbServantMap.get(id);
    }

    public void setCorbaReferenceGenerator(CorbaReferenceGenerator corbaReferenceGenerator) {
        this.m_corbaReferenceGenerator = corbaReferenceGenerator;
    }

    public CorbaReferenceGenerator getCorbaReferenceGenerator() {
        return this.m_corbaReferenceGenerator;
    }

    public Set getEjbIORDescriptorSet() {
        return this.getBeanDescriptor() != null ? this.getBeanDescriptor().getIORConfigurationDescriptors() : new OrderedSet();
    }

    public static void waitBeforeTxRetry(long milli_second) {
        try {
            Thread.sleep(milli_second);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static EJBException addCause(EJBException _ee, Throwable _cause) {
        try {
            _ee.initCause(_cause);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return _ee;
    }

    public static RemoteException addCause(RemoteException _re, Throwable _cause) {
        try {
            _re.initCause(_cause);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return _re;
    }

    public TransportManager getTransportManager() {
        return this.m_transportManager != null ? this.m_transportManager : TransportManager.getInstance();
    }

    public void setTransportManager(TransportManager transportManager) {
        this.m_transportManager = transportManager;
    }

    public ObjectInfo createObjectInfo() {
        return new EJBHomeObjectInfo(this.bindingPath);
    }

    protected void __authorizeAndAuthenticateLocal(MethodState methodState, Object[] params, ThreadState thread) {
        if (JaccWrapper.isJaccEnabled()) {
            JACCInterceptor.authorizeLocal(methodState.getMethodPermission(), null, params, null, thread);
        } else {
            SecurityRoleInterceptor.checkRuntimeSecurityRoleLocal(methodState, thread);
        }
    }

    protected void __authorizeAndAuthenticateRemote(MethodState methodState, Object[] params, ThreadState thread) throws RemoteException {
        if (JaccWrapper.isJaccEnabled()) {
            JACCInterceptor.authorizeRemote(methodState.getMethodPermission(), null, params, null, thread);
        } else {
            SecurityRoleInterceptor.checkRuntimeSecurityRole(methodState, thread);
        }
    }

    protected void __throwUncheckedException(Throwable methodException) {
        this.OC4J_handleUncheckedException(methodException);
    }

    protected Object[] __completeGlobalTransaction(boolean isLocal, int maxTxRetries, int txRetries, boolean redoTX, Throwable methodException) {
        try {
            EJBTransactionManager.getInstance().end(isLocal);
        }
        catch (Exception e) {
            methodException = e;
        }
        if (methodException != null && maxTxRetries > 0 && txRetries++ < maxTxRetries && !EJBUtils.isApplicationException(methodException)) {
            redoTX = true;
        }
        Object[] objects = new Object[]{methodException, Integer.valueOf("" + txRetries), redoTX};
        return objects;
    }

    protected Object[] __beginRequiredTransactionManager(ThreadState thread, boolean isLocal, Throwable methodException) {
        boolean created = false;
        try {
            if (ApplicationServer.getInstance().getTransactionManager().getTransaction() == null) {
                try {
                    EJBTransactionManager.getInstance().begin(this.getBeanDescriptor(), isLocal);
                    created = true;
                }
                catch (Exception e) {
                    methodException = e;
                }
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return new Object[]{methodException, created};
    }

    protected Throwable __handleThrowableException(ThreadState thread, Throwable t, boolean booleanTxMsg, boolean isSetMethodException, boolean isLocal, boolean created, boolean ejb30Compatibility, boolean isThrowsRemoteException, Throwable methodException, int txRetries, int maxTxRetries, int txType, boolean iscontainerManagedTx) {
        Throwable tempException = this.__setRollbackTransaction(thread, t, isSetMethodException, isLocal, booleanTxMsg, ejb30Compatibility, isThrowsRemoteException);
        if (isSetMethodException) {
            methodException = tempException;
        }
        this._handleTxnRetryLogicException(t, created, txRetries, maxTxRetries, txType, iscontainerManagedTx);
        return methodException;
    }

    protected Throwable __handleThrowableException(ThreadState thread, Throwable t, boolean booleanTxMsg, boolean isSetMethodException, boolean isLocal, boolean ejb30Compatibility, boolean isThrowsRemoteException, Throwable methodException) {
        Throwable tempException = this.__setRollbackTransaction(thread, t, isSetMethodException, isLocal, booleanTxMsg, ejb30Compatibility, isThrowsRemoteException);
        if (isSetMethodException) {
            methodException = tempException;
        }
        return methodException;
    }

    private void _handleTxnRetryLogicException(Throwable t, boolean created, int txRetries, int maxTxRetries, int txType, boolean iscontainerManagedTx) {
        if (txType == 6 || txType == 1) {
            if (iscontainerManagedTx) {
                if (t instanceof RuntimeException || !created || txRetries == maxTxRetries) {
                    this.__reSetContext(this.context);
                }
            } else if (t instanceof RuntimeException || txRetries == maxTxRetries) {
                this.__reSetContext(this.context);
            }
        }
    }

    protected Throwable __setRollbackTransaction(ThreadState thread, Throwable e, boolean isSetMethodException, boolean isLocal, boolean booleanTxMsg, boolean ejb30Compatibility, boolean isThrowsRemoteException) {
        try {
            if (ApplicationServer.getInstance().getTransactionManager().getTransaction() != null) {
                EJBTransactionManager.getInstance().setContainerRollbackOnly();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        this.OC4J_log(e);
        if (isSetMethodException) {
            return this._getUserTxMethodException(thread, e, booleanTxMsg, isLocal, ejb30Compatibility, isThrowsRemoteException);
        }
        return null;
    }

    protected Exception _getUserTxMethodException(ThreadState thread, Throwable e, boolean boolanTxMsg, boolean isLocal, boolean ejb30Compatibility, boolean isThrowsRemoteException) {
        if (ejb30Compatibility && !isLocal && !isThrowsRemoteException) {
            if (e instanceof EJBException) {
                return (EJBException)e;
            }
            return EJBUtils.createEJBException(EJBUtils.getUserException(e, boolanTxMsg));
        }
        if (isLocal) {
            return EJBUtils.getLocalUserException(e, boolanTxMsg);
        }
        return EJBUtils.getUserException(e, boolanTxMsg);
    }

    protected void __reSetContext(Context context) {
    }

    public void traceLog(String message) {
        Logger m_logger = this.getWrapperLogger();
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, message);
        }
    }

    public Logger getWrapperLogger() {
        return EJBTraceLogger.getLogger(this.getBeanDescriptor().getEJBClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object OC4J_invokeMethod(MethodState state, Object[] params, ThreadState thread) throws Exception {
        ContextContainer previousContainer = thread.contextContainer;
        try {
            thread.contextContainer = this;
            Object object = InvocationContextPool.invoke(thread, state, null, null, params, null, this);
            return object;
        }
        finally {
            thread.contextContainer = previousContainer;
        }
    }

    public void checkRunningState() {
        if (!this.container.isRunning()) {
            throw new ApplicationStoppedException("Application is not in RUNNING state");
        }
    }

    protected void OC4J_startCall(ThreadState thread, boolean firstCallOnStack) {
        if (firstCallOnStack) {
            this.checkRunningState();
            if (this.cm != null) {
                this.cm.beginMethodCall();
            }
        }
    }

    protected void OC4J_endCall(ThreadState thread, boolean firstCallOnStack) {
        if (firstCallOnStack && this.cm != null) {
            this.cm.endMethodCall();
        }
    }

    protected Object OC4J_cloneParameter(Object param) {
        return EJBUtils.cloneLocalObject(param, this);
    }

    protected MethodState OC4J_getMethodState(boolean isLocal, boolean isHome, String signature) {
        return ((ExposableBeanDescriptor)this._desc).getMethodState(isLocal, isHome, signature);
    }

    protected Object OC4J_getTransportSpecificResponse(Object value) {
        return this.getTransportManager().getTransportSpecificResponseObject(value);
    }

    public void OC4J_handleUncheckedException(Throwable throwable) {
        if (throwable instanceof RemoteException) {
            throw EJBUtils.createEJBException((RemoteException)throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    static {
        $assertionsDisabled = !AbstractEJBHome.class.desiredAssertionStatus();
        m_logger = EJBTraceLogger.getLogger(AbstractEJBHome.class);
    }
}

