/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.mail.PresetAuthenticator;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.PropertyContainer;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import oracle.oc4j.admin.management.callbackinterfaces.JavaMailResourceCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MailSessionInfo
extends AbstractDescribable
implements XMLizable,
Serializable,
PropertyContainer,
Cloneable,
JavaMailResourceCallBackIf {
    public static final long serialVersionUID = 4676534322L;
    private String location;
    private String username;
    private String password;
    private Properties properties = new Properties();

    public MailSessionInfo(String location, Properties properties) {
        this.location = location;
        this.properties = properties;
    }

    public MailSessionInfo(Node parent) {
        NodeList list;
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        String smtpHost = XMLUtils.getNodeAttribute(parent, "smtp-host");
        this.username = XMLUtils.getNodeAttribute(parent, "username");
        this.password = XMLUtils.getNodeAttribute(parent, "password");
        if (smtpHost != null) {
            this.properties.setProperty("mail.smtp.host", smtpHost);
        }
        if ((list = parent.getChildNodes()) != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                String propertyName;
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (!name.equals("property") || (propertyName = XMLUtils.getNodeAttribute(node, "name")) == null) continue;
                this.properties.put(propertyName, XMLUtils.getNodeAttribute(node, "value"));
            }
        }
    }

    public String getLocation() {
        return this.location;
    }

    public Session getSession() {
        PresetAuthenticator authenticator = null;
        if (this.username != null) {
            authenticator = new PresetAuthenticator(new PasswordAuthentication(this.username, this.password));
        }
        return Session.getInstance((Properties)this.properties, authenticator);
    }

    public void writeXML(PrintWriter out, String indention) {
        String smtpHost;
        out.print(indention + "<mail-session");
        if (this.location != null) {
            out.print(" location=\"" + XMLUtils.encode(this.location) + "\"");
        }
        if ((smtpHost = this.properties.getProperty("mail.smtp.host")) != null) {
            out.print(" smtp-host=\"" + XMLUtils.encode(smtpHost) + "\"");
        }
        if (this.username != null) {
            out.print(" username=\"" + XMLUtils.encode(this.username) + "\"");
        }
        if (this.password != null) {
            out.print(" password=\"" + XMLUtils.encode(this.password) + "\"");
        }
        out.println(">");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        Iterator<Map.Entry<Object, Object>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (entry.getKey().toString().equals("mail.smtp.host")) continue;
            out.println(indention + "\t<property name=\"" + XMLUtils.encode(entry.getKey().toString()) + "\" value=\"" + XMLUtils.encode(entry.getValue().toString()) + "\" />");
        }
        out.println(indention + "</mail-session>");
    }

    public String toString() {
        if (this.location != null) {
            return this.location;
        }
        return "<unknown mail-session>";
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        Object oldValue = this.properties.setProperty(name, value);
        this.firePropertyChangeEvent("properties", oldValue, value);
    }

    public void remove(String name) {
        if (this.properties.remove(name) != null) {
            this.firePropertyChangeEvent("properties", name, null);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Set getKnownKeys() {
        TreeSet<String> keys = new TreeSet<String>();
        keys.add("mail.from");
        keys.add("mail.transport.protocol");
        keys.add("mail.smtp.from");
        keys.add("mail.smtp.host");
        return keys;
    }

    public Object clone() {
        try {
            MailSessionInfo other = (MailSessionInfo)super.clone();
            if (this.properties != null) {
                other.properties = new Properties();
                other.properties.putAll((Map<?, ?>)this.properties);
            }
            return other;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getXMLDescriptor() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bout);
        this.writeXML(pw, "");
        pw.flush();
        return bout.toString();
    }
}

