/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JMXMBeanDescriptor
extends AbstractDescribable
implements XMLizable {
    private String className_;
    private AttributeList attributes_ = new AttributeList();

    public JMXMBeanDescriptor() {
    }

    public JMXMBeanDescriptor(Node parent) throws InstantiationException {
        this.setName(XMLUtils.getNodeAttribute(parent, "objectname"));
        this.className_ = XMLUtils.getNodeAttribute(parent, "class");
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("attribute")) {
                    String attrName = XMLUtils.getNodeAttribute(node, "name");
                    if (attrName != null) {
                        NodeList listOfValues = node.getChildNodes();
                        if (listOfValues != null) {
                            ArrayList<String> attrValueList = new ArrayList<String>();
                            for (int j = 0; j < listOfValues.getLength(); ++j) {
                                Node valueNode = listOfValues.item(j);
                                String valueNodeName = valueNode.getNodeName();
                                if (!valueNodeName.equals("value")) continue;
                                String attrValue = XMLUtils.getStringValue(valueNode);
                                attrValueList.add(attrValue);
                            }
                            Attribute attr = new Attribute(attrName, attrValueList);
                            this.attributes_.add(attr);
                            continue;
                        }
                        throw new InstantiationException("Invalid property subtag attribute for jmx-mbean tag: missing attribute values");
                    }
                    throw new InstantiationException("Invalid property subtag attribute for jmx-mbean tag: missing attribute name");
                }
                throw new InstantiationException("Unknown property subtag: " + name + " for jmx-mbean tag");
            }
        }
    }

    public final String getObjectName() {
        return super.getName();
    }

    public final String getClassName() {
        return this.className_;
    }

    public final AttributeList getAttributes() {
        return this.attributes_;
    }

    public final void writeXML(PrintWriter out, String indentation) throws IOException {
        out.print(indentation + "<jmx-mbean");
        if (this.getObjectName() != null) {
            out.print(" objectname=\"" + XMLUtils.encode(this.getObjectName()) + "\"");
        }
        out.print(" class=\"" + XMLUtils.encode(this.getClassName()) + "\"");
        out.println(">");
        if (this.getDescription() != null) {
            out.println(indentation + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.attributes_ != null) {
            Object[] attrArray = this.attributes_.toArray();
            for (int i = 0; i < attrArray.length; ++i) {
                Attribute attr = (Attribute)attrArray[i];
                String attrName = attr.getName();
                ArrayList attrValue = (ArrayList)attr.getValue();
                out.println(indentation + "\t<attribute name=\"" + XMLUtils.encode(attrName) + "\">");
                if (attrValue != null) {
                    for (int j = 0; j < attrValue.size(); ++j) {
                        out.println(indentation + "\t<value>" + XMLUtils.encode(attrValue.get(j).toString()) + "</value>");
                    }
                }
                out.println(indentation + "\t</attribute>");
            }
        }
        out.println(indentation + "</jmx-mbean>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<jmx-mbean");
        if (this.getObjectName() != null) {
            buf.append(" objectname=\"" + XMLUtils.encode(this.getObjectName()) + "\"");
        }
        buf.append(" class=\"" + XMLUtils.encode(this.getClassName()) + "\"");
        buf.append(">\n");
        if (this.getDescription() != null) {
            buf.append("\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>\n");
        }
        if (this.attributes_ != null) {
            Object[] attrArray = this.attributes_.toArray();
            for (int i = 0; i < attrArray.length; ++i) {
                Attribute attr = (Attribute)attrArray[i];
                String attrName = attr.getName();
                ArrayList attrValue = (ArrayList)attr.getValue();
                buf.append("\t<attribute name=\"" + XMLUtils.encode(attrName) + "\">\n");
                if (attrValue != null) {
                    for (int j = 0; j < attrValue.size(); ++j) {
                        buf.append("\t\t<value>" + XMLUtils.encode(attrValue.get(j).toString()) + "</value>\n");
                    }
                }
                buf.append("\t</attribute>\n");
            }
        }
        buf.append("</jmx-mbean>\n\n");
        return buf.toString();
    }
}

