/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DestinationReference
extends ResourceEnvironmentReference
implements XMLizable,
Serializable {
    protected String usage;
    protected String link;

    public DestinationReference() {
    }

    public DestinationReference(String name, String type, String usage, String link) throws InstantiationException {
        super(name, type);
        this.usage = usage;
        this.link = link;
    }

    public DestinationReference(Node parent) throws InstantiationException {
        this.parseXML(parent);
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName)) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("message-destination-ref-name")) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals("message-destination-type")) {
                    this.setType(value);
                    continue;
                }
                if (nodeName.equals("message-destination-usage")) {
                    this.usage = value;
                    continue;
                }
                if (nodeName.equals("message-destination-link")) {
                    this.link = value;
                    continue;
                }
                if (nodeName.equals("mapped-name") && value.length() > 0) {
                    this.setLocation(value);
                    continue;
                }
                if (this.parseInjectionTarget(node)) continue;
                throw new InstantiationException("Unknown message-destination-ref tag: " + nodeName);
            }
        }
        if (this.getName() == null) {
            throw new InstantiationException("message-destination-ref tag with missing message-destination-ref-name subtag");
        }
        if (this.getType() == null) {
            throw new InstantiationException("message-destination-ref tag with missing message-destination-type subtag");
        }
        if (this.usage == null) {
            throw new InstantiationException("message-destination-ref tag with missing message-destination-usage subtag");
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getLink() {
        return this.link;
    }

    public void setLocation(String location) {
        this.location = location;
        this.firePropertyChangeEvent("location", this.location, location);
    }

    public void setUsage(String usage) {
        this.usage = usage;
        this.firePropertyChangeEvent("usage", this.usage, usage);
    }

    public void setLink(String link) {
        this.link = link;
        this.firePropertyChangeEvent("link", this.link, link);
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<message-destination-ref>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<message-destination-ref-name>" + XMLUtils.encode(this.getName()) + "</message-destination-ref-name>");
        } else {
            out.println(indention + "\t<message-destination-ref-name>unnamed</message-destination-ref-name>");
        }
        if (this.getType() != null) {
            out.println(indention + "\t<message-destination-type>" + XMLUtils.encode(this.getType()) + "</message-destination-type>");
        } else {
            out.println(indention + "\t<message-destination-type>javax.sql.DataSource</message-destination-type>");
        }
        if (this.usage != null) {
            out.println(indention + "\t<message-destination-usage>" + XMLUtils.encode(this.usage) + "</message-destination-usage>");
        }
        if (this.link != null) {
            out.println(indention + "\t<message-destination-link>" + XMLUtils.encode(this.link) + "</message-destination-link>");
        }
        this.writeMappedName(out, indention + "\t", this.location);
        this.writeInjectableXML(out, indention + "\t");
        out.println(indention + "</message-destination-ref>");
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        this.location = XMLUtils.getNodeAttribute(parent, "location");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.print(indention + "<message-destination-ref-mapping name=\"" + XMLUtils.encode(this.getName()) + "\"");
        if (this.location != null) {
            out.print(" location=\"" + XMLUtils.encode(this.location) + "\"");
        }
        out.println(" />");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("message-destination-ref      : ");
        buf.append("\n");
        buf.append("  name      : ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  type      : ");
        buf.append(this.getType());
        buf.append("\n");
        buf.append("  usage      : ");
        buf.append(this.getUsage());
        buf.append("\n");
        buf.append("  link      : ");
        buf.append(this.getLink());
        buf.append("\n");
        return buf.toString();
    }
}

