/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.Module;
import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientModule
extends Module {
    protected String name;
    private long deploymentTime = -1L;
    private String[] args;
    private boolean autoStart;
    private String username;
    protected String unpackedPath;

    public ClientModule(String path) {
        super(path);
    }

    public ClientModule(Node parent) throws InstantiationException {
        super(parent);
        NodeList list;
        this.path = this.checkPath(XMLUtils.getSubnodeValue(parent, "java"));
        this.autoStart = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "auto-start"));
        this.username = XMLUtils.getNodeAttribute(parent, "user");
        this.name = XMLUtils.getNodeAttribute(parent, "id");
        if (this.path == null) {
            this.path = XMLUtils.getNodeAttribute(parent, "path");
        }
        if (this.path == null) {
            if (parent.getNodeName().equals("module")) {
                throw new InstantiationException("Missing <java> tag in <module> tag");
            }
            throw new InstantiationException("Missing path tag in <client-module> tag");
        }
        String time = XMLUtils.getNodeAttribute(parent, "deployment-time");
        if (time != null) {
            try {
                this.deploymentTime = Long.parseLong(time, 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((list = parent.getChildNodes()) != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("arguments")) {
                    this.parseArguments(node);
                    continue;
                }
                if (name.equals("java") || name.equals("alt-dd")) continue;
                throw new InstantiationException("Unknown client-module subtag: " + name);
            }
        }
    }

    public void parseArguments(Node parent) throws InstantiationException {
        ArrayList<String> arguments = new ArrayList<String>();
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("argument")) {
                    String value = XMLUtils.getNodeAttribute(node, "value");
                    if (value == null) {
                        throw new InstantiationException("argument node with no specified value attribute in client-module");
                    }
                    arguments.add(value);
                    continue;
                }
                throw new InstantiationException("Unknown arguments subnode: " + name);
            }
        }
        this.args = arguments.toArray(new String[arguments.size()]);
    }

    public String getPath() {
        if (this.unpackedPath != null) {
            return this.unpackedPath;
        }
        return super.getPath();
    }

    public void setUnpackedPath(String path) {
        this.unpackedPath = path;
    }

    public String getName() {
        if (this.name == null) {
            String name = this.getPath();
            if (name.endsWith(".jar")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            return name;
        }
        return this.name;
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.print(indention + this.toString());
    }

    public String toString() {
        String msg = "<client-module";
        if (this.name != null) {
            msg = msg + " id=\"" + XMLUtils.encode(this.name) + "\"";
        }
        msg = msg + " path=\"" + this.getPath() + "\" deployment-time=\"" + Long.toHexString(this.deploymentTime) + "\" auto-start=\"" + this.getAutoStart() + "\"";
        if (this.username != null) {
            msg = msg + " user=\"" + XMLUtils.encode(this.username) + "\"";
        }
        if (this.args != null) {
            msg = msg + ">";
            msg = msg + "\t<arguments>";
            for (int i = 0; i < this.args.length; ++i) {
                msg = msg + "\t\t<argument value=\"" + XMLUtils.encode(this.args[i]) + "\" />";
            }
            msg = msg + "\t</arguments>";
            msg = msg + "</client-module>";
        } else {
            msg = msg + " />";
        }
        return msg;
    }

    public long getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(long time) {
        this.deploymentTime = time;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<module>");
        out.println(indention + "\t<java>" + XMLUtils.encode(this.path) + "</java>");
        if (this.getAltDD() != null) {
            out.println(indention + "\t<alt-dd>" + this.getAltDD() + "</alt-dd>");
        }
        out.println(indention + "</module>");
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public String[] getArguments() {
        if (this.args == null) {
            return new String[0];
        }
        return this.args;
    }

    public String getUsername() {
        return this.username;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setArguments(String[] arguments) {
        this.args = arguments;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ClientModule)) {
            return false;
        }
        String mypath = this.getTrimmedPath(this.path);
        String otherpath = this.getTrimmedPath(((ClientModule)other).getPath());
        return mypath.equals(otherpath);
    }

    public int hashCode() {
        if (this.path == null) {
            return -1;
        }
        return this.getTrimmedPath(this.path).hashCode();
    }

    private String getTrimmedPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".jar")) {
            return path.substring(0, path.length() - 4);
        }
        return path;
    }
}

