/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.compiler.CompilationException;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.server.Application;
import com.evermind.server.administration.ApplicationResourceFinder;
import com.evermind.server.administration.ResourceFinder;
import com.evermind.server.deployment.ApplicationClientArchive;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.http.compilation.Compilation;
import com.evermind.util.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.naming.ApplicationClientInitialContextFactory;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptor;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptorHolder;
import oracle.oc4j.admin.management.callbackinterfaces.AppClientModuleCallBackIf;
import oracle.oc4j.transport.TransportManager;
import oracle.oc4j.util.FileUtils;

public class ApplicationClientServerArchive
extends ApplicationClientArchive
implements AppClientModuleCallBackIf,
WebServicesDescriptorHolder {
    public ApplicationClientServerArchive(String name) {
        super(name);
    }

    public ApplicationClientServerArchive(String name, Context context) {
        super(name, context);
    }

    public WebServicesDescriptor getWebServicesDescriptor() {
        return null;
    }

    public void deploy(Application application, Context targetContextParent, String targetContextName) throws IOException, InstantiationException {
        ApplicationResourceFinder finder = new ApplicationResourceFinder(application);
        Context targetContext = this.getTargetContext(targetContextParent, targetContextName);
        this.setResourceLocations(finder, this.getResourceReferences());
        this.setResourceLocations(finder, this.getResourceEnvironmentReferences());
        this.setResourceLocations(finder, this.getDestinationReferences());
        this.setEjbLocations(finder, this.getEJBReferences());
        try {
            targetContext.lookup("jndi.properties");
        }
        catch (NamingException e) {
            Properties properties = ApplicationClientServerArchive.createJndiProperties(application.getTransportManager(), application.getName());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            properties.store(byteOut, "OC4J JNDI properties");
            try {
                targetContext.rebind("jndi.properties", (Object)byteOut.toByteArray());
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        try {
            ByteArrayOutputStream byteOut;
            if (this.getAltDD() != null) {
                byteOut = new ByteArrayOutputStream();
                this.writeConfig(new PrintWriter(byteOut, true));
                targetContext.rebind(this.getAssemblyDescriptorPath(), (Object)byteOut.toByteArray());
            }
            byteOut = new ByteArrayOutputStream();
            this.writeOrionConfig(new PrintWriter(byteOut, true));
            targetContext.rebind("META-INF/orion-application-client.xml", (Object)byteOut.toByteArray());
            ContextUtils.flush(targetContext);
        }
        catch (NamingException e) {
            throw new InstantiationException("Error updating configuration files: " + e.getMessage());
        }
    }

    private void setEjbLocations(ApplicationResourceFinder finder, List ejbReferences) throws InstantiationException {
        for (int i = 0; i < ejbReferences.size(); ++i) {
            EJBReference reference = (EJBReference)ejbReferences.get(i);
            if (reference.getLocation() != null) continue;
            reference.setLocation(finder.getLocation(reference));
        }
    }

    private void setResourceLocations(ResourceFinder finder, List ResourceReferences) throws RemoteException, InstantiationException {
        for (int i = 0; i < ResourceReferences.size(); ++i) {
            ResourceEnvironmentReference reference = (ResourceEnvironmentReference)ResourceReferences.get(i);
            if (reference.getLocation() != null) continue;
            reference.setLocation(finder.getLocation(reference.getName(), reference.getType()));
        }
    }

    private Context getTargetContext(Context targetContextParent, String targetContextName) throws IOException, InstantiationException {
        Context targetContext = null;
        if (targetContextParent != null && this.getContext() instanceof MemoryArchiveContext) {
            try {
                ByteString content = ((MemoryArchiveContext)this.getContext()).getData();
                targetContext = new MemoryArchiveContext(targetContextParent, targetContextName, content.data, content.offset, content.length, false);
            }
            catch (NamingException e) {
                throw new InstantiationException("Error loading application-client archive " + this + ": " + e.getMessage());
            }
        }
        if (targetContext == null) {
            targetContext = this.getContext();
        }
        return targetContext;
    }

    public void doServiceRefCodeGeneration(Application application) throws InstantiationException {
        if (this.getServiceReferences().isEmpty()) {
            return;
        }
        try {
            Compilation compilation = new Compilation(application, this);
            compilation.compileServiceRefs();
        }
        catch (CompilationException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    static Properties createJndiProperties(TransportManager transportManager, String applicationName) {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", ApplicationClientInitialContextFactory.class.getName());
        properties.put("java.naming.provider.url", transportManager.getProviderUrl(applicationName));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws InstantiationException {
        try {
            URL url = FileUtils.autoUnpack(this.getArchiveURL() == null ? this.getURL() : this.getArchiveURL(), this.autoUnpack, this.logger);
            this.setURL(url);
            this.init();
            if (this.getContext() != null) {
                this.initDeployment();
            }
        }
        finally {
            this.initLastModifieds();
        }
    }
}

