/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationMechanism
implements XMLizable {
    private String description;
    private String type;
    private String credentialInterface;

    public AuthenticationMechanism() {
    }

    public AuthenticationMechanism(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("description")) {
                    this.description = XMLUtils.getStringValue(node);
                    continue;
                }
                if (name.equals("authentication-mechanism-type")) {
                    this.type = XMLUtils.getStringValue(node);
                    continue;
                }
                if (name.equals("credential-interface")) {
                    this.credentialInterface = XMLUtils.getStringValue(node);
                    continue;
                }
                throw new InstantiationException("authentication-mechanism with unknown subtag: " + name);
            }
        }
        if (this.type == null) {
            throw new InstantiationException("Missing 'authetication-mechanism-type' subtag in authentication-mechanism tag");
        }
        if (this.credentialInterface == null) {
            throw new InstantiationException("Missing 'credential-interface' subtag in authentication-mechanism tag");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthenticationMechanismType() {
        return this.type;
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<authentication-mechanism>");
        if (this.description != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.type != null) {
            out.println(indention + "\t<authentication-mechanism-type>" + XMLUtils.encode(this.type) + "</authentication-mechanism-type>");
        }
        if (this.credentialInterface != null) {
            out.println(indention + "\t<credential-interface>" + XMLUtils.encode(this.credentialInterface) + "</credential-interface>");
        }
        out.println(indention + "</authentication-mechanism>");
    }
}

