/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.ConnectionHandleContext;
import com.evermind.server.connector.ConnectionSharingPool;
import com.evermind.server.connector.ContainerAuthenticationData;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorNotification;
import oracle.dms.instrument.EventIntf;
import oracle.j2ee.connector.ConnectionPool;
import oracle.j2ee.connector.InternalConnectorException;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.logging.JCATransactionMessages;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.transaction.EmulatedXAResource;
import oracle.j2ee.connector.transaction.XAResourceWrapper;

public class ConnectionContext
implements Synchronization,
ProtocolErrorNotification,
ConnectionEventListener {
    private static Logger m_logger = JCATraceLogger.getLogger(ConnectionContext.class);
    private ManagedConnection m_managedConnection;
    private ConnectionRequestInfo m_cxRequestInfo;
    private ApplicationConnectionManager m_connectionManager;
    private Transaction m_xaTransaction;
    private EmulatedXAResource m_emulatedXaResource;
    private boolean m_transactionEnded;
    private Map m_connectionHandles;
    private ContainerAuthenticationData m_containerAuthenticationData;
    private boolean m_errorOccurred;
    private boolean m_cleanedUp;
    private int m_creatingHandlesCount;
    int m_suspendedAction;
    private boolean m_shareable;
    private boolean m_inLocalTx = false;
    private boolean m_discard = false;
    private boolean m_supportsFastSuspend = true;
    private boolean m_active = false;
    static final int NO_ACTION = 0;
    static final int CLOSECONNECTION_ACTION = 1;
    static final int CLEANUP_ACTION = 2;

    public Transaction getXaTransaction() {
        return this.m_xaTransaction;
    }

    public ManagedConnection getManagedConnection() {
        return this.m_managedConnection;
    }

    ConnectionContext(ManagedConnection mc, boolean shareable) throws ResourceException {
        if (mc == null) {
            throw new ResourceException("MC cannot be null!");
        }
        this.m_managedConnection = mc;
        this.m_shareable = shareable;
        this.m_errorOccurred = false;
        this.m_cleanedUp = false;
        this.init();
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",mc=" + mc + ",shareable=" + shareable);
        }
    }

    private void init() {
        this.m_containerAuthenticationData = null;
        this.m_cxRequestInfo = null;
        this.setXaTransaction(null);
        if (this.m_emulatedXaResource != null) {
            this.m_emulatedXaResource.reset();
        }
        this.m_transactionEnded = false;
        this.m_connectionHandles = new WeakHashMap();
        this.m_connectionManager = null;
        this.m_discard = false;
    }

    public synchronized void setup(ContainerAuthenticationData containerAuthenticationData, ConnectionRequestInfo cxRequestInfo, ApplicationConnectionManager connectionManager) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",m_errorOccurred=" + this.m_errorOccurred);
        }
        if (this.m_errorOccurred) {
            return;
        }
        this.m_containerAuthenticationData = containerAuthenticationData;
        this.m_cxRequestInfo = cxRequestInfo;
        this.m_connectionManager = connectionManager;
        this.m_cleanedUp = false;
    }

    public void setupForTransaction() throws ResourceException {
        int transactionSupport;
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        if ((transactionSupport = this.m_connectionManager.getTransactionSupport()) != 1 && ApplicationConnectionManager.isInApplicationServer()) {
            this.setupForTransaction(transactionSupport);
        }
    }

    void setupForTransaction(int transactionSupport) throws ResourceException {
        Transaction globalTxn;
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",transactionSupport=" + transactionSupport);
        }
        if ((globalTxn = this.m_connectionManager.getTransaction()) != null) {
            if (transactionSupport == 3) {
                this.setupForJTATransaction(globalTxn, false);
            } else if (transactionSupport == 2) {
                this.setupForJTATransaction(globalTxn, true);
            }
            if (this.m_shareable) {
                this.m_connectionManager.addToShareablePool(globalTxn, this);
            } else {
                this.m_connectionManager.addToUnshareablePool(globalTxn, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupForJTATransaction(Transaction globalTxn, boolean emulated) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",globalTxn=" + globalTxn + ",emulated=" + emulated);
        }
        if (globalTxn == null) {
            this.setXaTransaction(null);
            return;
        }
        if (this.isEnlistedInTransaction(globalTxn)) {
            return;
        }
        if (this.m_inLocalTx) {
            throw new ResourceException("Can't enlist resource which is already involved in a local transaction");
        }
        XAResource resource = null;
        if (!emulated) {
            resource = this.m_managedConnection.getXAResource();
            if (resource == null) {
                throw new ResourceException("Unable to obtain an XAResource from the resource adapter");
            }
        } else {
            if (this.m_emulatedXaResource == null) {
                this.m_emulatedXaResource = new EmulatedXAResource(this.m_managedConnection);
            }
            if ((resource = this.m_emulatedXaResource) == null) {
                throw new ResourceException("Unable to obtain a LocalTransaction from the resource adapter");
            }
        }
        String oc4jUserInfo = null;
        if (this.m_containerAuthenticationData != null) {
            oc4jUserInfo = this.m_containerAuthenticationData.getOc4jUserInfo();
        }
        XAResourceWrapper wrapperXAResource = new XAResourceWrapper(resource, this.m_connectionManager.getRmFactoryJndiLocation(), oc4jUserInfo, this.m_supportsFastSuspend);
        try {
            this.m_transactionEnded = false;
            globalTxn.registerSynchronization((Synchronization)this);
            try {
                globalTxn.enlistResource((XAResource)wrapperXAResource);
                ((ApplicationServerTransaction)globalTxn).registerProtocolErrorNotification(this);
            }
            finally {
                this.setXaTransaction(globalTxn);
            }
        }
        catch (RollbackException e) {
            throw new ResourceException("RollbackException: " + e.getMessage());
        }
        catch (SystemException e) {
            throw new ResourceException("SystemException: " + e.getMessage());
        }
    }

    protected void setXaTransaction(Transaction globalTxn) {
        this.m_xaTransaction = globalTxn;
    }

    public boolean isEnlistedInTransaction(Transaction globalTxn) {
        return this.m_xaTransaction != null && this.m_xaTransaction == globalTxn;
    }

    public boolean isLazyEnlistable() {
        return this.m_managedConnection instanceof LazyEnlistableManagedConnection;
    }

    boolean isCreatingHandle() {
        return this.m_creatingHandlesCount > 0;
    }

    synchronized void preAddConnectionHandle() {
        ++this.m_creatingHandlesCount;
    }

    synchronized void addConnectionHandle(Object connectionHandle, AbstractProxy proxy, Throwable creationStacktrace) {
        --this.m_creatingHandlesCount;
        if (connectionHandle == null) {
            if (!this.isCreatingHandle() && this.getNumConnectionHandles() == 0) {
                if (this.m_suspendedAction == 1) {
                    this.closeConnection();
                } else if (this.m_suspendedAction == 2) {
                    this.cleanup();
                }
                this.m_suspendedAction = 0;
            }
        } else {
            this.m_suspendedAction = 0;
            this.useConnectionHandle(connectionHandle, proxy, creationStacktrace);
        }
    }

    private void useConnectionHandle(Object connectionHandle, AbstractProxy proxy, Throwable creationStacktrace) {
        long useTimeToken = 0L;
        if (ApplicationServer.DMS_GATE && this.m_connectionManager != null) {
            if (this.m_connectionManager.getUseTimeEvent() != null) {
                useTimeToken = this.m_connectionManager.getUseTimeEvent().start();
            }
            if (this.m_connectionManager.getSharedPoolUseTimeEvent() != null) {
                this.m_connectionManager.getSharedPoolUseTimeEvent().start(useTimeToken);
            }
        }
        ConnectionHandleContext handleContext = new ConnectionHandleContext(useTimeToken, creationStacktrace, this.m_connectionManager, proxy);
        this.m_connectionHandles.put(connectionHandle, handleContext);
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + "this=" + this + ",handleCount=" + this.getNumConnectionHandles());
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(baos));
            m_logger.finest(baos.toString());
        }
    }

    ConnectionHandleContext removeConnectionHandle(Object connectionHandle, boolean closed) {
        ConnectionHandleContext handleContext = null;
        handleContext = (ConnectionHandleContext)this.m_connectionHandles.remove(connectionHandle);
        if (handleContext != null) {
            if (closed) {
                handleContext.closed();
            }
            handleContext.removed();
            if (ApplicationServer.DMS_GATE && this.m_connectionManager != null) {
                long token = handleContext.getUseTimeToken();
                if (this.m_connectionManager.getUseTimeEvent() != null) {
                    this.m_connectionManager.getUseTimeEvent().stop(token);
                }
                if (this.m_connectionManager.getSharedPoolUseTimeEvent() != null) {
                    this.m_connectionManager.getSharedPoolUseTimeEvent().stop(token);
                }
            }
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",handleCount=" + this.getNumConnectionHandles());
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(baos));
            m_logger.finest(baos.toString());
        }
        return handleContext;
    }

    int getNumConnectionHandles() {
        return this.m_connectionHandles.size();
    }

    Object getUnshareableConnectionHandle() {
        try {
            return this.m_connectionHandles.keySet().iterator().next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    synchronized boolean hasErrorOccurred() {
        return this.m_errorOccurred;
    }

    synchronized boolean hasCleanupOccurred() {
        return this.m_cleanedUp;
    }

    public void protocolErrorOccurred() {
        this.jtaTransactionEnded(true);
    }

    public void afterCompletion(int status) {
        this.jtaTransactionEnded(false);
    }

    public void beforeCompletion() {
    }

    public void localTransactionStarted(ConnectionEvent event) {
        this.m_inLocalTx = true;
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        this.m_inLocalTx = false;
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        this.m_inLocalTx = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionErrorOccurred(ConnectionEvent event) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "]");
        }
        ConnectionContext connectionContext = this;
        synchronized (connectionContext) {
            this.m_errorOccurred = true;
            if (this.m_connectionManager == null) {
                return;
            }
            this.m_connectionManager.removeConnectionContext(this.m_managedConnection);
            ConnectionSharingPool pool = this.m_connectionManager.getShareablePool();
            if (pool != null) {
                pool.remove(this);
            }
        }
        this.m_connectionManager.logThrowable("connectionErrorOccurred", event.getException());
        LoginContext loginContext = null;
        if (this.m_containerAuthenticationData != null) {
            loginContext = this.m_containerAuthenticationData.getLoginContext();
        }
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException e) {
                // empty catch block
            }
        }
        this.m_inLocalTx = false;
        try {
            this.m_managedConnection.destroy();
        }
        catch (ResourceException e) {
            this.m_connectionManager.logThrowable("Error while destroying resource adapter.", e);
        }
        this.m_emulatedXaResource = null;
        ConnectionPool connectionPool = this.m_connectionManager.getConnectionPool();
        connectionPool.connectionErrorOccurred(this.m_managedConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent event) {
        EventIntf dmsEvent;
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",m_connectionManaged=" + this.m_connectionManager);
        }
        if (this.m_connectionManager == null) {
            return;
        }
        Object connectionHandle = event.getConnectionHandle();
        if (ApplicationServer.DMS_GATE && (dmsEvent = this.m_connectionManager.getCloseCountEvent()) != null) {
            dmsEvent.occurred();
        }
        ConnectionContext connectionContext = this;
        synchronized (connectionContext) {
            this.removeConnectionHandle(connectionHandle, true);
            if (this.getNumConnectionHandles() == 0) {
                if (this.isCreatingHandle()) {
                    this.m_suspendedAction = 1;
                } else {
                    this.closeConnection();
                }
            }
        }
    }

    public void setDiscardFlag(boolean flag) {
        this.m_discard = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void jtaTransactionEnded(boolean isProtocolError) {
        block10: {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this + ",isProtocolError=" + isProtocolError);
            }
            this.m_transactionEnded = true;
            try {
                if (this.m_xaTransaction != null) {
                    ConnectionSharingPool pool = this.m_connectionManager.getShareablePool();
                    if (pool != null) {
                        pool.transactionEnded(this.m_xaTransaction);
                    }
                    this.m_connectionManager.removeFromUnshareablePool(this.m_xaTransaction);
                }
                if (this.isShared()) {
                    this.dissociateAllHandles();
                }
                Object var4_3 = null;
                if (!isProtocolError) break block10;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!isProtocolError) {
                    this.cleanupIfUnreferenced();
                    throw throwable;
                }
                try {
                    this.m_managedConnection.cleanup();
                    this.m_managedConnection.destroy();
                    throw throwable;
                }
                catch (ResourceException resourceException) {
                    JCATransactionMessages.warningResourceExceptionFromProtocolErrorNotification(resourceException);
                    throw throwable;
                }
            }
            try {}
            catch (ResourceException resourceException) {
                JCATransactionMessages.warningResourceExceptionFromProtocolErrorNotification(resourceException);
                return;
            }
            this.m_managedConnection.cleanup();
            this.m_managedConnection.destroy();
            return;
        }
        this.cleanupIfUnreferenced();
    }

    private synchronized void dissociateAllHandles() {
        ManagedConnection mc;
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        if ((mc = this.getManagedConnection()) instanceof DissociatableManagedConnection) {
            try {
                ((DissociatableManagedConnection)mc).dissociateConnections();
                Object[] connectionHandles = new Object[this.m_connectionHandles.size()];
                int numConnections = 0;
                Iterator iterator = this.m_connectionHandles.keySet().iterator();
                while (iterator.hasNext()) {
                    connectionHandles[numConnections] = iterator.next();
                    ++numConnections;
                }
                for (int connectionNum = 0; connectionNum < numConnections; ++connectionNum) {
                    ConnectionHandleContext ctx = (ConnectionHandleContext)this.m_connectionHandles.get(connectionHandles[connectionNum]);
                    if (ctx != null) {
                        this.m_connectionManager.addDisassociatedHandleContext(connectionHandles[connectionNum], ctx);
                    }
                    this.removeConnectionHandle(connectionHandles[connectionNum], false);
                }
            }
            catch (ResourceException e) {
                throw new InternalConnectorException(e.toString(), e);
            }
        }
    }

    public boolean isInLocalTx() {
        return this.m_inLocalTx;
    }

    public synchronized ConnectionHandleContext endAssociation(Object handle) throws ResourceException {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        if (this.m_connectionHandles.containsKey(handle)) {
            ConnectionHandleContext handleContext = this.removeConnectionHandle(handle, false);
            boolean inLocalTx = this.m_inLocalTx;
            boolean connectionCleaned = this.cleanupIfUnreferenced();
            if (inLocalTx && connectionCleaned) {
                throw new ResourceException("Uncompleted local transaction detected.");
            }
            return handleContext;
        }
        return null;
    }

    public synchronized boolean isAssociated(Object handle) {
        return this.m_connectionHandles.containsKey(handle);
    }

    public synchronized boolean isShared() {
        return this.m_connectionHandles.size() > 1;
    }

    public synchronized void beginAssociation(Object handle, AbstractProxy proxy, Throwable creationStacktrace) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        this.useConnectionHandle(handle, proxy, creationStacktrace);
    }

    private synchronized boolean cleanupIfUnreferenced() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        if (this.getNumConnectionHandles() == 0 && !this.isAssociatedWithTransaction()) {
            if (this.isCreatingHandle()) {
                if (this.m_suspendedAction != 1) {
                    this.m_suspendedAction = 2;
                }
            } else {
                this.cleanup();
                return true;
            }
        }
        return false;
    }

    public boolean isAssociatedWithTransaction() {
        return this.m_xaTransaction != null && !this.m_transactionEnded;
    }

    synchronized void closeConnection() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        this.m_inLocalTx = false;
        LoginContext loginContext = null;
        if (this.m_containerAuthenticationData != null) {
            loginContext = this.m_containerAuthenticationData.getLoginContext();
        }
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        if (!this.isAssociatedWithTransaction()) {
            this.cleanup();
        }
    }

    private synchronized void cleanup() {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.finer("Thr[" + ThreadState.getCurrentState().toString() + "] " + " this=" + this);
        }
        if (this.m_cleanedUp) {
            return;
        }
        this.m_cleanedUp = true;
        try {
            this.m_managedConnection.cleanup();
            this.m_managedConnection.setLogWriter(null);
        }
        catch (ResourceException e) {
            this.m_connectionManager.logThrowable("Error in resource adapter cleanup.", e);
        }
        ConnectionSharingPool pool = this.m_connectionManager.getShareablePool();
        if (pool != null) {
            pool.remove(this);
        }
        this.m_connectionManager.removeConnectionContext(this.m_managedConnection);
        ConnectionPool connectionPool = this.m_connectionManager.getConnectionPool();
        connectionPool.connectionClosed(this.m_connectionManager, this.m_managedConnection, this.m_discard);
        this.init();
    }

    boolean matchCredentials(Subject subject, ConnectionRequestInfo cxRequestInfo) {
        Subject mySubject = null;
        if (this.m_containerAuthenticationData != null) {
            mySubject = this.m_containerAuthenticationData.getSubject();
        }
        if (mySubject != null ? !mySubject.equals(subject) : subject != null) {
            return false;
        }
        return !(this.m_cxRequestInfo != null ? !this.m_cxRequestInfo.equals(cxRequestInfo) : cxRequestInfo != null);
    }

    public void setSupportsFastSuspend(boolean supportsFastSuspend) {
        this.m_supportsFastSuspend = supportsFastSuspend;
    }

    void setConatinerAuthenticationData(ContainerAuthenticationData caData) {
        this.m_containerAuthenticationData = caData;
    }

    public ApplicationConnectionManager getConnectionManager() {
        return this.m_connectionManager;
    }

    void setConnectionManager(ApplicationConnectionManager connectionManager) {
        this.m_connectionManager = connectionManager;
    }

    protected boolean isActive() {
        return this.m_active;
    }

    protected void setActive(boolean active) {
        this.m_active = active;
    }
}

