/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.net.AddressContainer;
import com.evermind.security.SecuritySensitive;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ExecutionContext;
import com.evermind.server.RoleUser;
import com.evermind.server.ServerApplicationClientLauncherImpl;
import com.evermind.server.ThreadResetHandler;
import com.evermind.server.UserSubjectBridge;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.ejb.EJBThreadContext;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.util.ServerProperties;
import com.oracle.server.Invocation;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSession;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.ServerSecurityServices;
import oracle.oc4j.security.acc.JaccWrapper;
import oracle.oc4j.transport.TransportManager;
import oracle.security.jazn.oc4j.JAZNUserManager;

public class ThreadState
extends CommonThreadState {
    private static final ClassLoader MAIN_LOADER = ThreadState.class.getClassLoader();
    private static int currentID = 1;
    public int id = currentID++;
    public ApplicationServerThread applicationThread;
    private User authenticatingUser;
    public User runAsUser;
    private Subject m_cachedRunningSubject;
    public boolean shieldedUser = false;
    public ContextContainer contextContainer;
    public ThreadState waitingState;
    public ThreadState waitingForState;
    public Object waitingForResource;
    public boolean notified;
    public String interruptMessage;
    public Map attributes;
    public ThreadState nextWaiter;
    public boolean justNotified;
    private boolean firstEJBOnStack = true;
    public EJBThreadContext ejbTC;
    private Invocation _invocation = null;
    public boolean timerDisallowed = false;
    private AddressContainer m_rmiAddressContainer;
    private static ThreadResetHandler[] m_callbackHandlers;
    private Logger m_logger = TraceLogger.getLogger(ThreadState.class);
    private TransportManager m_transportManager;
    private static final InheritableThreadLocal m_inheritableContext;
    private static final InheritableThreadLocal m_inheritableThreadState;
    protected volatile int threadStateCounter = 0;
    private GregorianCalendar calendarCache;

    public ThreadState(ApplicationServerThread applicationThread, Thread thread) {
        super(thread);
        this.init();
        this.applicationThread = applicationThread;
    }

    public ThreadState() {
        super(null);
    }

    public JaccWrapper getJaccWrapper() {
        if (!JaccWrapper.isJaccEnabled()) {
            return null;
        }
        JaccWrapper jaccWrapper = null;
        try {
            ContextContainer cxc = this.getContextContainer();
            jaccWrapper = new JaccWrapper(cxc.getApplication().getName());
        }
        catch (NamingException ne) {
            this.m_logger.log(Level.WARNING, "" + ne);
        }
        return jaccWrapper;
    }

    public JaccWrapper getJaccWrapper(String contextId) {
        return new JaccWrapper(contextId);
    }

    protected void init() {
        this.contextContainer = null;
        this._invocation = null;
        this.user = null;
        this.runAsUser = null;
        this.authenticatingUser = null;
        this.m_cachedRunningSubject = null;
        this.m_propagatedUser = null;
        this.m_propagatedUserSubject = null;
        this.waitingState = null;
        this.waitingForState = null;
        this.waitingForResource = null;
        this.notified = false;
        this.interruptMessage = null;
        this.m_rmiAddressContainer = null;
        this.resetCallerIsORMI();
        this.firstEJBOnStack = true;
        if (this.ejbTC != null) {
            this.ejbTC.init();
        }
        if (!this._users.empty()) {
            this._users.clear();
        }
        if (this.applicationThread != null) {
            this.applicationThread.reset();
        }
        JAZNUserManager.resetThreadLocalState();
    }

    public ApplicationServerThread getApplicationServerThread() {
        return this.applicationThread;
    }

    public boolean isApplicationThread() {
        return this.applicationThread != null;
    }

    public boolean isServletRequestThread() {
        return this.applicationThread != null && this.applicationThread.httpHandler != null;
    }

    public String getServletRequestPath() {
        if (!this.isServletRequestThread()) {
            throw new IllegalStateException("Not a servlet request thread: no request path is defined");
        }
        EvermindHttpServletRequest request = this.applicationThread.httpHandler.request;
        return request == null ? null : request.getServletPath();
    }

    public boolean isRMICall() {
        return this.getTransportManager().isRmiCall();
    }

    private TransportManager getTransportManager() {
        if (this.m_transportManager == null) {
            this.m_transportManager = TransportManager.getInstance();
        }
        return this.m_transportManager;
    }

    public EJBThreadContext getEJBThreadContext() {
        if (this.ejbTC == null) {
            this.ejbTC = new EJBThreadContext(this);
        }
        return this.ejbTC;
    }

    public boolean getAndReset_firstEJBOnStack() {
        boolean _res = this.firstEJBOnStack;
        this.firstEJBOnStack = false;
        return _res;
    }

    public void set_firstEJBOnStack() {
        this.firstEJBOnStack = true;
    }

    protected String dump(ThreadState state) {
        StringBuffer out = new StringBuffer(1000);
        out.append("state                         = " + state + "\n");
        out.append("id                            = " + state.id + "\n");
        out.append("thread                        = " + state.thread.getName() + "\n");
        out.append("user                          = " + state.user + "\n");
        out.append("runAsUser                     = " + state.runAsUser + "\n");
        out.append("propagatedUser                = " + state.m_propagatedUser + "\n");
        out.append("propagatedSubject             = " + state.m_propagatedUserSubject + "\n");
        out.append("waitingState                  = " + state.waitingState + "\n");
        out.append("waitingForState               = " + state.waitingForState + "\n");
        out.append("waitingForResource            = " + state.waitingForResource + "\n");
        out.append("notified                      = " + state.notified + "\n");
        out.append("interruptMessage              = " + state.interruptMessage + "\n");
        out.append("rmiAddressContainer           = " + state.m_rmiAddressContainer + "\n");
        out.append("applicationThread.httpHandler = " + state.applicationThread.httpHandler + "\n");
        out.append("contextContainer              = " + state.contextContainer + "\n");
        return out.toString();
    }

    public static ThreadState getCurrentState() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ApplicationServerThread) {
            return ((ApplicationServerThread)thread).state;
        }
        return (ThreadState)CommonThreadState.getCurrent();
    }

    public static ThreadState getInheritableCurrentState() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ApplicationServerThread) {
            return ((ApplicationServerThread)thread).state;
        }
        InheritableThreadState state = (InheritableThreadState)m_inheritableThreadState.get();
        if (state != null && state.isAvailable()) {
            return state;
        }
        return (ThreadState)CommonThreadState.getCurrent();
    }

    protected CommonThreadState getCurrentState(Thread thread) {
        if (thread instanceof ApplicationServerThread) {
            return ((ApplicationServerThread)thread).state;
        }
        CommonThreadState state = super.getCurrentState(thread);
        return state;
    }

    protected CommonThreadState newThreadState(Thread thread) {
        Object container;
        ThreadState state = new ThreadState(null, thread);
        Object v0 = container = ApplicationServer.threadContextContainer == null ? null : ApplicationServer.threadContextContainer.get();
        if (container instanceof ContextContainer) {
            state.contextContainer = container;
        }
        return state;
    }

    public Subject getCurrentSubject() {
        Subject subject = this.getRunningJAASSubject();
        if (null == subject) {
            subject = this.getCurrentCombinedSubject();
        }
        if (null != subject) {
            subject.setReadOnly();
        }
        return subject;
    }

    private Subject getRunningJAASSubject() {
        if (null != this.m_cachedRunningSubject) {
            if (NO_SUBJECT == this.m_cachedRunningSubject) {
                return null;
            }
            return this.m_cachedRunningSubject;
        }
        try {
            AccessControlContext ctx = AccessController.getContext();
            this.m_cachedRunningSubject = Subject.getSubject(ctx);
            if (null == this.m_cachedRunningSubject) {
                this.m_cachedRunningSubject = NO_SUBJECT;
                return null;
            }
            return NO_SUBJECT == this.m_cachedRunningSubject ? null : this.m_cachedRunningSubject;
        }
        catch (Throwable t) {
            if (ServerProperties.getApplicationServerDebug()) {
                System.out.println("Getting current user from AccessControlContext failed: " + t.getMessage());
            }
            return null;
        }
    }

    User getCurrentJAASUser() {
        Subject subject = this.getRunningJAASSubject();
        UserSubjectBridge bridge = UserSubjectBridge.getInstance();
        User user = null;
        try {
            user = bridge.toUser(subject, this.getContextUserManager());
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, e.getMessage());
        }
        return user;
    }

    Subject getCurrentJAASUserSubject() {
        Subject subject = UserSubjectBridge.getInstance().toSubject(this.getUser());
        return null == subject ? NO_SUBJECT : subject;
    }

    boolean shouldCombine(User existingUser, User runAsUser) {
        if (null != runAsUser || existingUser instanceof RoleUser) {
            return false;
        }
        return this.isPropagatedSubjectMerged();
    }

    Subject getCurrentCombinedSubject() {
        if (this.isPropagatedSubjectMerged()) {
            return this.getCombinedSubject(this.getCurrentJAASUserSubject(), this.getPropagatedSubject(), false);
        }
        if (null != this.getPropagatedSubject()) {
            return this.getPropagatedSubject();
        }
        return this.getCurrentJAASUserSubject();
    }

    Subject getCombinedSubject(Subject toSubject, Subject fromSubject, boolean cloneToSubject) {
        if (null == toSubject) {
            return cloneToSubject ? ThreadState.copyTo(null, fromSubject) : fromSubject;
        }
        if (cloneToSubject || toSubject.isReadOnly()) {
            toSubject = ThreadState.copyTo(null, toSubject);
        }
        return ThreadState.copyTo(toSubject, fromSubject);
    }

    private static Subject copyTo(Subject toSubject, Subject fromSubject) {
        if (null == fromSubject) {
            return toSubject;
        }
        if (null == toSubject) {
            toSubject = new Subject();
        }
        Iterator<Principal> iter = fromSubject.getPrincipals().iterator();
        while (iter.hasNext()) {
            toSubject.getPrincipals().add(iter.next());
        }
        return toSubject;
    }

    public User getUser() {
        User theUser;
        block6: {
            theUser = this.getRunAsUser();
            if (null != theUser) {
                return theUser;
            }
            try {
                theUser = this.getCurrentJAASUser();
                if (null != theUser) {
                    return theUser;
                }
            }
            catch (Throwable t) {
                if (!ServerProperties.getApplicationServerDebug()) break block6;
                this.m_logger.log(Level.WARNING, "Getting current user from AccessControlContext failed: {0}", t.getMessage());
            }
        }
        if (null != (theUser = this.getPropagatedUser())) {
            return theUser;
        }
        this.checkForHttpUser();
        if (this.user != null) {
            return this.user;
        }
        this.checkForAnonymousUser();
        return this.user;
    }

    private void checkForAnonymousUser() {
        if (null == this.user) {
            try {
                this.user = this.getContextUserManager().getAnonymousUser();
            }
            catch (Exception e) {
                this.m_logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    public User getPropagatedUser() {
        Subject propSubject;
        User propUser = super.getPropagatedUser();
        if (null == propUser && null != (propSubject = this.getPropagatedSubject()) && !this.isPropagatedSubjectMerged()) {
            try {
                propUser = UserSubjectBridge.getInstance().toUser(propSubject, this.getContextUserManager());
            }
            catch (Exception e) {
                this.m_logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return propUser;
    }

    private void checkForHttpUser() {
        if (this.user == null) {
            if (this.applicationThread != null && this.applicationThread.httpHandler != null && this.applicationThread.httpHandler.request.getApplication() != null) {
                this.user = this.applicationThread.httpHandler.request.getApplication().getApplication().getServer().getAdminUser();
                this.user = this.applicationThread.httpHandler.request.getUserPrincipalInternal();
            } else {
                ServerApplicationClientLauncherImpl appClientLauncherImpl = ServerApplicationClientLauncherImpl.getCurrentClient();
                if (appClientLauncherImpl != null) {
                    this.user = appClientLauncherImpl.getUser();
                }
            }
        }
    }

    private User getRunAsUser() {
        SecurityRole role;
        String runAsRoleName;
        if (this.runAsUser == null && this.applicationThread != null && this.applicationThread.httpHandler != null && this.applicationThread.servletInfo != null && (runAsRoleName = this.applicationThread.servletInfo.runAsRoleName) != null && (role = this.applicationThread.httpHandler.request.getApplication().getConfig().getSecurityRole(runAsRoleName)) != null) {
            this.runAsUser = new RoleUser(role);
        }
        return this.runAsUser;
    }

    public static User getUser(ThreadState threadState) {
        if (null == threadState) {
            threadState = ThreadState.getCurrentState();
        }
        return threadState.getUser();
    }

    public String toString() {
        return "thread " + String.valueOf(this.id);
    }

    public String getChainMessage() {
        StringBuffer message = new StringBuffer();
        ThreadState state = this;
        ThreadState wstate = null;
        message.append(String.valueOf(state) + " " + state);
        message.append(this.dump(state));
        while (true) {
            message.append(" is waiting for");
            Object resource = state.waitingForResource;
            if (resource != null) {
                message.append(" resource ");
                if (resource instanceof EntityEJBObject) {
                    message.append("entity ");
                } else if (resource instanceof StatefulSessionEJBObject) {
                    message.append("session ");
                } else if (resource instanceof EJBObject) {
                    message.append("EJB ");
                }
                message.append(String.valueOf(resource));
            } else {
                message.append(" a resource");
            }
            wstate = state.waitingForState;
            if (wstate == null) break;
            message.append(" held by ");
            message.append(String.valueOf(wstate) + " " + wstate);
            message.append(this.dump(wstate));
            if (wstate == this) break;
            state = wstate;
            message.append(" who");
        }
        return message.toString();
    }

    public void reset() {
        this.init();
        this.makeResetNotifications();
    }

    public AddressContainer getAddressContainer() {
        if (this.applicationThread != null && this.applicationThread.httpHandler != null) {
            return this.applicationThread.httpHandler.request;
        }
        return this.m_rmiAddressContainer;
    }

    public ContextContainer getContextContainer() {
        if (this.contextContainer != null) {
            return this.contextContainer;
        }
        if (this.applicationThread != null && this.applicationThread.httpHandler != null) {
            return this.applicationThread.httpHandler.request.getApplication();
        }
        return null;
    }

    public void setContextContainer(ContextContainer contextContainer) {
        this.contextContainer = contextContainer;
    }

    public static Object runAs(User user, PrivilegedAction action) {
        OC4JSecurity.assertIsSafe();
        Subject subject = UserSubjectBridge.getInstance().toSubject(user);
        return Subject.doAs(subject, action);
    }

    public Object runAs(PrivilegedExceptionAction action) throws Throwable {
        Subject subject = this.determineRunAsSubject();
        try {
            if (null == subject || subject == this.getRunningJAASSubject()) {
                Object t = action.run();
                return t;
            }
            Object t = Subject.doAs(subject, action);
            return t;
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
        finally {
            this.m_cachedRunningSubject = null;
        }
    }

    Subject determineRunAsSubject() throws Exception {
        Subject subject;
        User existingUser = this.getUser();
        if (null == this.runAsUser && null != (subject = this.getRunningJAASSubject())) {
            return subject;
        }
        if (null != this.runAsUser) {
            return UserSubjectBridge.getInstance().toSubject(this.runAsUser);
        }
        if (this.shouldCombine(existingUser, this.runAsUser)) {
            subject = this.getCombinedSubject(this.getCurrentCombinedSubject(), this.getRunningJAASSubject(), false);
        } else {
            subject = this.getRunningJAASSubject();
            if (null == subject) {
                subject = this.getPropagatedSubject();
            }
            if (null == subject && null == (subject = UserSubjectBridge.getInstance().toSubject(existingUser))) {
                subject = NO_SUBJECT;
            }
        }
        return subject;
    }

    public synchronized void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public synchronized Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public synchronized Object removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(name);
    }

    public Calendar getCalendarCache() {
        if (this.calendarCache == null) {
            this.calendarCache = new GregorianCalendar(HttpDateFormat.GMT_TIMEZONE);
        }
        return this.calendarCache;
    }

    public Invocation getCurrentInvocation() {
        return this._invocation;
    }

    public void setCurrentInvocation(Invocation invocation) {
        this._invocation = invocation;
    }

    public InetAddress getInetAddress() {
        return this.getAddressContainer() == null ? null : this.getAddressContainer().getInetAddress();
    }

    public void setRmiCallingContext(User user, ExecutionContext executionContext, AddressContainer addressContainer) {
        this.setAuthenticatingUser(user);
        this.contextContainer = executionContext;
        this.m_rmiAddressContainer = addressContainer;
    }

    public static void registerResetHandler(ThreadResetHandler handler) {
        OC4JSecurity.assertIsSafe();
        ThreadResetHandler[] newHandlers = new ThreadResetHandler[m_callbackHandlers.length + 1];
        System.arraycopy(m_callbackHandlers, 0, newHandlers, 0, m_callbackHandlers.length);
        newHandlers[ThreadState.m_callbackHandlers.length] = handler;
        m_callbackHandlers = newHandlers;
    }

    private void makeResetNotifications() {
        for (int i = 0; i < m_callbackHandlers.length; ++i) {
            m_callbackHandlers[i].cleanup(this.thread);
        }
    }

    public static void unRegisterResetHandler() {
        m_callbackHandlers = new ThreadResetHandler[0];
    }

    public Object setSystemContext() {
        ContextContainer result = this.contextContainer;
        this.contextContainer = ApplicationServer.getInstance().getSystemApplication();
        return result;
    }

    public void restoreContext(Object context) {
        this.contextContainer = (ContextContainer)context;
    }

    public UserManager getContextUserManager() throws NamingException {
        SecuritySensitive ss;
        Application application;
        UserManager um = null;
        ContextContainer cxc = this.getContextContainer();
        if (null != cxc && null != (application = cxc.getApplication())) {
            um = application.getUserManager();
        }
        if (null == um && null != (ss = SecuritySensitive.global())) {
            um = ss.getSystemUserManager();
        }
        return um;
    }

    public boolean isRemoteFatClient() {
        return false;
    }

    public ClassLoader getClassLoader() {
        ClassLoader result = null;
        ContextContainer container = this.getContextContainer();
        if (container != null) {
            result = container.getClassLoader();
        }
        if (result == null) {
            result = MAIN_LOADER;
        }
        return result;
    }

    public void setInheritable(boolean _inheritable) {
        if (_inheritable) {
            m_inheritableThreadState.set(new InheritableThreadState(this));
        } else {
            m_inheritableThreadState.set(null);
            ++this.threadStateCounter;
        }
    }

    public User getAuthenticatingUser() {
        return this.authenticatingUser;
    }

    public void setAuthenticatingUser(User authenticatingUser) {
        this.authenticatingUser = authenticatingUser;
        this.setActiveUser(this.authenticatingUser);
    }

    public User getRemoteUser() {
        if (this.isServletRequestThread()) {
            return this.applicationThread.httpHandler.request.getUserPrincipalInternal();
        }
        return null;
    }

    public void setRemoteUser(User remoteUser, Subject remoteUserSubject) {
        super.setRemoteUser(remoteUser, remoteUserSubject);
        if (this.isServletRequestThread()) {
            HttpSession httpSession = this.applicationThread.httpHandler.request.getSession(true);
            if (null != httpSession && null != remoteUserSubject) {
                httpSession.setAttribute(ServerSecurityServices.JAAS_SUBJECT, (Object)remoteUserSubject);
            }
            this.applicationThread.httpHandler.request.setRemoteUser(remoteUser);
        }
    }

    static {
        m_inheritableContext = ServerProperties.getOc4jUserThreads() ? new InheritableThreadLocal(){

            protected ContextContainer childValue(ContextContainer parentValue) {
                ContextContainer result = parentValue;
                Thread thread = Thread.currentThread();
                if (thread instanceof ApplicationServerThread && (result = ((ApplicationServerThread)thread).state.getContextContainer()) == null) {
                    result = parentValue;
                }
                return result;
            }
        } : null;
        m_inheritableThreadState = new InheritableThreadLocal();
        CommonThreadState.setExamplar(new ThreadState(null, null));
        if (m_callbackHandlers == null) {
            m_callbackHandlers = new ThreadResetHandler[0];
        }
        ServerSecurityServices.init(true);
    }

    private class InheritableThreadState
    extends ThreadState {
        private ThreadState threadState;
        private int threadStateCounter;

        public InheritableThreadState(ThreadState _threadState) {
            this.threadState = _threadState;
            this.threadStateCounter = this.threadState.threadStateCounter;
        }

        public boolean isAvailable() {
            if (this.threadStateCounter != this.threadState.threadStateCounter) {
                throw new IllegalStateException("A parent thread has been already terminated.");
            }
            return true;
        }

        protected void init() {
            this.isAvailable();
            this.threadState.init();
        }

        protected String dump(ThreadState state) {
            this.isAvailable();
            return this.threadState.dump(state);
        }

        public JaccWrapper getJaccWrapper() {
            this.isAvailable();
            return this.threadState.getJaccWrapper();
        }

        public JaccWrapper getJaccWrapper(String contextId) {
            this.isAvailable();
            return this.threadState.getJaccWrapper(contextId);
        }

        public Calendar getCalendarCache() {
            this.isAvailable();
            return this.threadState.getCalendarCache();
        }

        public ApplicationServerThread getApplicationServerThread() {
            this.isAvailable();
            return this.threadState.getApplicationServerThread();
        }

        public boolean isApplicationThread() {
            this.isAvailable();
            return this.threadState.isApplicationThread();
        }

        public boolean isServletRequestThread() {
            this.isAvailable();
            return this.threadState.isServletRequestThread();
        }

        public String getServletRequestPath() {
            this.isAvailable();
            return this.threadState.getServletRequestPath();
        }

        public boolean isRMICall() {
            this.isAvailable();
            return this.threadState.isRMICall();
        }

        public EJBThreadContext getEJBThreadContext() {
            this.isAvailable();
            return this.threadState.getEJBThreadContext();
        }

        public boolean getAndReset_firstEJBOnStack() {
            this.isAvailable();
            return this.threadState.getAndReset_firstEJBOnStack();
        }

        public void set_firstEJBOnStack() {
            this.isAvailable();
            this.threadState.set_firstEJBOnStack();
        }

        protected CommonThreadState getCurrentState(Thread thread) {
            this.isAvailable();
            return this.threadState.getCurrentState(thread);
        }

        protected CommonThreadState newThreadState(Thread thread) {
            this.isAvailable();
            return this.threadState.newThreadState(thread);
        }

        public Subject getCurrentSubject() {
            this.isAvailable();
            return this.threadState.getCurrentSubject();
        }

        User getCurrentJAASUser() {
            this.isAvailable();
            return this.threadState.getCurrentJAASUser();
        }

        Subject getCurrentJAASUserSubject() {
            this.isAvailable();
            return this.threadState.getCurrentJAASUserSubject();
        }

        Subject getCombinedSubject(Subject toSubject, Subject fromSubject, boolean cloneToSubject) {
            this.isAvailable();
            return this.threadState.getCombinedSubject(toSubject, fromSubject, cloneToSubject);
        }

        public User getUser() {
            this.isAvailable();
            return this.threadState.getUser();
        }

        public User getPropagatedUser() {
            this.isAvailable();
            return this.threadState.getPropagatedUser();
        }

        public Subject getPropagatedSubject() {
            this.isAvailable();
            return this.threadState.getPropagatedSubject();
        }

        public String toString() {
            this.isAvailable();
            return this.threadState.toString();
        }

        public String getChainMessage() {
            this.isAvailable();
            return this.threadState.getChainMessage();
        }

        public void reset() {
            this.isAvailable();
            this.threadState.reset();
        }

        public AddressContainer getAddressContainer() {
            this.isAvailable();
            return this.threadState.getAddressContainer();
        }

        public ContextContainer getContextContainer() {
            this.isAvailable();
            return this.threadState.getContextContainer();
        }

        public void setContextContainer(ContextContainer cxc) {
            this.isAvailable();
            this.threadState.setContextContainer(cxc);
        }

        public Object runAs(PrivilegedExceptionAction action) throws Throwable {
            this.isAvailable();
            return this.threadState.runAs(action);
        }

        Subject determineRunAsSubject() throws Exception {
            this.isAvailable();
            return this.threadState.determineRunAsSubject();
        }

        public synchronized void setAttribute(String name, Object value) {
            this.isAvailable();
            this.threadState.setAttribute(name, value);
        }

        public synchronized Object getAttribute(String name) {
            this.isAvailable();
            return this.threadState.getAttribute(name);
        }

        public synchronized Object removeAttribute(String name) {
            this.isAvailable();
            return this.threadState.removeAttribute(name);
        }

        public Invocation getCurrentInvocation() {
            this.isAvailable();
            return this.threadState.getCurrentInvocation();
        }

        public void setCurrentInvocation(Invocation invocation) {
            this.isAvailable();
            this.threadState.setCurrentInvocation(invocation);
        }

        public InetAddress getInetAddress() {
            this.isAvailable();
            return this.threadState.getInetAddress();
        }

        public void setRmiCallingContext(User user, ExecutionContext executionContext, AddressContainer addressContainer) {
            this.isAvailable();
            this.threadState.setRmiCallingContext(user, executionContext, addressContainer);
        }

        public Object setSystemContext() {
            this.isAvailable();
            return this.threadState.setSystemContext();
        }

        public void restoreContext(Object context) {
            this.isAvailable();
            this.threadState.restoreContext(context);
        }

        public UserManager getContextUserManager() throws NamingException {
            this.isAvailable();
            return this.threadState.getContextUserManager();
        }

        public boolean isRemoteFatClient() {
            this.isAvailable();
            return this.threadState.isRemoteFatClient();
        }

        public ClassLoader getClassLoader() {
            this.isAvailable();
            return this.threadState.getClassLoader();
        }

        public User getRemoteUser() {
            this.isAvailable();
            return this.threadState.getRemoteUser();
        }

        public void setRemoteUser(User remoteUser, Subject remoteUserSubject) {
            this.isAvailable();
            this.threadState.setRemoteUser(remoteUser, remoteUserSubject);
        }

        public User getAuthenticatingUser() {
            this.isAvailable();
            return this.threadState.getAuthenticatingUser();
        }

        public void setAuthenticatingUser(User authenticatingUser) {
            this.isAvailable();
            this.threadState.setAuthenticatingUser(authenticatingUser);
        }

        public void resetCallerIsORMI() {
            this.isAvailable();
            this.threadState.resetCallerIsORMI();
        }

        public void setCallerIsORMI() {
            this.isAvailable();
            this.threadState.setCallerIsORMI();
        }

        public boolean isCallerORMI() {
            this.isAvailable();
            return this.threadState.isCallerORMI();
        }

        public void pushPasswordAuthentication(PasswordAuthentication pa) {
            this.isAvailable();
            this.threadState.pushPasswordAuthentication(pa);
        }

        public PasswordAuthentication popPasswordAuthentication() {
            this.isAvailable();
            return this.threadState.popPasswordAuthentication();
        }

        public PasswordAuthentication getCurrentPasswordAuthentication() {
            this.isAvailable();
            return this.threadState.getCurrentPasswordAuthentication();
        }

        public Subject getRawPropagatedSubject() {
            this.isAvailable();
            return this.threadState.getRawPropagatedSubject();
        }

        public boolean isPropagatedSubjectMerged() {
            this.isAvailable();
            return this.threadState.isPropagatedSubjectMerged();
        }

        public void setPropagatedSubject(Subject subject) {
            this.isAvailable();
            this.threadState.setPropagatedSubject(subject);
        }

        public void setPropagatedSubject(Subject subject, boolean clientSubjectMerged) {
            this.isAvailable();
            this.threadState.setPropagatedSubject(subject, clientSubjectMerged);
        }

        public void setPropagatedUser(User user) {
            this.isAvailable();
            this.threadState.setPropagatedUser(user);
        }

        public User getActiveUser() {
            this.isAvailable();
            return this.threadState.getActiveUser();
        }

        public void setActiveUser(User activeUser) {
            this.isAvailable();
            this.threadState.setActiveUser(activeUser);
        }
    }
}

