/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.security.SecuritySensitive;
import com.evermind.server.NonRecoverableIdException;
import com.evermind.server.Oc4jProcessId;
import com.evermind.server.SubordinateXAResource;
import com.evermind.server.SubordinateXAResourceAdapter;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.SubordinateTransactionManager;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.j2ee.rmi.RMIInitialContextFactory;
import oracle.j2ee.transaction.TransactionMessages;

public class SubordinateXAResourceImpl
implements SubordinateXAResource,
Serializable {
    private static final transient SubordinateXAResourceImpl INSTANCE = new SubordinateXAResourceImpl();
    private static final transient String INITIAL_CONTEXT_FACTORY = RMIInitialContextFactory.class.getName();
    private static final transient String ORMI_LOOKUP_PREFIX = "ormi://";
    public static final String RECOVERY_USER = "JtaAdmin";
    private transient SubordinateTransactionManager m_tm;
    private String m_recoveryString = null;

    private SubordinateXAResourceImpl() {
    }

    static synchronized void initializeInstance(SubordinateTransactionManager tm) throws UnknownHostException {
        if (tm == null) {
            throw new IllegalArgumentException("SubordinateXAResourceImpl: TransactionManager is null during initialization");
        }
        SubordinateXAResourceImpl.INSTANCE.m_tm = tm;
        SubordinateXAResourceImpl.setRecoveryInfo();
    }

    public static SubordinateXAResource instance() {
        if (SubordinateXAResourceImpl.INSTANCE.m_tm == null || SubordinateXAResourceImpl.INSTANCE.m_recoveryString == null) {
            throw new IllegalStateException("Instance has not been initialized");
        }
        return INSTANCE;
    }

    public int prepare(Xid xid) throws XAException {
        return this.m_tm.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.m_tm.commit(xid, onePhase);
    }

    public void rollback(Xid xid) throws XAException {
        this.m_tm.rollback(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.m_tm.recover(flag);
    }

    public int getTransactionTimeout() {
        return this.m_tm.getTransactionTimeout();
    }

    public void beforeCompletion() {
        this.m_tm.beforeCompletion();
    }

    public void forget(Xid xid) throws XAException {
        this.m_tm.forget(xid);
    }

    public void end(Xid xid, int flag) throws XAException, RemoteException {
        this.m_tm.end(xid, flag);
    }

    public String getRecoveryInfo() {
        return this.m_recoveryString;
    }

    public XAResource connect(String rmArgs) throws TPCException {
        Oc4jProcessId processId;
        SubordinateXAResource xaResource = null;
        int firstSeperatorIndex = rmArgs.indexOf("_");
        int passwordIndex = Integer.parseInt(rmArgs.substring(0, firstSeperatorIndex));
        String processIdString = rmArgs.substring(firstSeperatorIndex + 1, passwordIndex - 1);
        try {
            processId = Oc4jProcessId.recreateIdForRecovery(processIdString);
        }
        catch (NonRecoverableIdException e) {
            TransactionMessages.severe("Unable to recreate Oc4jProcessId from logged args :" + processIdString + ": " + e);
            TPCException tpcException = new TPCException("Unable to recreate Oc4jProcessId from logged args :" + processIdString);
            tpcException.initCause(e);
            throw tpcException;
        }
        xaResource = this.lookupRecoveryResource(processId, rmArgs.substring(passwordIndex, rmArgs.length()));
        return new SubordinateXAResourceAdapter(xaResource, rmArgs);
    }

    private SubordinateXAResource lookupRecoveryResource(Oc4jProcessId id, String password) throws TPCException {
        try {
            SubordinateXAResource subordinateXAResource = (SubordinateXAResource)new RMIInitialContextFactory().getInitialContext((Hashtable)this.createContextEnvironment(id, password)).lookup("oc4j:internal/serverXAResource");
            if (subordinateXAResource == null) {
                throw new TPCException("Null value bound in JNDI for SubordinateXAResource");
            }
            return subordinateXAResource;
        }
        catch (NamingException e) {
            System.err.println("Unable to lookup remote SubordinateXAResource for recovery: " + e);
            TPCException tpcException = new TPCException("Unable to lookup remote SubordinateXAResource for recovery");
            tpcException.initCause(e);
            throw tpcException;
        }
    }

    private Properties createContextEnvironment(Oc4jProcessId id, String password) {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        props.put("java.naming.security.principal", RECOVERY_USER);
        props.put("java.naming.security.credentials", password);
        props.put("java.naming.provider.url", ORMI_LOOKUP_PREFIX + id.getHost() + ":" + id.getOrmiPortForRecovery());
        return props;
    }

    private static void setRecoveryInfo() throws UnknownHostException {
        String password = SubordinateXAResourceImpl.getRecoveryPassword();
        String processId = Oc4jProcessId.currentProcessId().getUniqueId();
        StringBuffer buf = new StringBuffer(64);
        buf.append(SubordinateXAResourceImpl.calculatePasswordOffset(processId));
        buf.append("_");
        buf.append(processId);
        buf.append("_");
        buf.append(password);
        SubordinateXAResourceImpl.INSTANCE.m_recoveryString = buf.toString();
    }

    private static int calculatePasswordOffset(String processId) {
        int offset = processId.length() + 2;
        offset = offset < 9 ? ++offset : (offset < 98 ? (offset += 2) : (offset < 997 ? (offset += 3) : (offset += 4)));
        return offset;
    }

    private static String getRecoveryPassword() {
        try {
            return SecuritySensitive.global().decode("->JtaAdmin");
        }
        catch (SecurityException e) {
            TransactionMessages.warning("SubordinateXAResourceImpl: Unable to obtain password for interposed JTA recovery user: JtaAdmin.  The interposed JTA recovery user/password must be configured for the server to import transactions propagated from other OC4J processes.  Any transactions propagated to this server from another OC4J process will result in a rollback occurring. Please refer to the OC4J documentation regarding the configuring of the interposed recovery user.");
            throw e;
        }
    }
}

