/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.net.AccessRegionSet;
import com.evermind.net.AddressContainer;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.ApplicationServer;
import com.evermind.server.RoleUser;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.SecurityRole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuntimeSecurityRole {
    private UserManager manager;
    private Set roles;
    private boolean impliesAll;
    private Group[] groups;
    private User[] users;
    private AccessRegionSet accessMask;
    private RuntimeSecurityRole[] subRoles;

    public RuntimeSecurityRole(UserManager manager, Set roles) {
        if (manager == null) {
            throw new NullPointerException("UserManager was null");
        }
        if (roles == null) {
            throw new NullPointerException("Roles where null");
        }
        this.manager = manager;
        this.roles = roles;
        this.queryRolesAndSetImpliesAll();
    }

    public boolean impliesUser(User user, AddressContainer addressContainer) {
        int i;
        if (user == null && (user = ApplicationServer.instance.getUserManager().getAnonymousUser()) == null) {
            return false;
        }
        if (this.accessMask != null) {
            if (addressContainer == null) {
                addressContainer = ThreadState.getCurrentState().getAddressContainer();
            }
            if (addressContainer != null && !this.accessMask.allow(addressContainer.getInetAddress())) {
                return false;
            }
        }
        if (this.impliesAll) {
            return true;
        }
        if (user instanceof RoleUser) {
            if (this.roles != null && this.roles.contains(((RoleUser)user).getRole())) {
                return true;
            }
            try {
                Collection c1 = this.getUsers();
                List c2 = ((RoleUser)user).getRole().getUsers();
                Iterator iter1 = c1.iterator();
                Iterator iter2 = c2.iterator();
                boolean contains = false;
                while (iter2.hasNext()) {
                    String str = (String)iter2.next();
                    contains = false;
                    while (iter1.hasNext()) {
                        User usr = (User)iter1.next();
                        if (!usr.getName().equals(this.manager.getUser(str).getName())) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    return false;
                }
                if (contains) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.groups == null) {
                this.initPrincipals();
                if (this.impliesAll) {
                    return true;
                }
            }
        }
        if (this.groups == null) {
            this.initPrincipals();
            if (this.accessMask != null) {
                if (addressContainer == null) {
                    addressContainer = ThreadState.getCurrentState().getAddressContainer();
                }
                if (addressContainer != null && !this.accessMask.allow(addressContainer.getInetAddress())) {
                    return false;
                }
            }
            if (this.impliesAll) {
                return true;
            }
        }
        for (i = 0; i < this.groups.length; ++i) {
            if (!user.isMemberOf(this.groups[i])) continue;
            return true;
        }
        for (i = 0; i < this.users.length; ++i) {
            if (!user.equals(this.users[i])) continue;
            return true;
        }
        if (this.subRoles != null) {
            for (i = 0; i < this.subRoles.length; ++i) {
                if (!this.subRoles[i].impliesUser(user, addressContainer)) continue;
                return true;
            }
        }
        return false;
    }

    private void initPrincipals() {
        if (this.impliesAll()) {
            return;
        }
        HashSet userNames = new HashSet();
        HashSet<String> groupNames = new HashSet<String>();
        Iterator iterator = this.roles.iterator();
        ArrayList<RuntimeSecurityRole> subRoles = new ArrayList<RuntimeSecurityRole>();
        while (iterator.hasNext()) {
            SecurityRole role = (SecurityRole)iterator.next();
            if (role == null) continue;
            if (role.getAccessMask() != null) {
                if (this.roles.size() == 1) {
                    this.accessMask = role.getAccessMask();
                } else {
                    HashSet<SecurityRole> subAssemblyRoles = new HashSet<SecurityRole>();
                    subAssemblyRoles.add(role);
                    subRoles.add(new RuntimeSecurityRole(this.manager, subAssemblyRoles));
                    iterator.remove();
                    continue;
                }
            }
            userNames.addAll(role.getUsers());
            groupNames.addAll(role.getGroups());
        }
        ArrayList<User> userList = new ArrayList<User>();
        ArrayList<Group> groupList = new ArrayList<Group>();
        if (userNames.isEmpty() && groupNames.isEmpty()) {
            iterator = this.roles.iterator();
            while (iterator.hasNext()) {
                SecurityRole role = (SecurityRole)iterator.next();
                if (role.getAccessMask() != null) {
                    if (this.roles.size() > 1) {
                        HashSet<SecurityRole> subAssemblyRoles = new HashSet<SecurityRole>();
                        subAssemblyRoles.add(role);
                        subRoles.add(new RuntimeSecurityRole(this.manager, subAssemblyRoles));
                        continue;
                    }
                    groupNames.add(role.getName());
                    this.accessMask = role.getAccessMask();
                    continue;
                }
                groupNames.add(role.getName());
            }
        }
        iterator = userNames.iterator();
        while (iterator.hasNext()) {
            User foundUser = this.manager.getUser(iterator.next().toString());
            if (foundUser == null) continue;
            userList.add(foundUser);
        }
        iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            Group foundGroup;
            Object next = iterator.next();
            if (next == null || (foundGroup = this.manager.getGroup(next.toString())) == null) continue;
            groupList.add(foundGroup);
        }
        this.groups = groupList.toArray(new Group[groupList.size()]);
        this.users = userList.toArray(new User[userList.size()]);
        if (subRoles.size() > 0) {
            this.subRoles = subRoles.toArray(new RuntimeSecurityRole[subRoles.size()]);
        }
    }

    private void queryRolesAndSetImpliesAll() {
        Iterator itar = this.roles.iterator();
        while (itar.hasNext()) {
            SecurityRole role = (SecurityRole)itar.next();
            if (role == null || !role.impliesAll()) continue;
            this.accessMask = role.getAccessMask();
            if (role.getAccessMask() != null && this.roles.size() != 1) continue;
            this.impliesAll = true;
            break;
        }
    }

    public Collection getGroups() {
        if (this.groups == null) {
            this.initPrincipals();
        }
        return Arrays.asList(this.groups);
    }

    public Collection getUsers() {
        if (this.groups == null) {
            this.initPrincipals();
        }
        return Arrays.asList(this.users);
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setImpliesAll(boolean implies) {
        this.impliesAll = implies;
    }

    public boolean impliesAll() {
        if (this.accessMask != null) {
            return false;
        }
        return this.impliesAll;
    }
}

