/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.TransactionEnlistment;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class ResourceXidHolder {
    private XAResource[] m_resources;
    private Xid[] m_xids;

    ResourceXidHolder(Set resources, TransactionEnlistment onePhaseResource) {
        this.populateResourcesandXids(resources, onePhaseResource);
    }

    ResourceXidHolder(Set resources) {
        this.populateResourcesandXids(resources, null);
    }

    void populateResourcesandXids(Set resources, TransactionEnlistment onePhaseResource) {
        int i = 0;
        int resourceCount = onePhaseResource == null ? resources.size() : resources.size() + 1;
        this.m_resources = new XAResource[resourceCount];
        this.m_xids = new Xid[resourceCount];
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            TransactionEnlistment transactionEnlistment = (TransactionEnlistment)iterator.next();
            this.m_resources[i] = transactionEnlistment.getWrappedResource();
            this.m_xids[i++] = transactionEnlistment.getXid();
        }
        if (onePhaseResource != null) {
            this.m_resources[resourceCount - 1] = onePhaseResource.getWrappedResource();
            this.m_xids[resourceCount - 1] = onePhaseResource.getXid();
        }
    }

    XAResource[] getResources() {
        return this.m_resources;
    }

    Xid[] getXids() {
        return this.m_xids;
    }
}

