/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.OC4JServer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class OC4JServiceInfo {
    protected String id = null;
    protected String hostname = null;
    protected int port = -1;
    protected String portStr = null;
    protected String description = null;
    protected String protocol = null;
    private boolean sentValidationWarning = false;
    public static String HTTP = "http";
    public static String HTTPS = "https";
    public static String AJP = "ajp";
    public static String AJP13 = "ajp13";
    public static String AJPS = "ajps";
    public static String RMI = "rmi";
    public static String RMIS = "rmis";
    public static String JMS = "jms";
    private static Logger m_traceLogger = TraceLogger.getLogger(OC4JServer.class);

    public OC4JServiceInfo(String id, String protocol, int port) {
        this.setId(id);
        this.setProtocol(protocol);
        this.setPort(port);
    }

    public OC4JServiceInfo(String id, String protocol, String hostname, int port, String description) {
        this.setId(id);
        this.setHostname(hostname);
        this.setPort(port);
        this.setDescription(description);
        this.setProtocol(protocol);
    }

    public OC4JServiceInfo() {
    }

    public boolean validate() {
        if (this.getHostname() != null && this.getPort() > 0 && this.protocol != null) {
            return true;
        }
        if (!this.sentValidationWarning) {
            System.out.println("WARNING: OC4J will not send ONS ProcReadyPort messages to opmn for service: " + this.toString());
            if (this.hostname == null) {
                System.out.println(this.id + " hostname was null");
            }
            this.sentValidationWarning = true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getProcReadyId() {
        if (this.id != null) {
            return this.id;
        }
        return this.protocol;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getPortStr() {
        if (this.portStr == null) {
            this.portStr = String.valueOf(this.port);
        }
        return this.portStr;
    }

    public void setPort(int port) {
        if (this.port > 0 && this.port != port) {
            m_traceLogger.log(Level.WARNING, "Port for service: " + this.getId() + " is being updated from: " + this.port + " to: " + port);
        }
        this.port = port;
    }

    public String getProcReadyDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getProcReadyId();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        if (this.protocol != null && !this.protocol.equals(protocol)) {
            m_traceLogger.log(Level.WARNING, "Protocol for service: " + this.getId() + " is being updated from: " + this.protocol + " to: " + protocol);
        }
        this.protocol = protocol;
    }

    public boolean isSameProtocol(String protocol) {
        if (protocol.equals(AJP13) && this.protocol == AJP) {
            return true;
        }
        return protocol.equals(protocol);
    }

    public boolean isWebSiteService() {
        return OC4JServiceInfo.isWebSiteProtocol(this.protocol);
    }

    public static boolean isWebSiteProtocol(String protocol) {
        return protocol != null && (protocol.equals(HTTP) || protocol.equals(HTTPS) || protocol.equals(AJP) || protocol.equals(AJPS));
    }

    public boolean equals(Object o) {
        if (o instanceof OC4JServiceInfo) {
            OC4JServiceInfo si = (OC4JServiceInfo)o;
            if (si.id.equals(this.id)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "OC4JServiceInfo id: " + this.id + " protocol: " + this.protocol + " hostname: " + this.hostname + " port: " + this.port + " description: " + this.description;
    }
}

