/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationServer;
import com.evermind.server.DataSharedBetweenStates;
import com.evermind.server.administration.RemoteData;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.ResourceProvider;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpSite;
import com.evermind.util.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ResourceDataAccessor;
import oracle.j2ee.connector.DeployedAdapter;
import oracle.j2ee.connector.ResourceAdapterWrapper;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;

public abstract class ApplicationState {
    protected Application application;
    protected Application parent;
    protected ApplicationServer server;
    protected ClassLoader parentClassLoader = null;
    protected Hashtable nonJTAMap;
    protected Object dataSourceContainersLock = new Object();
    protected List dataSourceContainers;
    protected DataSharedBetweenStates sharedData;

    protected ApplicationState(Application application) {
        this.application = application;
        this.parent = application.getParent();
        this.server = application.getServer();
    }

    abstract DeployedAdapter addConnector(ConnectorModule var1, String var2, Notifier var3) throws InstantiationException;

    abstract HttpApplication getHttpApplication(String var1, String var2, boolean var3, long var4, boolean var6, HttpSite var7, boolean var8) throws InstantiationException;

    abstract PolicyClassLoader getBeansClassLoader();

    abstract void flushDynamicLoaders();

    abstract ClassLoader getClassLoader();

    abstract long getstartTime();

    abstract String getejbClassLoaderPath();

    abstract void initializeApplication(ApplicationConfig var1, Notifier var2) throws InstantiationException;

    abstract byte[] getiiopStubs(ApplicationConfig var1) throws IOException;

    abstract void checkForComponentUpdates(String var1, Map var2);

    abstract DeployedAdapter getResourceAdapter(String var1);

    abstract DeployedAdapter getActiveDeployedAdapter(String var1);

    abstract ResourceAdapterWrapper lookupResourceAdapter(String var1) throws NamingException;

    abstract void stopClients(Notifier var1);

    abstract ResourceProvider getProvider(String var1);

    abstract List getActiveResourceAdapters();

    abstract EJBContainer getEJBContainer();

    abstract ResourceProvider[] getResourceProviders();

    abstract void recordApplicationStartTime();

    abstract boolean isInitialized();

    abstract void destroyActiveRunningStateObjects(Logger var1);

    abstract void stopActiveRunningStateObjects(Logger var1);

    abstract void clientsCleanUp(Logger var1);

    abstract void destroyClassLoaders();

    abstract Map getWebApplications();

    abstract void initNativeDataSource(NativeDataSourceConfig var1, boolean var2) throws DataSourceException, MBeanException, DataSourceConfigException;

    abstract void initManagedDataSource(ManagedDataSourceConfig var1, boolean var2) throws DataSourceException, DataSourceConfigException;

    abstract void removeManagedDataSource(String var1) throws DataSourceException, MBeanException;

    abstract void removeNativeDataSource(String var1) throws DataSourceException, MBeanException;

    abstract void copyNativeDataSource(String var1, String var2, String var3) throws DataSourceConfigException, DataSourceException, MBeanException;

    protected abstract void initDataSourceConnectionPool(ConnectionPoolConfig var1, boolean var2) throws DataSourceException;

    abstract void copyDataSourceConnectionPool(String var1, String var2, String var3) throws DataSourceException, DataSourceConfigException, MBeanException, ResourceException;

    abstract void copyManagedDataSource(String var1, String var2, String var3) throws DataSourceConfigException, DataSourceException;

    abstract void removeDataSourceConnectionPool(String var1) throws DataSourceException, MBeanException;

    abstract void renameManagedDataSource(String var1, String var2) throws DataSourceConfigException, DataSourceException;

    abstract void renameNativeDataSource(String var1, String var2) throws DataSourceConfigException, DataSourceException;

    abstract DataSourceConnectionPool getDataSourceConnectionPool(String var1);

    protected abstract void addActiveResourceAdapter(DeployedAdapter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDataSourceCache() {
        Object object = this.dataSourceContainersLock;
        synchronized (object) {
            if (this.dataSourceContainers == null) {
                return;
            }
            Iterator iterator = this.dataSourceContainers.iterator();
            while (iterator.hasNext()) {
                DataSourceConnectionContainer container = (DataSourceConnectionContainer)iterator.next();
                container.removeUnusedCache(false);
            }
        }
    }

    protected PersistenceUnitManager getPersistenceUnitManager() {
        return null;
    }

    ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public String getNonJtaJNDIName(String dsName) {
        String name;
        if (this.nonJTAMap != null && (name = (String)this.nonJTAMap.get(dsName)) != null) {
            return name;
        }
        if (this.parent != null) {
            return this.parent.getNonJtaJNDIName(dsName);
        }
        return null;
    }

    public RemoteData getClassData(String name, long requestLastModified) throws IOException {
        String resourcePath = name.replace('.', '/').concat(".class");
        ResourceDataAccessor resource = ClassLoaderQuery.getResource((PolicyClassLoader)((PolicyClassLoader)this.getClassLoader()), (boolean)true, (String)resourcePath);
        if (resource != null) {
            byte[] classData = resource.getData();
            long lastModified = resource.getLastModifiedTime();
            if (requestLastModified / 1000L == lastModified / 1000L && requestLastModified > 0L) {
                return new RemoteData(null, requestLastModified);
            }
            return new RemoteData(classData, lastModified);
        }
        return null;
    }

    public DataSourceConnectionContainer getDataSourceContainer(String initialName, int isolationLevel) throws InstantiationException {
        Object object = this.dataSourceContainersLock;
        synchronized (object) {
            String name = initialName;
            if (name == null) {
                if (this.parent != null) {
                    return this.parent.getDataSourceContainer(initialName, isolationLevel);
                }
                throw new InstantiationException("No default cmt-datasource and no source specified");
            }
            if (this.application.getNativeDataSourceConfigs().size() == 0 && this.application.getManagedDataSourceConfigs().size() == 0 && this.parent != null) {
                return this.parent.getDataSourceContainer(initialName, isolationLevel);
            }
            if (this.dataSourceContainers == null) {
                this.dataSourceContainers = new ArrayList();
            }
            DataSourceConnectionContainer container = null;
            Iterator iterator = this.dataSourceContainers.iterator();
            while (iterator.hasNext()) {
                container = (DataSourceConnectionContainer)iterator.next();
                if (!container.getName().equals(name) || isolationLevel != -7 && container.getIsolationLevel() != isolationLevel) continue;
                return container;
            }
            try {
                Object jndiObject = this.application.getContext().lookup(name);
                if (!(jndiObject instanceof DataSource)) {
                    throw new InstantiationException("The object at " + name + " must be a DataSource object.");
                }
                DataSource sourceObject = (DataSource)jndiObject;
                container = new DataSourceConnectionContainer(this.server, name, isolationLevel, sourceObject, this.server.logger);
                this.dataSourceContainers.add(container);
                return container;
            }
            catch (NameNotFoundException e) {
            }
            catch (NamingException e) {
                throw new InstantiationException("Error looking up cmt-datasource at " + name + ": " + e.getMessage());
            }
            if (this.parent != null) {
                return this.parent.getDataSourceContainer(initialName, isolationLevel);
            }
            throw new InstantiationException("Error looking up cmt-datasource at " + name + " (name not found)");
        }
    }

    void setSharedData(DataSharedBetweenStates sharedData) {
        this.sharedData = sharedData;
    }

    DataSharedBetweenStates getSharedData() {
        return this.sharedData;
    }
}

