/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionSynchronization;
import com.evermind.server.DMSEvent;
import com.evermind.server.ResourceXidHolder;
import com.evermind.server.SinglePhaseResource;
import com.evermind.server.TransactionEnlistment;
import com.evermind.server.TwoPhaseCommitProvider;
import com.evermind.server.WrappedXAResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.TransactionState;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.ParticipantRecoverable;
import oracle.as.j2ee.transaction.tpc.ProtocolError;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorNotification;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorWithNotification;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.j2ee.transaction.OC4JTransaction;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.oc4j.transaction.TransactionIsolationLevel;

public class ApplicationServerTransaction
extends ApplicationServerTransactionSynchronization
implements OC4JTransaction {
    ApplicationServerTransactionManager m_manager;
    private NormalXid m_xid;
    private long m_currentBranchID;
    private String m_rollbackMessage;
    private int m_status = 0;
    private List m_exceptions;
    private long m_startTime;
    private int m_transactionTimeout;
    long m_timePrepared;
    Set m_resources = new HashSet();
    private TransactionEnlistment m_onePhaseCommitResource;
    private Synchronization[] m_synchronizations;
    private int m_synchronizationCount;
    private Synchronization[] m_interposedSynchronizations;
    private int m_interposedSynchronizationCount;
    private Map m_transactionSyncRegistryResourceMap = new HashMap();
    private ProtocolErrorNotification[] m_protocolErrorNotifications;
    private int m_protocolErrorNotificationCount;
    Boolean m_beforeCompletionCalled = new Boolean(false);
    private boolean m_statusSuspended = false;
    TwoPhaseCommitProvider m_tpcEngine = null;
    int m_txRollbackCause = 200;
    private HashMap m_xaResToConnFactoryMap = new HashMap();
    private boolean m_isCurrentlyInfecting = false;
    private Object m_concurrencyLock = new int[0];
    ParentReference m_parentReference;
    private final PresumedNothingLatch m_presumedNothingLatch = new PresumedNothingLatch();
    private boolean m_workConsumerReceivedMessage = true;
    private boolean m_allowRollbackByTimeout = true;
    boolean m_isRootOfImportedTx = false;
    private String m_type = null;
    static final String APPLICATION_UNKNOWN = "Application Unknown";
    static final String ROOT_OF_IMPORTED_TX = "(root of inflowed transaction)";
    static final int NO_ISOLATION_LEVEL = -1;
    private int m_isolationLevel = -1;
    private DMSEvent m_performTxEvent = DMSEvent.create(0);
    private DMSEvent m_txnSuspendEvent = DMSEvent.create(3);
    private DMSEvent m_performCommittedTxEvent = DMSEvent.create(9);

    public ApplicationServerTransaction(Xid xid, int timeout, ApplicationServerTransactionManager manager, ParentReference pr) {
        super.setTransaction(this);
        this.m_startTime = this.getCurrentTimeMillis();
        this.m_manager = manager;
        this.setTransactionTimeout(timeout);
        this.m_xid = new NormalXid(xid);
        this.m_parentReference = pr;
        TransactionMessages.fineTxCreated(this);
        this.m_performTxEvent.start();
        this.m_performCommittedTxEvent.start();
    }

    public boolean enlistResource(XAResource resource) throws RollbackException, SystemException {
        return this.enlistResource(resource, this.getNextBranchID());
    }

    public boolean enlistResource(XAResource resource, byte[] bqual) throws RollbackException, SystemException {
        if (this.isInDBCoordAndInCompletion()) {
            return false;
        }
        if (resource == null) {
            this.throwSystemExceptionFromEnlist("Attempt to enlist a null XAResource.  Branch qualifier : " + bqual, null);
        }
        if (bqual == null) {
            this.throwSystemExceptionFromEnlist("Attempt to enlist with a null branch qualifier. XAResource : " + resource, null);
        }
        this.checkMarkedForRollback();
        this.checkActive();
        XAResource unwrappedResource = this.unwrapResource(resource);
        if (this.isResourceAlreadyEnlisted(unwrappedResource)) {
            return false;
        }
        String rmFactoryLocation = null;
        if (resource instanceof RMId) {
            rmFactoryLocation = ((RMId)((Object)resource)).getRMFactoryJndiLocation().getJndiLocation();
        }
        if (this.m_manager.getRecoveryManager().isXAResourceUnacquired(rmFactoryLocation)) {
            throw new RollbackException("Resource was in use during abnormal shutdown of server and during subsequent recovery processing was either unobtainable or failed to have recovery permissions.  Consult logs if this issue continues to occur after the next recovery processing interval completes");
        }
        this.setTransactionIsolationLevel(resource);
        this.doEnlist(unwrappedResource, resource, rmFactoryLocation, bqual);
        this.setPresumptionStrategy(resource);
        return true;
    }

    private void setTransactionIsolationLevel(XAResource resource) throws SystemException {
        TransactionIsolationLevel transactionIsolationLevel;
        if (this.m_isolationLevel != -1 && (transactionIsolationLevel = this.unwrapTransactionIsolationLevelResource(resource)) != null) {
            try {
                TransactionMessages.fineSetIsolationLevel(this, this.m_isolationLevel);
                transactionIsolationLevel.setTransactionIsolation(this.m_isolationLevel);
            }
            catch (XAException e) {
                this.setTxRollbackCause(203);
                this.throwSystemExceptionFromEnlist("Failed to add the resource due to error during setTransactionIsolation : " + e + " errorcode : " + e.errorCode, e);
            }
        }
    }

    public void commit() throws RollbackException, SystemException, HeuristicMixedException {
        try {
            this.doCommit();
        }
        catch (HeuristicCommitException e) {
            this.forgetConsistentHeuristicDecision();
        }
        catch (HeuristicRollbackException e) {
            this.forgetConsistentHeuristicDecision();
            RollbackException re = new RollbackException("All branches reported heuristic Rollback");
            re.initCause((Throwable)e);
            throw re;
        }
    }

    private void doEnlist(XAResource unwrappedResource, XAResource resource, String factoryLocation, byte[] bqual) throws SystemException {
        try {
            TransactionMessages.fineEnlistResource(this, resource, unwrappedResource, factoryLocation, bqual);
            NormalXid xid = new NormalXid(this.m_xid.getGlobalTransactionId(), this.m_xid.getFormatId(), bqual);
            if (unwrappedResource instanceof SinglePhaseResource && this.m_manager.isLastResourceCommitSupported()) {
                this.enlistSinglePhaseResource(resource, factoryLocation, xid);
            } else {
                this.enlist2pcResource(resource, factoryLocation, xid);
            }
        }
        catch (XAException e) {
            this.setTxRollbackCause(203);
            this.throwSystemExceptionFromEnlist("Failed to add the resource due to error in the resource : " + e + " errorcode : " + e.errorCode, e);
        }
    }

    private void enlist2pcResource(XAResource resource, String factoryLocation, NormalXid xid) throws XAException {
        TransactionEnlistment enlistment = this.createAndStartTxEnlistment(resource, xid);
        this.m_resources.add(enlistment);
        this.addtoXAToConnFactoryMap(xid, factoryLocation);
    }

    void enlistSinglePhaseResource(XAResource resource, String jndiLocation, NormalXid xid) throws XAException, SystemException {
        TransactionMessages.fineAttemptToEnlistSinglePhaseResource(this);
        if (this.m_onePhaseCommitResource != null) {
            this.throwSystemExceptionFromEnlist("Only one single phase commit resource may be enlisted in a transaction", null);
        }
        this.m_onePhaseCommitResource = this.createAndStartTxEnlistment(resource, xid);
        this.addtoXAToConnFactoryMap(xid, jndiLocation);
        TransactionMessages.fineAttemptToEnlistSinglePhaseResourceSuccessful(this);
    }

    private TransactionEnlistment createAndStartTxEnlistment(XAResource resource, NormalXid xid) throws XAException {
        TransactionEnlistment enlistment = new TransactionEnlistment(resource);
        enlistment.setTransactionTimeout(this.getTransactionTimeout());
        enlistment.start(xid, 0);
        return enlistment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doCommit() throws RollbackException, SystemException, HeuristicCommitException, HeuristicRollbackException, HeuristicMixedException {
        DMSEvent commitEvent = DMSEvent.create(10);
        try {
            this.checkForRollbackOnlyWhileInCommit();
            this.throwProtocolErrorIfNotActive();
            this.callBeforeCompletion();
            this.checkForRollbackOnlyWhileInCommit();
            this.endResources(true);
            this.checkForRollbackOnlyWhileInCommit();
            commitEvent = this.commitBasedOnResourceCount();
            this.updateCompletionStatistics();
            Object var3_2 = null;
            if (this.getTransactionState() != 16) {
                this.m_manager.freeResources(this);
            } else {
                this.callProtocolErrorNotifications();
            }
            if (this.isAnyWorkDone()) {
                this.m_performTxEvent.stop();
                this.m_performCommittedTxEvent.stop();
                commitEvent.stop();
            } else {
                this.m_performTxEvent.abort();
                this.m_performCommittedTxEvent.abort();
                commitEvent.abort();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.getTransactionState() != 16) {
                this.m_manager.freeResources(this);
            } else {
                this.callProtocolErrorNotifications();
            }
            if (this.isAnyWorkDone()) {
                this.m_performTxEvent.stop();
                this.m_performCommittedTxEvent.stop();
                commitEvent.stop();
            } else {
                this.m_performTxEvent.abort();
                this.m_performCommittedTxEvent.abort();
                commitEvent.abort();
            }
            throw throwable;
        }
    }

    private TransactionIsolationLevel unwrapTransactionIsolationLevelResource(XAResource resource) throws SystemException {
        if (resource instanceof TransactionIsolationLevel) {
            return (TransactionIsolationLevel)((Object)resource);
        }
        while (resource instanceof WrappedXAResource) {
            if ((resource = ((WrappedXAResource)((Object)resource)).getWrappedResource()) instanceof TransactionIsolationLevel) {
                return (TransactionIsolationLevel)((Object)resource);
            }
            if (resource != null) continue;
            this.throwSystemExceptionFromEnlist("Unwrapped Resource is null.", null);
        }
        return null;
    }

    private XAResource unwrapResource(XAResource resource) throws SystemException {
        while (resource instanceof WrappedXAResource) {
            if ((resource = ((WrappedXAResource)((Object)resource)).getWrappedResource()) != null) continue;
            this.throwSystemExceptionFromEnlist("Unwrapped Resource is null.", null);
        }
        return resource;
    }

    private boolean isInDBCoordAndInCompletion() {
        return this.m_manager != null && !this.m_manager.isUsingMidTierCoordinator() && this.getTransactionState() == 5;
    }

    boolean throwSystemExceptionFromEnlist(String msg, XAException rootException) throws SystemException {
        SystemException se = new SystemException(msg);
        if (rootException != null) {
            se.initCause((Throwable)rootException);
        }
        TransactionMessages.warningEnlistResourceFailed(msg, rootException);
        this.markForRollback();
        this.setTxRollbackCause(203);
        if (rootException != null) {
            this.addException(rootException);
        } else {
            this.addException(se);
        }
        throw se;
    }

    synchronized void suspend() throws SystemException {
        int transactionState = this.getTransactionState();
        if (transactionState != 0 && !this.getRollbackOnly()) {
            throw new SystemException("Transaction state is " + TransactionState.toString(transactionState) + " and therefore can not be suspended, transaction : " + this);
        }
        Iterator iterator = this.m_resources.iterator();
        while (iterator.hasNext()) {
            this.suspendResource((TransactionEnlistment)iterator.next());
        }
        if (this.m_onePhaseCommitResource != null) {
            this.suspendResource(this.m_onePhaseCommitResource);
        }
        this.setStatusSuspended();
        this.m_txnSuspendEvent.start();
    }

    private void suspendResource(TransactionEnlistment resource) throws SystemException {
        try {
            resource.end(resource.getXid(), 0x2000000);
        }
        catch (XAException e) {
            this.setRollbackOnly("Exception occurred while suspending resource : " + resource.getWrappedResource() + " (" + resource.getXid() + "): " + e, e);
            SystemException se = new SystemException("Failed to suspend resource : " + resource);
            se.initCause((Throwable)e);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resume() throws SystemException, InvalidTransactionException {
        if (this.enteredCompletionProtocol()) {
            throw new IllegalStateException("Subcoordinator has entered completion protocol.");
        }
        if (!this.m_statusSuspended) {
            throw new InvalidTransactionException("Cannot resume transaction that is not suspended, transaction is " + TransactionState.toString(this.getTransactionState()));
        }
        if (this.getTransactionState() == 13) {
            throw new InvalidTransactionException("Cannot resume transaction that has been rolledback, rollback cause=" + this.m_rollbackMessage);
        }
        DMSEvent resumeResourceEvent = DMSEvent.create(7);
        resumeResourceEvent.start();
        try {
            Iterator iterator = this.m_resources.iterator();
            while (iterator.hasNext()) {
                this.resumeResource((TransactionEnlistment)iterator.next());
            }
            if (this.m_onePhaseCommitResource != null) {
                this.resumeResource(this.m_onePhaseCommitResource);
            }
        }
        finally {
            resumeResourceEvent.stop();
        }
        this.m_statusSuspended = false;
        this.handleResume();
        this.m_txnSuspendEvent.stop();
    }

    public boolean enteredCompletionProtocol() {
        return this.m_tpcEngine != null || this.getTransactionState() == 5 || this.getTransactionState() == 3;
    }

    private void setStatusSuspended() {
        this.m_statusSuspended = true;
    }

    boolean isSuspended() {
        return this.m_statusSuspended;
    }

    public synchronized void registerSynchronization(Synchronization synchronization) throws RollbackException, SystemException {
        this.registerSynchronization(synchronization, false);
    }

    synchronized void registerInterposedSynchronization(Synchronization synchronization) throws RollbackException, SystemException {
        this.registerSynchronization(synchronization, true);
    }

    synchronized void putResource(Object key, Object value) throws IllegalStateException {
        this.m_transactionSyncRegistryResourceMap.put(key, value);
    }

    synchronized Object getResource(Object key) throws IllegalStateException {
        return this.m_transactionSyncRegistryResourceMap.get(key);
    }

    private void registerSynchronization(Synchronization synchronization, boolean isInterposed) throws SystemException, RollbackException {
        if (this.isInDBCoordAndInCompletion()) {
            return;
        }
        if (synchronization == null) {
            throw new SystemException("Synchronization was null");
        }
        this.checkMarkedForRollback();
        this.checkActive();
        if (isInterposed) {
            if (this.m_interposedSynchronizations == null) {
                this.m_interposedSynchronizations = new Synchronization[INITIAL_AMOUNT];
            }
            for (int i = 0; i < this.m_interposedSynchronizationCount; ++i) {
                if (!this.m_interposedSynchronizations[i].equals(synchronization)) continue;
                return;
            }
            if (this.m_interposedSynchronizationCount >= this.m_interposedSynchronizations.length) {
                Synchronization[] newSynchronizations = new Synchronization[this.m_interposedSynchronizations.length * 2];
                System.arraycopy(this.m_interposedSynchronizations, 0, newSynchronizations, 0, this.m_interposedSynchronizations.length);
                this.m_interposedSynchronizations = newSynchronizations;
            }
            this.m_interposedSynchronizations[this.m_interposedSynchronizationCount++] = synchronization;
        } else {
            if (this.m_synchronizations == null) {
                this.m_synchronizations = new Synchronization[INITIAL_AMOUNT];
            }
            for (int i = 0; i < this.m_synchronizationCount; ++i) {
                if (!this.m_synchronizations[i].equals(synchronization)) continue;
                return;
            }
            if (this.m_synchronizationCount >= this.m_synchronizations.length) {
                Synchronization[] newSynchronizations = new Synchronization[this.m_synchronizations.length * 2];
                System.arraycopy(this.m_synchronizations, 0, newSynchronizations, 0, this.m_synchronizations.length);
                this.m_synchronizations = newSynchronizations;
            }
            this.m_synchronizations[this.m_synchronizationCount++] = synchronization;
        }
    }

    public synchronized void registerProtocolErrorNotification(ProtocolErrorNotification protocolErrorNotification) throws RollbackException, SystemException {
        if (this.isInDBCoordAndInCompletion()) {
            return;
        }
        if (protocolErrorNotification == null) {
            throw new SystemException("ProtocolErrorNotification was null");
        }
        this.checkMarkedForRollback();
        this.checkActive();
        if (this.m_protocolErrorNotifications == null) {
            this.m_protocolErrorNotifications = new ProtocolErrorNotification[INITIAL_AMOUNT];
        }
        for (int i = 0; i < this.m_protocolErrorNotificationCount; ++i) {
            if (!this.m_protocolErrorNotifications[i].equals(protocolErrorNotification)) continue;
            return;
        }
        if (this.m_protocolErrorNotificationCount >= this.m_protocolErrorNotifications.length) {
            ProtocolErrorNotification[] newProtocolErrorNotifications = new ProtocolErrorNotification[this.m_protocolErrorNotifications.length * 2];
            System.arraycopy(this.m_protocolErrorNotifications, 0, newProtocolErrorNotifications, 0, this.m_protocolErrorNotifications.length);
            this.m_protocolErrorNotifications = newProtocolErrorNotifications;
        }
        this.m_protocolErrorNotifications[this.m_protocolErrorNotificationCount++] = protocolErrorNotification;
    }

    public synchronized void setRollbackOnly() throws SystemException {
        this.markForRollback();
    }

    public synchronized void setRollbackOnly(String message, Throwable throwable) {
        if (this.getTransactionState() == 0) {
            this.setRollbackMessage(message);
            if (throwable != null) {
                this.addException(throwable);
            }
            this.markForRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SystemException {
        try {
            this.rollback(null);
        }
        finally {
            this.m_manager.freeResources(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void rollback(String rollbackMessage) throws SystemException {
        DMSEvent rollbackEvent = DMSEvent.create(4);
        try {
            rollbackEvent.start();
            this.makeRollbackNotification();
            this.endResources(false);
            this.checkTransactionActiveOrRollbackOnly();
            this.setTransactionState(3);
            if (rollbackMessage != null) {
                this.m_rollbackMessage = rollbackMessage;
            }
            TransactionMessages.fineRollingBack(this, rollbackMessage);
            Throwable errorInResourceDuringRollback = this.rollbackResources();
            this.updateCompletionStatistics();
            if (errorInResourceDuringRollback != null) {
                this.interpretExceptionFromRollback(errorInResourceDuringRollback);
            }
            Object var5_4 = null;
            if (this.isAnyWorkDone()) {
                rollbackEvent.stop();
                this.m_performTxEvent.stop();
            } else {
                rollbackEvent.abort();
                this.m_performTxEvent.abort();
            }
            this.m_performCommittedTxEvent.abort();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.isAnyWorkDone()) {
                rollbackEvent.stop();
                this.m_performTxEvent.stop();
            } else {
                rollbackEvent.abort();
                this.m_performTxEvent.abort();
            }
            this.m_performCommittedTxEvent.abort();
            throw throwable;
        }
    }

    private void interpretExceptionFromRollback(Throwable errorInResourceDuringRollback) throws SystemException {
        if (!(errorInResourceDuringRollback instanceof XAException)) {
            throw (SystemException)new SystemException(TransactionMessages.warningErrorInResourceDuringRollback(errorInResourceDuringRollback.toString())).initCause(errorInResourceDuringRollback);
        }
        int errorCode = ((XAException)errorInResourceDuringRollback).errorCode;
        switch (errorCode) {
            case -7: 
            case -4: 
            case -3: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                TransactionMessages.warningErrorInResourceDuringRollback(errorInResourceDuringRollback.toString() + ", errorCode : " + errorCode);
                break;
            }
            default: {
                throw (SystemException)new SystemException(TransactionMessages.warningErrorInResourceDuringRollback(errorInResourceDuringRollback.toString() + ", errorCode : " + errorCode)).initCause(errorInResourceDuringRollback);
            }
        }
    }

    Throwable rollbackResources() {
        Throwable errorInResourceDuringRollback = null;
        Iterator iterator = this.m_resources.iterator();
        while (iterator.hasNext()) {
            errorInResourceDuringRollback = this.rollbackResource((TransactionEnlistment)iterator.next());
        }
        if (this.m_onePhaseCommitResource != null) {
            errorInResourceDuringRollback = this.rollbackResource(this.m_onePhaseCommitResource);
        }
        this.setTransactionState(13);
        return errorInResourceDuringRollback;
    }

    private Throwable rollbackResource(TransactionEnlistment resource) {
        Throwable errorInDriver = null;
        try {
            resource.rollback(resource.getXid());
        }
        catch (XAException e) {
            this.addException(e);
            errorInDriver = e;
        }
        catch (Throwable t) {
            this.addException(t);
            errorInDriver = t;
        }
        return errorInDriver;
    }

    private DMSEvent commitBasedOnResourceCount() throws RollbackException, SystemException, HeuristicCommitException, HeuristicRollbackException, HeuristicMixedException {
        DMSEvent dmsEvent;
        switch (this.getResourceCount()) {
            case 0: {
                dmsEvent = DMSEvent.create(10);
                this.setTransactionState(12);
                break;
            }
            case 1: {
                dmsEvent = DMSEvent.create(1);
                dmsEvent.start();
                this.singlePhaseCommit();
                break;
            }
            default: {
                dmsEvent = DMSEvent.create(2);
                dmsEvent.start();
                this.twoPhaseCommit();
            }
        }
        return dmsEvent;
    }

    private void forgetConsistentHeuristicDecision() {
        try {
            this.m_manager.forget(this.getGlobalTransaction());
        }
        catch (XAException xAException) {
            // empty catch block
        }
    }

    private void checkForRollbackOnlyWhileInCommit() throws SystemException, RollbackException {
        if (this.getRollbackOnly()) {
            this.rollback(null);
            RollbackException rollbackException = new RollbackException(this.getRollbackMessage());
            if (this.m_exceptions != null && !this.m_exceptions.isEmpty()) {
                rollbackException.initCause((Throwable)this.m_exceptions.get(0));
            }
            throw rollbackException;
        }
    }

    private void checkActive() throws IllegalStateException {
        if (this.getTransactionState() != 0) {
            throw new IllegalStateException(TransactionMessages.warningOperationCalledOnInactiveTransaction(this, TransactionState.toString(this.getTransactionState())));
        }
    }

    private void throwProtocolErrorIfNotActive() {
        if (this.getTransactionState() != 0) {
            this.m_manager.cleanupForProtocolError(this);
            throw new ProtocolErrorWithNotification(TransactionMessages.warningOperationCalledOnInactiveTransaction(this, TransactionState.toString(this.getTransactionState())));
        }
    }

    private void checkMarkedForRollback() throws RollbackException {
        if (this.getRollbackOnly()) {
            throw new RollbackException(TransactionMessages.warningTransactionMarkedForRollback(this.m_rollbackMessage));
        }
    }

    private void checkTransactionActiveOrRollbackOnly() throws IllegalStateException {
        if (this.getTransactionState() != 0 && !this.getRollbackOnly()) {
            throw new IllegalStateException("Not active or marked for rollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRollback(int reason, boolean isAlwaysRollback) {
        String reasonString;
        this.setTxRollbackCause(reason);
        switch (reason) {
            case 205: {
                reasonString = "OC4J shutdown";
                break;
            }
            case 204: {
                reasonString = "Administrative call";
                break;
            }
            default: {
                reasonString = "Timed out";
            }
        }
        if (this.getThreadState().waitingForResource != null) {
            this.getThreadState().interruptMessage = "Rolling Back due to " + reasonString + ", while waiting for " + this.getThreadState().waitingForResource + " (started at " + new Date(this.m_startTime) + ", terminated at " + new Date(this.getCurrentTimeMillis()) + ")";
            this.getThreadState().thread.interrupt();
        }
        ApplicationServerTransaction applicationServerTransaction = this;
        synchronized (applicationServerTransaction) {
            if (this.m_allowRollbackByTimeout && (this.isSuspended() || isAlwaysRollback)) {
                TransactionMessages.fineForcingRollingbackDueTo(reasonString);
                try {
                    this.rollback(reasonString);
                }
                catch (Throwable t) {
                    TransactionMessages.warningErrorRollingbackDueTo(t.toString());
                }
                finally {
                    this.m_manager.freeResources(this);
                }
            } else {
                this.setRollbackOnly(reasonString, null);
            }
        }
    }

    private synchronized void singlePhaseCommit() throws RollbackException, SystemException {
        this.setTransactionState(5);
        try {
            if (this.m_onePhaseCommitResource != null) {
                this.m_onePhaseCommitResource.commit(this.m_onePhaseCommitResource.getXid(), true);
            } else {
                TransactionEnlistment transactionEnlistment = (TransactionEnlistment)this.m_resources.toArray()[0];
                transactionEnlistment.commit(transactionEnlistment.getXid(), true);
            }
            this.setTransactionState(12);
        }
        catch (XAException xaex) {
            this.mediateOnePhaseCommitException(xaex);
        }
    }

    private void mediateOnePhaseCommitException(XAException xaex) throws RollbackException, SystemException {
        if (xaex.errorCode >= 100 || xaex.errorCode == -3 || xaex.errorCode == -4 || xaex.errorCode == -5) {
            this.setTransactionState(13);
            RollbackException ex = new RollbackException("Received an XAException from commit1: " + xaex.errorCode);
            ex.initCause((Throwable)xaex);
            throw ex;
        }
        if (xaex.errorCode == -7) {
            this.setTransactionState(17);
            SystemException ex = new SystemException("Received XAException.RMFAIL from commit1");
            ex.initCause((Throwable)xaex);
            throw ex;
        }
        this.setTransactionState(17);
        ProtocolErrorWithNotification error = new ProtocolErrorWithNotification("Illegal return code for commit: " + xaex.errorCode);
        error.initCause(xaex);
        throw error;
    }

    private synchronized void twoPhaseCommit() throws RollbackException, SystemException, HeuristicCommitException, HeuristicRollbackException, HeuristicMixedException {
        TwoPhaseCommitProvider commitDriver = this.m_manager.createCoordinator(this);
        this.setCoordinator(commitDriver);
        ResourceXidHolder resources = new ResourceXidHolder(this.m_resources, this.m_onePhaseCommitResource);
        try {
            try {
                commitDriver.commit(resources.getResources(), resources.getXids());
            }
            catch (SystemException e) {
                this.handleCommitSystemException(commitDriver, e);
            }
        }
        catch (ProtocolError e) {
            this.m_manager.cleanupForProtocolError(this);
            throw e;
        }
        this.setTransactionState(12);
    }

    void setCoordinator(TwoPhaseCommitProvider coordinator) {
        if (this.m_manager.isUsingMidTierCoordinator()) {
            this.m_tpcEngine = coordinator;
        }
    }

    void handleCommitSystemException(TwoPhaseCommitProvider twoPhaseCommitProvider, SystemException systemException) throws RollbackException, HeuristicCommitException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        TransactionMessages.finer("Handling SystemException from two-phase commit :" + (Object)((Object)systemException));
        if (!this.m_manager.isUsingMidTierCoordinator()) {
            throw systemException;
        }
        this.m_manager.addRecoveredTransaction(this.m_tpcEngine.getGlobalTransaction());
        switch (this.m_tpcEngine.getGlobalTransaction().getTransactionState()) {
            case 12: {
                break;
            }
            case 5: {
                this.m_tpcEngine = null;
                this.setTransactionState(12);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                HeuristicRollbackException hre = new HeuristicRollbackException();
                hre.initCause((Throwable)systemException);
                throw hre;
            }
            case 15: {
                HeuristicMixedException ie = new HeuristicMixedException("Commit resulted in a heuristic inconsistent outcome");
                ie.initCause((Throwable)systemException);
                throw ie;
            }
            case 14: {
                SystemException se = new SystemException("Commit resulted in an inconsistent outcome");
                se.initCause((Throwable)systemException);
                throw se;
            }
            case 3: 
            case 6: {
                this.m_tpcEngine = null;
                this.setTransactionState(13);
            }
            case 13: {
                RollbackException rbe = new RollbackException();
                rbe.initCause((Throwable)systemException);
                throw rbe;
            }
            default: {
                this.setTransactionState(16);
                this.m_manager.removeTransaction(this.getXid());
                ProtocolErrorWithNotification pe = new ProtocolErrorWithNotification("Invalid state: " + this.m_tpcEngine.getGlobalTransaction().getTransactionState() + " for transaction " + this.m_tpcEngine.getGlobalTransaction());
                pe.initCause(systemException);
                this.m_tpcEngine = null;
                throw pe;
            }
        }
    }

    public boolean isParticipantRecoverable() {
        return !this.m_presumedNothingLatch.isPresumeNothing();
    }

    public final int getStatus() {
        return TransactionState.convertToJTAStatus(this.getTransactionState());
    }

    public final int getTransactionState() {
        if (this.m_tpcEngine == null || this.m_tpcEngine.getGlobalTransaction() == null) {
            return this.m_status;
        }
        return this.m_tpcEngine.getGlobalTransaction().getTransactionState();
    }

    void setTransactionState(int state) {
        this.m_status = state;
        TransactionMessages.fineSetTxState(this, TransactionState.toString(state));
    }

    public boolean equals(Object other) {
        if (!(other instanceof ApplicationServerTransaction)) {
            return false;
        }
        ApplicationServerTransaction oTx = (ApplicationServerTransaction)other;
        return this.hashCode() == oTx.hashCode() && this.m_xid.equals(oTx.m_xid);
    }

    public int hashCode() {
        return this.m_xid.hashCode();
    }

    void setTransactionTimeout(int timeout) {
        this.m_transactionTimeout = timeout;
    }

    public int getTransactionTimeout() {
        return this.m_transactionTimeout;
    }

    public long getTransactionTimeoutInMillis() {
        return (long)this.getTransactionTimeout() * 1000L;
    }

    boolean isTimedOut() {
        return this.m_startTime + this.getTransactionTimeoutInMillis() <= this.getCurrentTimeMillis();
    }

    public long getTimeActive() {
        return this.getCurrentTimeMillis() - this.m_startTime;
    }

    public synchronized boolean delistResource(XAResource resource, int mode) throws SystemException {
        XAResource unwrappedResource = this.unwrapResource(resource);
        Iterator iterator = this.m_resources.iterator();
        while (iterator.hasNext()) {
            try {
                TransactionEnlistment txEnlistment = (TransactionEnlistment)iterator.next();
                if (!this.unwrapResource(txEnlistment.getWrappedResource()).isSameRM(unwrappedResource)) continue;
                txEnlistment.end(txEnlistment.getXid(), mode);
                return true;
            }
            catch (XAException e) {
                TransactionMessages.fineDelistResourceModeIs("" + mode);
                TransactionMessages.warningXAExceptionDuringEnd(e);
                this.setRollbackOnly("Error delisting resource: " + e, e);
                SystemException se = new SystemException("Unable to delist resource due to an unknown error");
                se.initCause((Throwable)e);
                throw se;
            }
        }
        try {
            if (this.m_onePhaseCommitResource != null && this.unwrapResource(this.m_onePhaseCommitResource.getWrappedResource()).isSameRM(unwrappedResource)) {
                this.m_onePhaseCommitResource.end(this.m_onePhaseCommitResource.getXid(), mode);
                return true;
            }
        }
        catch (XAException xe) {
            this.setRollbackOnly();
            SystemException se = new SystemException("Unable to delist resource due to an unknown error");
            se.initCause((Throwable)xe);
            throw se;
        }
        return false;
    }

    public String getRollbackMessage() {
        if (this.m_rollbackMessage != null) {
            return this.m_rollbackMessage;
        }
        if (this.m_exceptions != null && !this.m_exceptions.isEmpty()) {
            return "returning error in transaction: " + this.m_exceptions.get(0);
        }
        return null;
    }

    public Throwable getFirstThrowable() {
        if (this.m_exceptions == null || this.m_exceptions.isEmpty()) {
            return null;
        }
        return (Throwable)this.m_exceptions.get(0);
    }

    public byte[] getNextBranchID() {
        byte[] nextBranch = new byte[16];
        for (int i = 0; i < 4; ++i) {
            nextBranch[i] = ApplicationServerTransactionManager.m_serverIDBytes[i];
        }
        long currentBranch = this.m_currentBranchID++;
        nextBranch[4] = 0;
        nextBranch[5] = 0;
        nextBranch[6] = 0;
        nextBranch[7] = 0;
        nextBranch[8] = (byte)(currentBranch >> 56);
        nextBranch[9] = (byte)(currentBranch >> 48);
        nextBranch[10] = (byte)(currentBranch >> 40);
        nextBranch[11] = (byte)(currentBranch >> 32);
        nextBranch[12] = (byte)(currentBranch >> 24);
        nextBranch[13] = (byte)(currentBranch >> 16);
        nextBranch[14] = (byte)(currentBranch >> 8);
        nextBranch[15] = (byte)currentBranch;
        return nextBranch;
    }

    Xid getNextXid() {
        return new NormalXid(this.m_xid.getGlobalTransactionId(), this.m_xid.getFormatId(), this.getNextBranchID());
    }

    public void addException(Throwable t) {
        if (this.m_exceptions == null) {
            this.m_exceptions = new ArrayList();
        } else {
            for (int i = 0; i < this.m_exceptions.size(); ++i) {
                if (this.m_exceptions.get(i) != t) continue;
                return;
            }
        }
        this.m_exceptions.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callBeforeCompletion() {
        if (this.beforeCompletionCalled()) {
            return;
        }
        DMSEvent beforeCompletionEvent = DMSEvent.create(6);
        try {
            int i;
            beforeCompletionEvent.start();
            for (i = 0; i < this.m_synchronizationCount; ++i) {
                try {
                    this.m_synchronizations[i].beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        // empty catch block
                    }
                    TransactionMessages.warningErrorInBeforeCompletion(t.toString());
                    this.addException(t);
                }
            }
            for (i = 0; i < this.m_interposedSynchronizationCount; ++i) {
                try {
                    this.m_interposedSynchronizations[i].beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        // empty catch block
                    }
                    TransactionMessages.warningErrorInBeforeCompletion(t.toString());
                    this.addException(t);
                }
            }
        }
        finally {
            beforeCompletionEvent.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beforeCompletionCalled() {
        Boolean bl = this.m_beforeCompletionCalled;
        synchronized (bl) {
            if (this.m_beforeCompletionCalled.booleanValue()) {
                return true;
            }
            this.m_beforeCompletionCalled = new Boolean(true);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRollbackNotification() {
        Boolean bl = this.m_beforeCompletionCalled;
        synchronized (bl) {
            if (!this.m_beforeCompletionCalled.booleanValue()) {
                this.preRollbackNotification();
            }
        }
    }

    void endResources(boolean success) {
        if (this.m_onePhaseCommitResource != null) {
            try {
                this.m_onePhaseCommitResource.end(this.m_onePhaseCommitResource.getXid(), success ? 0x4000000 : 0x20000000);
            }
            catch (XAException e) {
                success = false;
                this.setRollbackOnly("Exception occurred during resource end(): " + this.m_onePhaseCommitResource + " (" + this.m_onePhaseCommitResource.getXid() + "): " + e, e);
            }
        }
        TransactionEnlistment resource = null;
        Iterator iterator = this.m_resources.iterator();
        while (iterator.hasNext()) {
            try {
                resource = (TransactionEnlistment)iterator.next();
                resource.end(resource.getXid(), success ? 0x4000000 : 0x20000000);
            }
            catch (XAException e) {
                success = false;
                this.setRollbackOnly("Exception occurred during resource end(): " + resource.getWrappedResource() + " (" + resource.getXid() + "): " + e, e);
            }
        }
    }

    private boolean isResourceAlreadyEnlisted(XAResource resource) throws SystemException {
        Iterator i = this.m_resources.iterator();
        while (i.hasNext()) {
            if (this.unwrapResource(((TransactionEnlistment)i.next()).getWrappedResource()) != resource) continue;
            return true;
        }
        return this.m_onePhaseCommitResource != null && this.unwrapResource(this.m_onePhaseCommitResource.getWrappedResource()) == resource;
    }

    private void resumeResource(TransactionEnlistment resource) throws SystemException {
        try {
            resource.start(resource.getXid(), 0x8000000);
        }
        catch (XAException e) {
            this.setRollbackOnly("Error resuming resource TX for " + resource.getWrappedResource() + " (" + resource.getXid() + "): " + e, e);
            SystemException se = new SystemException("Failed to resume resource : " + resource);
            se.initCause((Throwable)e);
            throw se;
        }
    }

    void callSynchronizationAfterCompletion() {
        int i;
        if (this.m_status == 16) {
            return;
        }
        for (i = 0; i < this.m_interposedSynchronizationCount; ++i) {
            try {
                this.m_interposedSynchronizations[i].afterCompletion(TransactionState.convertToJTAStatus(this.getTransactionState()));
                continue;
            }
            catch (Throwable t) {
                TransactionMessages.warningExceptionDuringAfterCompletionNotifications(t);
            }
        }
        for (i = 0; i < this.m_synchronizationCount; ++i) {
            try {
                this.m_synchronizations[i].afterCompletion(TransactionState.convertToJTAStatus(this.getTransactionState()));
                continue;
            }
            catch (Throwable t) {
                TransactionMessages.warningExceptionDuringAfterCompletionNotifications(t);
            }
        }
    }

    void callProtocolErrorNotifications() {
        for (int i = 0; i < this.m_protocolErrorNotificationCount; ++i) {
            try {
                this.m_protocolErrorNotifications[i].protocolErrorOccurred();
                continue;
            }
            catch (Throwable t) {
                TransactionMessages.warningExceptionDuringProtocolErrorNotifications(t);
            }
        }
    }

    public byte[] getGlobalID() {
        return this.m_xid.getGlobalTransactionId();
    }

    protected void setRollbackMessage(String message) {
        if (this.m_rollbackMessage == null) {
            this.m_rollbackMessage = message;
        }
    }

    public Xid getXid() {
        return this.m_xid;
    }

    public String getType() {
        try {
            return this.m_type != null ? this.m_type : this.threadState.getContextContainer().getApplication().getName() + (this.m_isRootOfImportedTx ? " (root of inflowed transaction)" : "");
        }
        catch (Exception e) {
            return APPLICATION_UNKNOWN;
        }
    }

    public void setType(String type) {
        this.m_type = type;
    }

    void setIsRootOfImportedTxTrue() {
        this.m_isRootOfImportedTx = true;
    }

    public String getIDString() {
        return this.m_xid.toString();
    }

    public String toString() {
        return "[Transaction : " + this.getType() + " : " + this.getIDString() + "]";
    }

    public String getTxInfo() {
        return this.toString() + " Transaction start time = " + this.m_startTime + " Transaction timeout time = " + (this.m_startTime + this.getTransactionTimeoutInMillis());
    }

    protected void updateCompletionStatistics() {
        if (!ApplicationServer.DMS_GATE) {
            return;
        }
        switch (this.getTransactionState()) {
            case 12: {
                if (!this.isAnyWorkDone()) break;
                this.m_manager.getStats().updateCommitted(this.m_startTime);
                break;
            }
            case 13: {
                if (!this.isAnyWorkDone()) break;
                if (this.getTxRollbackCause() == 200) {
                    this.setTxRollbackCause(203);
                }
                this.m_manager.getStats().updateRolledback(this.getTxRollbackCause());
                break;
            }
        }
    }

    public void setWorkConsumerReceivedMessageFalse() {
        this.m_workConsumerReceivedMessage = false;
    }

    private boolean isAnyWorkDone() {
        return this.m_workConsumerReceivedMessage || this.getResourceCount() > 1;
    }

    private void setPresumptionStrategy(XAResource resource) {
        if (!(resource instanceof ParticipantRecoverable)) {
            this.m_presumedNothingLatch.setPresumeNothing();
        }
    }

    public HashMap getEnlistedResourcesInfo() {
        return this.m_xaResToConnFactoryMap;
    }

    private void addtoXAToConnFactoryMap(NormalXid xid, String jndiLocation) {
        if (jndiLocation == null || jndiLocation.equals("")) {
            return;
        }
        this.m_xaResToConnFactoryMap.put(xid, jndiLocation);
    }

    int prepare() throws XAException {
        XAException xae = new XAException("prepare() called on non-subordinate transaction");
        xae.errorCode = -6;
        throw xae;
    }

    void commit(boolean heuristic, boolean onePhase) throws XAException {
        XAException xae = new XAException("Attempt to inflow commit call for non-interposed transaction");
        xae.errorCode = -6;
        throw xae;
    }

    public void rollback(boolean heuristic) throws XAException {
        XAException xae = new XAException("Attempt to inflow rollback call for non-interposed transaction");
        xae.errorCode = -6;
        throw xae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockIfConcurrentRequest() {
        Object object = this.m_concurrencyLock;
        synchronized (object) {
            while (this.m_isCurrentlyInfecting) {
                try {
                    this.m_concurrencyLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_isCurrentlyInfecting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markInfectingBegin() {
        Object object = this.m_concurrencyLock;
        synchronized (object) {
            this.m_isCurrentlyInfecting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markInfectingEnded() {
        Object object = this.m_concurrencyLock;
        synchronized (object) {
            this.m_isCurrentlyInfecting = false;
            this.m_concurrencyLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentlyInfecting(boolean infecting) {
        Object object = this.m_concurrencyLock;
        synchronized (object) {
            this.m_isCurrentlyInfecting = infecting;
        }
    }

    GlobalTransaction getGlobalTransaction() {
        return this.m_tpcEngine != null ? this.m_tpcEngine.getGlobalTransaction() : null;
    }

    int getResourceCount() {
        return this.m_onePhaseCommitResource == null ? this.m_resources.size() : this.m_resources.size() + 1;
    }

    int getSynchronizationCount() {
        return this.m_synchronizationCount + this.m_interposedSynchronizationCount;
    }

    public int getTxRollbackCause() {
        return this.m_txRollbackCause;
    }

    public void setTxRollbackCause(int txRollbackCause) {
        if (this.m_txRollbackCause == 200) {
            this.m_txRollbackCause = txRollbackCause;
        }
    }

    private void markForRollback() {
        if (this.getTransactionState() == 0) {
            this.setTransactionState(2);
        }
    }

    boolean getRollbackOnly() {
        return this.getTransactionState() == 2;
    }

    boolean isTPCEngineSet() {
        return this.m_tpcEngine != null;
    }

    long getTimePrepared() {
        if (this.m_timePrepared == 0L) {
            return 0L;
        }
        return this.getCurrentTimeMillis() - this.m_timePrepared;
    }

    long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public void setAllowRollbackByTimeout(boolean allowRollback) {
        this.m_allowRollbackByTimeout = allowRollback;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.m_isolationLevel = transactionIsolation;
    }

    public int getTransactionIsolation() {
        return this.m_isolationLevel;
    }

    private class PresumedNothingLatch {
        private boolean m_presumeNothing = false;

        private PresumedNothingLatch() {
        }

        private synchronized void setPresumeNothing() {
            this.m_presumeNothing = true;
        }

        private synchronized boolean isPresumeNothing() {
            return this.m_presumeNothing;
        }
    }
}

