/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.administration.DefaultApplicationServerAdministrator;
import com.evermind.server.http.HttpSite;
import com.evermind.util.ServerProperties;
import com.evermind.util.SystemStreamRotater;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.oc4j.admin.internal.DeployerFactory;
import oracle.oc4j.admin.internal.DeployerIF;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class ApplicationServerTask
implements Runnable {
    private String _siteName = null;
    private int dataSourceCacheCounter = 0;
    private int dataSourceCacheCounterInterval = 20;
    protected ApplicationServer server;
    private int memoryUsageCounter = 10;
    private int memoryUsageCounterInterval = 10;
    private String[] autoDeployFileNames;
    public static boolean FORCE_AUTO_DEPLOYMENT = ServerProperties.getForceAutoDeployment();

    public ApplicationServerTask(ApplicationServer server) {
        this.server = server;
    }

    public void run() {
        ((ApplicationServerTransactionManager)this.server.getTransactionManager()).manageExpirations(true, this.server.recoverBottomUp());
        if (this.server.recoverBottomUp()) {
            this.server.getBottomUpCOR().attemptQueries();
        }
        if (this.server.getCheckForUpdatesMode().equals("all")) {
            this.server.checkForUpdates();
        }
        if (this.memoryUsageCounter++ >= this.memoryUsageCounterInterval) {
            this.memoryUsageCounter = 0;
            this.server.memoryUsage[this.server.memoryUsagePos] = (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
            ++this.server.memoryUsagePos;
            this.server.memoryUsagePos %= this.server.memoryUsage.length;
            ++this.server.memoryUsageLength;
        }
        if (this.dataSourceCacheCounter++ >= this.dataSourceCacheCounterInterval) {
            this.dataSourceCacheCounter = 0;
            this.server.getDefaultApplication().removeDataSourceCache();
        }
        if ((!ServerProperties.getRunningInIAS() || FORCE_AUTO_DEPLOYMENT) && (this.dataSourceCacheCounter & 3) == 1 && this.server.autoDeploymentDirectory != null) {
            this.performAutoDeployCheck();
        }
        if (SystemStreamRotater.isRotatable) {
            SystemStreamRotater.rotate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAutoDeployCheck() {
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            if (DefaultApplicationServerAdministrator.isIASDeploymentTransaction()) {
                return;
            }
            String[] files = this.server.autoDeploymentDirectory.list();
            boolean investigate = this.needsAutoDeploy(files);
            if (!investigate) {
                return;
            }
            this._siteName = this.getSiteName();
            this.autoDeployFileNames = files;
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                this.deploySingleFile(file);
            }
        }
    }

    private void deploySingleFile(String file) {
        try {
            if (!file.endsWith(".ear")) {
                return;
            }
            URL url = new File(this.server.autoDeploymentDirectory, file).toURL();
            if (new File(url.getFile()).isDirectory()) {
                return;
            }
            if (this.checkUrlHasDeployed(url)) {
                return;
            }
            String applicationName = file.substring(0, file.length() - 4);
            DataSink sink = new DataSink(url.getFile());
            SharedModuleType type = SharedModuleType.EAR;
            HashMap<String, String> extraParams = new HashMap<String, String>();
            extraParams.put("targetPath", this.server.getConfig().getAutoDeployApplicationDirectory());
            if (this._siteName != null) {
                extraParams.put("bindWebApp", this._siteName);
            }
            DeployerIF deployer = DeployerFactory.getInstance(sink, applicationName, type, extraParams);
            boolean isRedeploy = true;
            deployer.execute(isRedeploy);
        }
        catch (Exception e) {
            System.err.println("deploySingleFile() got Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean needsAutoDeploy(String[] files) {
        if (files == null || files.length == 0) {
            return false;
        }
        if (this.autoDeployFileNames == null || files.length != this.autoDeployFileNames.length) {
            return true;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(this.autoDeployFileNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkUrlHasDeployed(URL url) {
        boolean found = false;
        try {
            Iterator iterator = this.server.getConfig().getApplicationConfigs().iterator();
            while (iterator.hasNext()) {
                ApplicationConfigReference application = (ApplicationConfigReference)iterator.next();
                if (!application.getURL().equals(url)) continue;
                found = true;
                break;
            }
        }
        catch (Exception e) {
            System.err.println("checkUrlHasDeployed returns false due to Exception: " + e.getMessage());
            e.printStackTrace();
        }
        return found;
    }

    private String getSiteName() {
        try {
            List sites = this.server.getHttpServer().getSites();
            if (sites == null || sites.isEmpty()) {
                return null;
            }
            HttpSite site = (HttpSite)sites.get(0);
            return site.getShortName();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("In ApplicationServerTask, unable to get site name: " + e.getMessage());
            return null;
        }
    }
}

