/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.security.Group;
import com.evermind.server.AdministrationPermission;
import com.evermind.server.rmi.RMIPermission;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ApplicationServerGroup
implements Group,
XMLizable,
Comparable {
    protected String name;
    protected String description;
    protected Set members = new HashSet();
    protected Set permissions = new HashSet();
    protected boolean isDefault;

    public ApplicationServerGroup(String name) {
        this.name = name;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    public void removePermission(Permission permission) {
        this.permissions.remove(permission);
    }

    public void addPermissions(Collection permissions) {
        this.permissions.addAll(permissions);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Group)) {
            return false;
        }
        return this.name.equals(((Group)other).getName());
    }

    public boolean hasPermission(Permission permission) {
        if (this.permissions == null) {
            return false;
        }
        Iterator iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            if (!((Permission)iterator.next()).implies(permission)) continue;
            return true;
        }
        return false;
    }

    public void writeXML(PrintWriter writer, String indention) {
        writer.print(indention + "<group name=\"" + this.name + "\"");
        if (this.isDefault()) {
            writer.print(" default=\"true\"");
        }
        writer.println(">");
        if (this.description != null) {
            writer.println(indention + "\t<description>" + this.description + "</description>");
        }
        if (!this.permissions.isEmpty()) {
            Iterator iterator = this.permissions.iterator();
            while (iterator.hasNext()) {
                Permission permission = (Permission)iterator.next();
                boolean handled = false;
                if (permission instanceof AdministrationPermission) {
                    writer.println(indention + "\t<permission name=\"administration\" />");
                    handled = true;
                } else {
                    if (permission instanceof RMIPermission) {
                        if (permission.getName() != null) {
                            writer.println(indention + "\t<permission name=\"rmi:" + XMLUtils.encode(permission.getName()) + "\" />");
                        } else {
                            writer.println(indention + "\t<permission name=\"rmi\" />");
                        }
                    }
                    handled = true;
                }
                if (handled) continue;
                writer.println(indention + "\t<permission name=\"" + XMLUtils.encode(permission.getClass().getName()) + "\" />");
            }
        }
        writer.println(indention + "</group>");
    }

    public int compareTo(Object other) {
        if (!(other instanceof Group)) {
            return -1;
        }
        return this.name.compareTo(((Group)other).getName());
    }

    public String getDescription() {
        return this.description;
    }

    public Set getPermissions() {
        return this.permissions;
    }
}

