/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.Group;
import java.security.Permission;
import java.util.HashSet;
import java.util.Set;

public class MemoryGroup
implements Group {
    String name;
    Set permissions;
    String description;

    public MemoryGroup(String name) {
        this(name, null);
    }

    public MemoryGroup(String name, String description) {
        this.name = name;
        this.permissions = new HashSet();
        this.description = description;
    }

    public boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public Set getPermissions() throws UnsupportedOperationException {
        return this.permissions;
    }

    public void addPermission(Permission permission) throws UnsupportedOperationException {
        this.permissions.add(permission);
    }

    public void removePermission(Permission permission) throws UnsupportedOperationException {
        this.permissions.remove(permission);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }
}

