/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.security.UserManager;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractUserManager
implements UserManager {
    private Set defaultGroups;
    private Set defaultGroupNames;
    protected UserManager parent;

    public void init(Properties properties) throws InstantiationException {
    }

    public User getUser(String username) {
        if (this.parent != null) {
            return this.parent.getUser(username);
        }
        return null;
    }

    public User getAnonymousUser() {
        if (this.parent != null) {
            return this.parent.getAnonymousUser();
        }
        return null;
    }

    public Group getGroup(String name) {
        if (this.parent != null) {
            return this.parent.getGroup(name);
        }
        return null;
    }

    public void setParent(UserManager parent) {
        this.parent = parent;
    }

    public UserManager getParent() {
        return this.parent;
    }

    public User getAdminUser() {
        if (this.parent != null) {
            return this.parent.getAdminUser();
        }
        return null;
    }

    public void invalidate() {
    }

    public void create(URL url) {
    }

    public boolean isUpdated() {
        return false;
    }

    public void store() {
    }

    public void update() {
    }

    public boolean remove(User user) {
        return false;
    }

    public boolean remove(Group group) {
        return false;
    }

    public Set getDefaultGroups() {
        if (this.defaultGroupNames == null) {
            return Collections.EMPTY_SET;
        }
        if (this.defaultGroups == null) {
            this.defaultGroups = new HashSet();
            Iterator iterator = this.defaultGroupNames.iterator();
            while (iterator.hasNext()) {
                Group group = this.getGroup((String)iterator.next());
                if (group == null) continue;
                this.defaultGroups.add(group);
            }
        }
        return this.defaultGroups;
    }

    public void addDefaultGroup(String name) {
        if (this.defaultGroupNames == null) {
            this.defaultGroupNames = new HashSet();
        }
        this.defaultGroupNames.add(name);
        this.defaultGroups = null;
    }

    public User getUser(String issuerDN, BigInteger serial) {
        if (this.parent != null) {
            return this.parent.getUser(issuerDN, serial);
        }
        return null;
    }

    public User getUser(X509Certificate certificate) {
        return this.getUser(certificate.getIssuerDN().getName(), certificate.getSerialNumber());
    }

    public boolean containsDefaultGroup(String name) {
        if (this.defaultGroupNames == null) {
            return false;
        }
        return this.defaultGroupNames.contains(name);
    }

    public Group createGroup(String name) throws InstantiationException {
        if (this.parent != null) {
            return this.parent.createGroup(name);
        }
        throw new InstantiationException("This UserManager cannot create new groups");
    }

    public int getUserCount() {
        throw new UnsupportedOperationException("getUserCount() is not supported by this UserManager");
    }

    public int getGroupCount() {
        throw new UnsupportedOperationException("getGroupCount() is not supported by this UserManager");
    }

    public List getUsers(int start, int max) {
        throw new UnsupportedOperationException("getUsers() is not supported by this UserManager");
    }

    public List getGroups(int start, int max) {
        throw new UnsupportedOperationException("getGroups() is not supported by this UserManager");
    }

    public User createUser(String username, String password) throws InstantiationException, UserAlreadyExistsException {
        throw new UnsupportedOperationException("this UserManager cannot create users");
    }
}

