/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.parser.BooleanExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;
import com.evermind.parser.StringExpression;

public class StringNotEqualsExpression
implements BooleanExpression {
    private StringExpression left;
    private StringExpression right;

    public StringNotEqualsExpression(StringExpression left, StringExpression right) {
        this.left = left;
        this.right = right;
    }

    public int evaluate(ExpressionContext context) {
        String leftValue = this.left.evaluateString(context);
        String rightValue = this.right.evaluateString(context);
        if (leftValue == null || rightValue == null) {
            return 2;
        }
        return leftValue.equals(rightValue) ? 0 : 1;
    }

    public void write(StringBuffer buffer, ExpressionContext context, Expression enclosing) {
        buffer.append('(');
        this.left.write(buffer, context, this);
        buffer.append(' ');
        buffer.append(context.getBooleanNotEqualsSign());
        buffer.append(' ');
        this.right.write(buffer, context, this);
        buffer.append(')');
    }
}

