/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.parser.BooleanExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;
import com.evermind.parser.NumberExpression;

public class LessOrEqualsExpression
implements BooleanExpression {
    private NumberExpression left;
    private NumberExpression right;

    public LessOrEqualsExpression(NumberExpression left, NumberExpression right) {
        this.left = left;
        this.right = right;
    }

    public int evaluate(ExpressionContext context) {
        try {
            if (this.left.evaluate(context) <= this.right.evaluate(context)) {
                return 1;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    public void write(StringBuffer buffer, ExpressionContext context, Expression enclosing) {
        buffer.append('(');
        this.left.write(buffer, context, this);
        buffer.append(' ');
        buffer.append(context.getLessOrEqualsSign());
        buffer.append(' ');
        this.right.write(buffer, context, this);
        buffer.append(')');
    }
}

