/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.compiler.CompilationException;
import com.evermind.parser.AddExpressionType;
import com.evermind.parser.AndExpressionType;
import com.evermind.parser.AssignmentExpressionType;
import com.evermind.parser.ConstantBooleanExpressionType;
import com.evermind.parser.ConstantNumberExpressionType;
import com.evermind.parser.DivideExpressionType;
import com.evermind.parser.EqualsExpressionType;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionType;
import com.evermind.parser.LessExpressionType;
import com.evermind.parser.LessOrEqualsExpressionType;
import com.evermind.parser.LiteralStringExpressionType;
import com.evermind.parser.MoreExpressionType;
import com.evermind.parser.MoreOrEqualsExpressionType;
import com.evermind.parser.MultiplicationExpressionType;
import com.evermind.parser.NotEqualsExpressionType;
import com.evermind.parser.NotExpressionType;
import com.evermind.parser.OrExpressionType;
import com.evermind.parser.ParameterExpressionType;
import com.evermind.parser.PowerExpressionType;
import com.evermind.parser.SubExpressionType;
import com.evermind.parser.SubtractExpressionType;
import com.evermind.parser.VoidExpression;
import com.evermind.util.CharString;
import java.util.ArrayList;
import java.util.List;

public class ExpressionParser {
    private static final String[] BOOLEAN_NAME = new String[]{"false", "true", "unknown"};
    private static ExpressionType[] languageTypes;
    protected ExpressionType[] types;

    private static ExpressionType[] getLanguageTypes() {
        if (languageTypes == null) {
            languageTypes = new ExpressionType[]{new NotExpressionType("NOT"), new AndExpressionType("AND"), new OrExpressionType("OR"), new EqualsExpressionType("=="), new MoreExpressionType(">"), new MoreOrEqualsExpressionType(">="), new LessExpressionType("<"), new LessOrEqualsExpressionType("<="), new NotEqualsExpressionType("<>"), new AssignmentExpressionType("="), new PowerExpressionType("^"), new AddExpressionType("+"), new SubtractExpressionType("-"), new DivideExpressionType("/"), new MultiplicationExpressionType("*"), new SubExpressionType("(", ")"), new ConstantBooleanExpressionType("true", true, 1), new ConstantBooleanExpressionType("false", true, 0), new ConstantNumberExpressionType(), new LiteralStringExpressionType(), new ParameterExpressionType()};
        }
        return languageTypes;
    }

    public Expression parse(String string) throws CompilationException {
        return this.parse(this.parseParts(new CharString(string)));
    }

    public Expression parse(CharString string) throws CompilationException {
        return this.parse(this.parseParts(string));
    }

    protected ExpressionType[] getExpressionTypes() {
        if (this.types == null) {
            this.types = ExpressionParser.getLanguageTypes();
        }
        return this.types;
    }

    protected void setExpressionTypes(ExpressionType[] types) {
        this.types = types;
    }

    public Expression parse(List parts) throws CompilationException {
        if (parts.size() == 0) {
            return new VoidExpression();
        }
        ExpressionType[] types = this.getExpressionTypes();
        for (int i = 0; i < types.length; ++i) {
            for (int x = 0; x < parts.size(); ++x) {
                if (!types[i].implies((String)parts.get(x))) continue;
                List leftParts = parts.subList(0, x);
                List rightParts = parts.subList(x + 1, parts.size());
                return types[i].parse(this, (String)parts.get(x), this.parse(leftParts), this.parse(rightParts));
            }
        }
        throw new CompilationException("Unparsable block of code: " + parts);
    }

    public List parseParts(String string) throws CompilationException {
        return this.parseParts(new CharString(string));
    }

    public List parseParts(CharString string) throws CompilationException {
        ArrayList<CharString> parts = new ArrayList<CharString>();
        int startIndex = 0;
        int pos = 0;
        int length = string.length();
        char currentChar = ' ';
        while (true) {
            if (startIndex < length) {
                char c = string.charAt(startIndex);
                currentChar = c;
                if (c == ' ' || currentChar == '\n' || currentChar == '\t' || currentChar == '\r') {
                    ++startIndex;
                    continue;
                }
            }
            if (startIndex == length) break;
            pos = startIndex;
            if (currentChar == '\"') {
                do {
                    if (++pos != length) continue;
                    throw new CompilationException("Unterminated literal");
                } while (string.charAt(pos) != '\"');
                parts.add(string.substring(startIndex, ++pos));
                startIndex = pos;
                continue;
            }
            if (currentChar == '\'') {
                do {
                    if (++pos != length) continue;
                    throw new CompilationException("Unterminated literal");
                } while (string.charAt(pos) != '\'');
                parts.add(string.substring(startIndex, ++pos));
                startIndex = pos;
                continue;
            }
            if (currentChar == '(') {
                int depth = 1;
                while (true) {
                    if (++pos == length) {
                        throw new CompilationException("Unterminated subcontext, missing ')'");
                    }
                    if (string.charAt(pos) == '(') {
                        ++depth;
                        continue;
                    }
                    if (string.charAt(pos) == ')' && depth-- == 1) break;
                }
                parts.add(string.substring(startIndex, ++pos));
                startIndex = pos;
                continue;
            }
            if (Character.isJavaIdentifierPart(currentChar) || string.charAt(pos) == '.') {
                while (++pos != length && (Character.isJavaIdentifierPart(string.charAt(pos)) || string.charAt(pos) == '.')) {
                }
                parts.add(string.substring(startIndex, pos));
                startIndex = pos;
                continue;
            }
            if (currentChar == '<') {
                startIndex = ++pos;
                if (pos < length && string.charAt(pos) == '=') {
                    startIndex = ++pos;
                    parts.add(string.substring(pos - 2, pos));
                    continue;
                }
                if (pos < length && string.charAt(pos) == '>') {
                    startIndex = ++pos;
                    parts.add(string.substring(pos - 2, pos));
                    continue;
                }
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '!') {
                startIndex = ++pos;
                if (pos < length && string.charAt(pos) == '=') {
                    startIndex = ++pos;
                    parts.add(string.substring(pos - 2, pos));
                    continue;
                }
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '>') {
                startIndex = ++pos;
                if (pos < length && string.charAt(pos) == '=') {
                    startIndex = ++pos;
                    parts.add(string.substring(pos - 2, pos));
                    continue;
                }
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '=') {
                startIndex = ++pos;
                if (pos < length && string.charAt(pos) == '=') {
                    startIndex = ++pos;
                    parts.add(string.substring(pos - 2, pos));
                    continue;
                }
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '+') {
                String previousItem;
                String string2 = previousItem = parts.size() == 0 ? "*" : (String)parts.get(parts.size() - 1);
                if (previousItem.equals("^") || previousItem.equals("*") || previousItem.equals("-") || previousItem.equals("/") || previousItem.equals("+")) {
                    while (++pos != length && (Character.isJavaIdentifierPart(string.charAt(pos)) || string.charAt(pos) == '.')) {
                    }
                    parts.add(string.substring(startIndex, pos));
                    startIndex = pos;
                    continue;
                }
                startIndex = ++pos;
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '*') {
                startIndex = ++pos;
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '/') {
                startIndex = ++pos;
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '^') {
                startIndex = ++pos;
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            if (currentChar == '-') {
                String previousItem;
                String string3 = previousItem = parts.size() == 0 ? "*" : (String)parts.get(parts.size() - 1);
                if (previousItem.equals("^") || previousItem.equals("*") || previousItem.equals("-") || previousItem.equals("/") || previousItem.equals("+")) {
                    while (++pos != length && (Character.isJavaIdentifierPart(string.charAt(pos)) || string.charAt(pos) == '.')) {
                    }
                    parts.add(string.substring(startIndex, pos));
                    startIndex = pos;
                    continue;
                }
                startIndex = ++pos;
                parts.add(string.substring(pos - 1, pos));
                continue;
            }
            startIndex = ++pos;
            parts.add(string.substring(pos - 1, pos));
        }
        return this.processParts(parts);
    }

    protected List processParts(List parts) throws CompilationException {
        return parts;
    }
}

