/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.compiler.CompilationException;
import com.evermind.parser.BooleanEqualsExpression;
import com.evermind.parser.BooleanExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionParser;
import com.evermind.parser.ExpressionType;
import com.evermind.parser.NumberEqualsExpression;
import com.evermind.parser.NumberExpression;
import com.evermind.parser.StringEqualsExpression;
import com.evermind.parser.StringExpression;

public class EqualsExpressionType
implements ExpressionType {
    private String token;

    public EqualsExpressionType(String token) {
        this.token = token;
    }

    public boolean implies(String keyword) {
        return keyword.equals(this.token);
    }

    public Expression parse(ExpressionParser parser, String token, Expression left, Expression right) throws CompilationException {
        if (left instanceof NumberExpression && right instanceof NumberExpression) {
            return new NumberEqualsExpression((NumberExpression)left, (NumberExpression)right);
        }
        if (left instanceof BooleanExpression && right instanceof BooleanExpression) {
            return new BooleanEqualsExpression((BooleanExpression)left, (BooleanExpression)right);
        }
        if (left instanceof StringExpression && right instanceof StringExpression) {
            return new StringEqualsExpression((StringExpression)left, (StringExpression)right);
        }
        throw new CompilationException("Can only compare number <-> number, boolean <-> boolean or string <-> string");
    }
}

