/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.parser.BooleanExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;

public class AndExpression
implements BooleanExpression {
    private BooleanExpression left;
    private BooleanExpression right;

    public AndExpression(BooleanExpression left, BooleanExpression right) {
        this.left = left;
        this.right = right;
    }

    public int evaluate(ExpressionContext context) {
        int leftValue = this.left.evaluate(context);
        int rightValue = this.right.evaluate(context);
        if (leftValue == 2 || rightValue == 2) {
            return 2;
        }
        if (leftValue == 1 && rightValue == 1) {
            return 1;
        }
        return 0;
    }

    public void write(StringBuffer buffer, ExpressionContext context, Expression enclosing) {
        buffer.append('(');
        this.left.write(buffer, context, this);
        buffer.append(context.getAndSign());
        this.right.write(buffer, context, this);
        buffer.append(')');
    }
}

