/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net.socket;

import com.evermind.io.LightPipedInputStream;
import com.evermind.io.LightPipedOutputStream;
import com.evermind.net.socket.SocketTarget;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemorySocketImpl
extends SocketImpl {
    private static Map sockets = new HashMap();
    private LightPipedInputStream in;
    private OutputStream out;
    private SocketImpl trail;
    private MemorySocketImpl peer;
    private boolean closed;
    private List queue;

    public void create(boolean b) {
    }

    public void connect(String address, int port) throws IOException {
        this.connect(InetAddress.getByName(address), port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(InetAddress address, int port) throws IOException {
        Map map = sockets;
        synchronized (map) {
            MemorySocketImpl impl = (MemorySocketImpl)sockets.get(new SocketTarget(address, port));
            if (impl == null) {
                throw new SocketException("Connection refused (no socket listening on that port)");
            }
            this.address = address;
            this.port = port;
            impl.connect(this);
        }
    }

    public void connect(SocketAddress address, int port) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(InetAddress address, int port) throws IOException {
        SocketTarget target = new SocketTarget(InetAddress.getByName("0.0.0.0"), port);
        Map map = sockets;
        synchronized (map) {
            if (sockets.containsKey(target)) {
                throw new SocketException("Address already in use");
            }
            sockets.put(target, this);
            this.address = address;
            this.port = port;
            this.localport = port;
            this.queue = new ArrayList();
        }
    }

    public void listen(int port) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SocketImpl genericImpl) throws IOException {
        MemorySocketImpl impl = (MemorySocketImpl)genericImpl;
        List list = this.queue;
        synchronized (list) {
            try {
                while (!this.closed) {
                    if (!this.queue.isEmpty()) {
                        MemorySocketImpl other;
                        MemorySocketImpl memorySocketImpl = other = (MemorySocketImpl)this.queue.remove(0);
                        synchronized (memorySocketImpl) {
                            other.setPeer(impl);
                            impl.setPeer(other);
                            other.notify();
                            return;
                        }
                    }
                    this.queue.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new SocketException("Socket was closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MemorySocketImpl request) throws IOException {
        Object object = this.queue;
        synchronized (object) {
            this.queue.add(request);
            this.queue.notify();
        }
        try {
            object = request;
            synchronized (object) {
                while (!request.closed && request.peer == null) {
                    request.wait();
                }
                if (request.peer != null) {
                    return;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new SocketException("Connection refused (socket closed)");
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.localport > 0) {
            Object object = sockets;
            synchronized (object) {
                sockets.remove(new SocketTarget(this.address, this.localport));
            }
            object = this.queue;
            synchronized (object) {
                while (!this.queue.isEmpty()) {
                    MemorySocketImpl request;
                    MemorySocketImpl memorySocketImpl = request = (MemorySocketImpl)this.queue.remove(0);
                    synchronized (memorySocketImpl) {
                        request.closed = true;
                        request.notify();
                    }
                }
            }
        }
        if (this.peer != null && !this.peer.closed) {
            this.peer.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public Object getOption(int option) {
        if (option == 4102 && this.in != null) {
            return new Long(this.in.getTimeout());
        }
        return null;
    }

    public void setOption(int option, Object object) {
        if (option == 4102 && this.in != null) {
            this.in.setTimeout(((Number)object).longValue());
        }
    }

    public void setPeer(MemorySocketImpl peer) throws IOException {
        this.peer = peer;
        LightPipedOutputStream pipeOut = new LightPipedOutputStream();
        this.out = pipeOut;
        peer.in = pipeOut.getInputStream();
    }

    public void sendUrgentData(int mode) {
    }
}

