/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net.http;

import com.evermind.net.http.HttpTunnelConnection;
import java.io.IOException;
import java.io.InputStream;

public class HttpTunnelInputStream
extends InputStream {
    private InputStream in;
    private byte[] buffer = new byte[4096];
    private int pos;
    private int bufferSize;
    private boolean closed;
    private HttpTunnelConnection connection;

    public HttpTunnelInputStream(InputStream in, HttpTunnelConnection connection) throws IOException {
        this.in = in;
        this.connection = connection;
        this.readToHeaderEnd();
    }

    protected void readToHeaderEnd() throws IOException {
        int found = 0;
        boolean foundMode = false;
        while (this.pos >= this.bufferSize) {
            this.readChunk();
            if (!this.closed) continue;
            throw new IOException("Did not receive valid HTTP headers");
        }
        while (true) {
            String line;
            if (!(found & true) ? this.buffer[this.pos] == 13 : this.buffer[this.pos] == 10) {
                ++this.pos;
                if (++found != 4) continue;
                break;
            }
            found = 0;
            int lineStartPos = this.pos;
            while (true) {
                if (this.pos >= this.bufferSize) {
                    this.readChunk();
                    if (!this.closed) continue;
                    throw new IOException("Did not receive valid HTTP headers");
                }
                if (this.buffer[this.pos] == 13 || this.buffer[this.pos] == 10 || this.buffer[this.pos] == 0) break;
                ++this.pos;
            }
            if (lineStartPos >= this.pos || (line = new String(this.buffer, lineStartPos, this.pos - lineStartPos).toLowerCase()).indexOf("tunnel-mode") < 0) continue;
            foundMode = true;
        }
        if (!foundMode) {
            throw new IOException("The specified URL, " + this.connection.getURL() + " does not seem to be a Tunnelling URL, make sure you have installed the proper http-tunnelling servlet on the server");
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        while (this.pos >= this.bufferSize) {
            this.readChunk();
            if (!this.closed) continue;
            return -1;
        }
        return (char)this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] target, int start, int length) throws IOException {
        if (this.closed) {
            return -1;
        }
        while (this.pos >= this.bufferSize) {
            this.readChunk();
            if (!this.closed) continue;
            return -1;
        }
        if (length > this.bufferSize - this.pos) {
            int read = this.bufferSize - this.pos;
            System.arraycopy(this.buffer, this.pos, target, start, read);
            this.pos += read;
            return read;
        }
        System.arraycopy(this.buffer, this.pos, target, start, length);
        this.pos += length;
        return length;
    }

    protected void readChunk() throws IOException {
        int lengthRead;
        if (this.pos > this.bufferSize) {
            throw new IOException("Pos was more than bufferSize");
        }
        if (this.pos > 2048) {
            System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.bufferSize - this.pos);
            this.bufferSize -= this.pos;
            this.pos = 0;
        }
        if ((lengthRead = this.in.read(this.buffer, this.pos, this.buffer.length - this.pos)) < 0) {
            this.closed = true;
            return;
        }
        this.bufferSize += lengthRead;
    }
}

