/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import com.evermind.net.AccessRegion;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.net.InetAddress;
import org.w3c.dom.Node;

public class HostAccessRegion
extends AccessRegion
implements XMLizable {
    private String m_host;

    public HostAccessRegion(Node node) throws InstantiationException {
        super(XMLUtils.getNodeAttribute(node, "mode"), false);
        this.m_host = XMLUtils.getNodeAttribute(node, "domain");
        if (this.m_host == null) {
            throw new InstantiationException("No 'domain' attribute specified in <m_host-access> tag");
        }
        this.m_isLocalHost = HostAccessRegion.isLocalHost(this.m_host);
    }

    public HostAccessRegion(String host, boolean allow) {
        super(allow, HostAccessRegion.isLocalHost(host));
        this.m_host = host;
    }

    public boolean implies(InetAddress address, boolean isLocalHost) {
        return this.m_isLocalHost && isLocalHost;
    }

    public boolean implies(String host, boolean isLocalHost) {
        if (this.m_isLocalHost && isLocalHost) {
            return true;
        }
        return host.endsWith(this.m_host);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HostAccessRegion)) {
            return false;
        }
        return this.m_host.equals(((HostAccessRegion)object).m_host);
    }

    public int hashCode() {
        return this.m_host.hashCode();
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<host-access domain=\"" + XMLUtils.encode(this.m_host) + "\" mode=\"" + (this.m_allow ? "allow" : "deny") + "\" />");
    }
}

