/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind.naming.file.FileContext;
import com.evermind.util.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

public class SerializableFileContext
extends FileContext {
    private ClassLoader classLoader;

    public SerializableFileContext(File root, Map environment) {
        super(root, environment);
    }

    public SerializableFileContext(File root, Map environment, ClassLoader loader) {
        super(root, environment);
        this.classLoader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(File file) throws IOException, NamingException {
        Object object;
        FileInputStream in = new FileInputStream(file);
        try {
            object = ObjectUtils.getObject(in, this.getClassLoader());
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new NamingException("ClassNotFoundException: " + e.getMessage());
            }
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return object;
    }

    protected void writeObject(File file, Object object) throws IOException {
        file.createNewFile();
    }

    protected ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            if (this.environment != null) {
                try {
                    this.classLoader = (ClassLoader)this.environment.get("class.loader");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public Context createSubContext(File file) {
        return new SerializableFileContext(file, this.environment == null ? null : new Hashtable(this.environment), this.getClassLoader());
    }
}

