/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind.io.IOUtils;
import com.evermind.naming.file.FileContext;
import com.evermind.util.ByteString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

public class ContentFileContext
extends FileContext {
    public ContentFileContext(File root, Map environment) {
        super(root, environment);
    }

    protected Object getObject(File file) throws IOException, NamingException {
        return IOUtils.getContent(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeObject(File file, Object value) throws IOException, NamingException {
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                if (value instanceof InputStream) {
                    IOUtils.pipe((InputStream)value, out);
                } else if (value instanceof ByteString) {
                    ByteString string = (ByteString)value;
                    ((OutputStream)out).write(string.data, string.offset, string.length);
                } else {
                    byte[] data;
                    if (value instanceof byte[]) {
                        data = (byte[])value;
                    } else if (value instanceof String) {
                        data = ((String)value).getBytes();
                    } else {
                        throw new NamingException("Bound objects must be of type byte[]");
                    }
                    ((OutputStream)out).write(data);
                }
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }

    public Context createSubContext(File file) {
        return new ContentFileContext(file, this.environment == null ? null : new Hashtable(this.environment));
    }
}

